/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.cloudUpdate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.cloudUpdate.entity.ApiInfoDto;
import kd.bos.openapi.form.plugin.cloudUpdate.entity.ApiInfoResultDto;
import kd.bos.openapi.form.plugin.cloudUpdate.entity.ApiResourceQueryDto;
import kd.bos.openapi.form.plugin.cloudUpdate.entity.ApiResourceQueryParamDto;
import kd.bos.openapi.form.plugin.cloudUpdate.entity.ApiResourceQueryResultDto;
import kd.bos.openapi.form.plugin.cloudUpdate.service.ApiResourceServiceFactory;
import kd.bos.openapi.form.util.TreeNodeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;

public class OpenApiCloudUpdatePlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener,
AfterF7SelectListener {
    private static final Log log = LogFactory.getLog(OpenApiCloudUpdatePlugin.class);
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CLOSE = "btnclose";
    private static final String KEY_BTN_REFRESH = "btnrefresh";
    private static final String OPENAPI_CLOUDID = "openapi_cloudId";
    private static final String CH_CLOUD = "chcloud";
    private static final String TREE_VIEW = "treeview";
    private static final String ID = "Id";
    public static final String THIRDNUMBER = "apidownid";
    public static final String ENTRYENTITY = "entryentity";
    public static final String IMPORT_API = "importapi";
    private static final String BILL_LIST_STAP = "billlistap";
    private static final Integer PAGESIZE = Integer.MAX_VALUE;
    private static final String CALLBACK_CLOUD_UPDATE = "CLOUD_UPDATE";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CLOSE, KEY_BTN_REFRESH});
        BasedataEdit edit = (BasedataEdit)this.getControl(CH_CLOUD);
        edit.addAfterF7SelectListener((AfterF7SelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
    }

    public void onGetControl(OnGetControlArgs e) {
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)ENTRYENTITY)) {
            MyEntryGridControl entryGrid = new MyEntryGridControl();
            entryGrid.setView(this.getView());
            entryGrid.setKey(ENTRYENTITY);
            entryGrid.setEntryKey(ENTRYENTITY);
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                this.findControl(ENTRYENTITY);
            }
            if (oldGrid instanceof EntryGrid) {
                entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeView tv1 = (TreeView)this.getView().getControl(TREE_VIEW);
        this.getView().getPageCache().remove(CH_CLOUD);
        tv1.deleteAllNodes();
        this.treeApp();
        this.queryApiListByQueryCondtion(new HashMap<String, Object>());
    }

    private void treeApp() {
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        TreeNode rootNode = TreeNodeUtil.buildAppTree(this.getView());
        this.getTreeModel().setRoot(rootNode);
        this.getTreeModel().setCurrentNodeId((Object)rootNode.getId());
        this.getView().updateView(TREE_VIEW);
        billList.clearSelection();
        billList.refresh();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        super.click((EventObject)evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(KEY_BTN_OK)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = entry.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9API\u3002", (String)"OpenApiCloudUpdatePlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectRows.length > 100) {
                ConfirmCallBackListener callbackid = new ConfirmCallBackListener(CALLBACK_CLOUD_UPDATE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e91\u66f4\u65b0\u5355\u6b21\u540c\u6b65\u9650\u5236100\u6761\uff0c\u60a8\u7684\u52fe\u9009\u5df2\u8d85\u91cf\uff0c\u5c06\u5148\u540c\u6b65\u524d100\u6761\u6570\u636e\uff0c\u662f\u5426\u786e\u5b9a\uff1f", (String)"OpenApiCloudUpdatePlugin_11", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, callbackid);
            } else {
                this.cloudUpdateData(selectRows);
            }
        }
    }

    private void cloudUpdateData(int[] selectRows) {
        ArrayList<Long> ids = new ArrayList<Long>(selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            ids.add(Long.parseLong(this.getModel().getValue("id", selectRows[i]).toString()));
        }
        try {
            ApiInfoResultDto data = this.queryApi(ids);
            if (data == null || data.getApiDataList() == null || data.getApiDataList().size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e91\u7aef\u6ca1\u6709\u627e\u5230API\u4fe1\u606f\u3002", (String)"OpenApiCloudUpdatePlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("openapi_importing");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("jsonFromResourceCloud", (Object)data.getApiDataList().get(0));
            showParameter.setCustomParam("isFromResourceCloud", (Object)Boolean.TRUE);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_API));
            showParameter.setCaption(ResManager.loadKDString((String)"\u66f4\u65b0API", (String)"OpenApiCloudUpdatePlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
            this.getView().showForm(showParameter);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (callBackId.equals(CALLBACK_CLOUD_UPDATE) && result.equals((Object)MessageBoxResult.Yes)) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = entry.getSelectRows();
            if (selectRows.length > 100) {
                selectRows = Arrays.stream(selectRows).limit(100L).toArray();
            }
            this.cloudUpdateData(selectRows);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(KEY_BTN_REFRESH)) {
            this.refreshList();
        }
    }

    private void refreshList() {
        TreeView tv1 = (TreeView)this.getView().getControl(TREE_VIEW);
        String treeNodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (null != this.getModel().getValue(CH_CLOUD) && StringUtils.isNotEmpty((CharSequence)treeNodeId)) {
            DynamicObject chcloud = (DynamicObject)this.getModel().getValue(CH_CLOUD);
            tv1.deleteAllNodes();
            this.buildTreeByCloud(tv1, chcloud.getString(ID));
            if (StringUtils.isNotEmpty((CharSequence)this.getView().getPageCache().get(treeNodeId))) {
                tv1.focusNode(new TreeNode(null, this.getView().getPageCache().get(treeNodeId), null));
                tv1.treeNodeClick("", this.getView().getPageCache().get(treeNodeId));
            } else {
                tv1.treeNodeClick("", treeNodeId);
                tv1.focusNode(new TreeNode(null, treeNodeId, null));
            }
            this.getView().getPageCache().put(CH_CLOUD, chcloud.getString(ID));
        } else if (null == this.getModel().getValue(CH_CLOUD) && StringUtils.isNotEmpty((CharSequence)treeNodeId) && treeNodeId.equals("allApp")) {
            TreeNodeUtil.buildAppTree(this.getView());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.getView().getPageCache().remove(CH_CLOUD);
        if (null != e.getNodeId() && null != e.getParentNodeId()) {
            this.getView().getPageCache().put(e.getNodeId().toString(), e.getParentNodeId().toString());
            String nodeId = e.getNodeId().toString();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            if ("".equalsIgnoreCase(nodeId)) {
                if (this.getModel().getValue(CH_CLOUD) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u7528\u6811\u6b63\u5728\u52a0\u8f7d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"OpenApiCloudUpdatePlugin_10", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    return;
                }
                dataMap.put("appid_bizcloud_id", ((DynamicObject)this.getModel().getValue(CH_CLOUD)).getString(ID));
            } else if (!nodeId.equalsIgnoreCase("allApp") && nodeId.contains("app_")) {
                if (nodeId.contains("biz_")) {
                    dataMap.put("appid_id", StringUtils.substringBetween((String)nodeId, (String)"app_", (String)"_biz"));
                    dataMap.put("bizobject_number", StringUtils.substringAfter((String)nodeId, (String)"biz_"));
                } else if (nodeId.contains("cus_")) {
                    dataMap.put("appid_id", StringUtils.substringBetween((String)nodeId, (String)"app_", (String)"_cus"));
                    dataMap.put("customsort_id", StringUtils.substringAfter((String)nodeId, (String)"cus_"));
                } else {
                    dataMap.put("appid_id", StringUtils.substringAfter((String)nodeId, (String)"app_"));
                }
            }
            this.queryApiListByQueryCondtion(dataMap);
        }
    }

    private void queryApiListByQueryCondtion(Map<String, Object> dataMap) {
        String filter = JsonUtil.toJsonString(dataMap, (SerializerFeature[])new SerializerFeature[0]);
        this.getPageCache().put("filter", filter);
        try {
            List<Long> ids = this.findAllIdByCondtion(dataMap);
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            ApiResourceQueryResultDto resourceQueryResultDto = this.queryApiListByPage(ids, PAGESIZE, 1);
            this.buildEntity(resourceQueryResultDto);
            entry.setPageIndex(1);
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private List<Long> findAllIdByCondtion(Map<String, Object> dataMap) {
        String filter = JsonUtil.toJsonString(dataMap, (SerializerFeature[])new SerializerFeature[0]);
        String idsStr = this.getPageCache().get(filter);
        if (StringUtil.isNotEmpty((String)idsStr) && !idsStr.equals("[]")) {
            return (List)JSON.parse((String)idsStr);
        }
        List<Long> ids = this.queryAllApiInfo(dataMap);
        if (!CollectionUtils.isEmpty(ids)) {
            this.getPageCache().put(filter, JsonUtil.toJsonString(ids, (SerializerFeature[])new SerializerFeature[0]));
        }
        return ids;
    }

    private List<Long> queryAllApiInfo(Map<String, Object> dataMap) {
        ArrayList<Long> ids = new ArrayList();
        String isvId = ISVServiceHelper.getISVInfo().getId();
        ApiResourceQueryDto apiResourceQueryDto = new ApiResourceQueryDto();
        ApiResourceQueryParamDto paramDto = new ApiResourceQueryParamDto();
        paramDto.setIsvid(isvId);
        if (StringUtil.isNotEmpty((String)D.s((Object)dataMap.get("appid_bizcloud_id")))) {
            paramDto.setCloudCode(this.getCloudCode(D.s((Object)dataMap.get("appid_bizcloud_id"))));
        }
        if (StringUtil.isNotEmpty((String)D.s((Object)dataMap.get("bizobject_number")))) {
            paramDto.setObjCode((String)dataMap.get("bizobject_number"));
        }
        if (StringUtil.isNotEmpty((String)D.s((Object)dataMap.get("customsort_id")))) {
            paramDto.setCustomsortCode(this.getCustomCode(D.s((Object)dataMap.get("customsort_id"))));
        }
        if (StringUtil.isNotEmpty((String)D.s((Object)dataMap.get("appid_id")))) {
            paramDto.setAppCode(this.getAppCode(D.s((Object)dataMap.get("appid_id"))));
        }
        apiResourceQueryDto.setData(paramDto);
        apiResourceQueryDto.setPageNo(1);
        apiResourceQueryDto.setPageSize(10000);
        ApiResourceQueryResultDto resourceQueryResultDto = ApiResourceServiceFactory.getApiResourceClientService().findApiByPage(apiResourceQueryDto);
        ids = this.getIdsFilter(resourceQueryResultDto);
        return ids;
    }

    private String getCloudCode(String cloudId) {
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)cloudId, (String)"bos_devportal_bizcloud", (String)"id,number");
        if (dy != null) {
            return dy.getString("number");
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, "cannot load data for cloudId:" + cloudId, new Object[0]);
    }

    private String getAppCode(String appId) {
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)appId, (String)"bos_devportal_bizapp", (String)"id,number");
        if (dy != null) {
            return dy.getString("number");
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, "cannot load data for appId:" + appId, new Object[0]);
    }

    private String getCustomCode(String customsortId) {
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)customsortId, (String)"openapi_custom_sort", (String)"id,number");
        if (dy != null) {
            return dy.getString("number");
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, "cannot load data for customsortId:" + customsortId, new Object[0]);
    }

    private List<Long> getIdsFilter(ApiResourceQueryResultDto resourceQueryResultDto) {
        ArrayList<Long> result = new ArrayList<Long>();
        ArrayList<Long> ids = new ArrayList<Long>();
        resourceQueryResultDto.getApiList().forEach(api -> ids.add(api.getApiId()));
        Map<Long, Date> longStringMap = this.queryLocalApiById(ids);
        resourceQueryResultDto.getApiList().forEach(api -> {
            try {
                int type = this.compareTime((Date)longStringMap.get(api.getApiId()), api.getStdmodifytime());
                if (type < 3) {
                    result.add(api.getApiId());
                }
            }
            catch (ParseException e) {
                log.error(e.getMessage());
            }
        });
        return result;
    }

    private void buildEntity(ApiResourceQueryResultDto resourceQueryResultDto) {
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        entryEntities.clear();
        Integer totalCount = resourceQueryResultDto.getTotalCount().intValue();
        if (totalCount == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        resourceQueryResultDto.getApiList().forEach(api -> ids.add(api.getApiId()));
        Map<Long, Date> longStringMap = this.queryLocalApiById(ids);
        resourceQueryResultDto.getApiList().forEach(api -> {
            DynamicObject dynamicObject = entryEntities.addNew();
            dynamicObject.set("number", (Object)api.getNumber());
            String nameML = "";
            if (!CollectionUtil.isEmpty(api.getNameML())) {
                nameML = StringUtil.isEmpty((String)api.getNameML().get(String.valueOf(RequestContext.get().getLang()))) ? api.getNameML().get(String.valueOf(Lang.defaultLang())) : api.getNameML().get(String.valueOf(RequestContext.get().getLang()));
                nameML = StringUtil.isEmpty((String)nameML) ? api.getName() : nameML;
            }
            dynamicObject.set("name", (Object)nameML);
            dynamicObject.set("app", (Object)api.getAppName());
            dynamicObject.set("httpmethod", (Object)(api.getHttpmethod() == "0" ? "GET" : "POST"));
            dynamicObject.set("url", (Object)api.getUrlformat());
            dynamicObject.set("cosmicver", (Object)api.getCosmicver());
            dynamicObject.set("apiservicetype", (Object)api.getApiservicetype());
            dynamicObject.set("bizobject", (Object)api.getObjName());
            dynamicObject.set("isvid", (Object)api.getIsvid());
            dynamicObject.set("id", (Object)api.getApiId());
            try {
                dynamicObject.set("cloudmodifytime", (Object)api.getStdmodifytime());
                dynamicObject.set("localmodifytime", longStringMap.get(api.getApiId()));
                dynamicObject.set("type", (Object)this.compareTime((Date)longStringMap.get(api.getApiId()), api.getStdmodifytime()));
            }
            catch (ParseException e) {
                log.error(e.getMessage());
            }
        });
        this.getModel().getDataEntity(true).getDataEntityState().setEntryRowCount(ENTRYENTITY, totalCount.intValue());
    }

    private int compareTime(Date localTime, Date cloudTime) throws ParseException {
        long cloudtime;
        long localtime = localTime != null ? localTime.getTime() : 0L;
        long l = cloudtime = cloudTime != null ? cloudTime.getTime() : 0L;
        int result = localtime != 0L && cloudtime != 0L && localtime < cloudtime ? 2 : (localtime == 0L ? 1 : 3);
        return result;
    }

    private Map<Long, Date> queryLocalApiById(List<Long> ids) {
        if (ids.size() == 0) {
            return null;
        }
        DynamicObject[] apis = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)"stdmodifytime,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids.toArray())});
        HashMap<Long, Date> map = new HashMap<Long, Date>(apis.length);
        for (DynamicObject api : apis) {
            map.put(api.getLong("id"), api.getDate("stdmodifytime"));
        }
        return map;
    }

    public void afterF7Select(AfterF7SelectEvent arg) {
        TreeView tv1 = (TreeView)this.getView().getControl(TREE_VIEW);
        if (null == this.getModel().getValue(CH_CLOUD)) {
            TreeNode root = TreeNodeUtil.buildAppTree(this.getView());
            this.getTreeModel().setRoot(root);
            this.getTreeModel().setCurrentNodeId((Object)root.getId());
            this.getView().updateView(TREE_VIEW);
            this.defaultClickFirstNode(root.getChildren());
        } else {
            DynamicObject cloud = (DynamicObject)this.getModel().getValue(CH_CLOUD);
            tv1.deleteAllNodes();
            this.cacheBuilder(cloud.getString(ID));
            this.buildTreeByCloud(tv1, cloud.getString(ID));
            this.getView().getPageCache().put(CH_CLOUD, cloud.getString(ID));
        }
    }

    private void cacheBuilder(String chCloudId) {
        String tenantCode = RequestContext.get().getTenantCode();
        IAppCache cache = AppCache.get((String)(tenantCode + ((Object)((Object)this)).getClass().getName()));
        cache.put(OPENAPI_CLOUDID, (Object)chCloudId);
    }

    private String getCacheCloud() {
        String tenantCode = RequestContext.get().getTenantCode();
        IAppCache cache = AppCache.get((String)(tenantCode + ((Object)((Object)this)).getClass().getName()));
        return (String)cache.get(OPENAPI_CLOUDID, String.class);
    }

    private void buildTreeByCloud(TreeView tv1, String cloudID) {
        TreeNode root = TreeNodeUtil.buildTreeByCloud(tv1, cloudID);
        this.getTreeModel().setRoot(root);
        this.getView().updateView(TREE_VIEW);
        this.defaultClickFirstNode(root.getChildren());
    }

    private void defaultClickFirstNode(List<TreeNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        for (TreeNode node : nodes) {
            List childNodes = node.getChildren();
            if (CollectionUtils.isEmpty((Collection)childNodes)) continue;
            TreeNode showApiInfoNode = (TreeNode)childNodes.get(0);
            treeView.showNode(showApiInfoNode.getParentid());
            treeView.focusNode(showApiInfoNode);
            treeView.treeNodeClick(showApiInfoNode.getParentid(), showApiInfoNode.getId());
            return;
        }
        treeView.focusNode(nodes.get(0));
        treeView.treeNodeClick(nodes.get(0).getParentid(), nodes.get(0).getId());
    }

    private ApiResourceQueryResultDto queryApiListByPage(List<Long> apiIdList, Integer pageSize, Integer pageNo) {
        if (CollectionUtils.isEmpty(apiIdList)) {
            ApiResourceQueryResultDto resultDto = new ApiResourceQueryResultDto();
            resultDto.setTotalCount(0L);
            return resultDto;
        }
        ApiResourceQueryDto apiResourceQueryDto = new ApiResourceQueryDto();
        ApiResourceQueryParamDto paramDto = new ApiResourceQueryParamDto();
        paramDto.setApiIdList(apiIdList);
        apiResourceQueryDto.setData(paramDto);
        apiResourceQueryDto.setPageNo(pageNo);
        apiResourceQueryDto.setPageSize(pageSize);
        ApiResourceQueryResultDto resourceQueryResultDto = ApiResourceServiceFactory.getApiResourceClientService().findApiByPage(apiResourceQueryDto);
        if (resourceQueryResultDto == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e91\u7aefAPI\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OpenApiCloudUpdatePlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
        return resourceQueryResultDto;
    }

    private ApiInfoResultDto queryApi(List<Long> ids) throws Exception {
        ApiInfoDto apiInfoDto = new ApiInfoDto();
        apiInfoDto.setApiIdList(ids);
        ApiInfoResultDto resultDto = ApiResourceServiceFactory.getApiResourceClientService().findApi(apiInfoDto);
        return resultDto;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals(IMPORT_API) && null != event.getReturnData() && event.getReturnData().equals(Boolean.TRUE)) {
            String filter = this.getPageCache().get("filter");
            this.getPageCache().remove(filter);
            Map dataMap = (Map)JSON.parse((String)filter);
            this.queryApiListByQueryCondtion(dataMap);
        }
    }

    @Deprecated
    public static String getCloudValue(String key) {
        String properties = "number,name,publickey,status,fileserver,server_accountid,phone,server_url,tenantid,accountid";
        DynamicObject apply = BusinessDataServiceHelper.loadSingle((String)"iscr_app_apply", (String)properties, (QFilter[])new QFilter[0]);
        if (apply == null) {
            throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"OpenApiCloudUpdatePlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        if (!"B".equals(apply.get("status"))) {
            throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"OpenApiCloudUpdatePlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        if (!OpenApiCloudUpdatePlugin.isMatchEnvironment(apply)) {
            throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u7684\u79df\u6237ID\u6216\u8d26\u5957ID\u4e0e\u7533\u8bf7\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"OpenApiCloudUpdatePlugin_5", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        log.info(key + "===" + apply.getString(key));
        return apply.getString(key);
    }

    @Deprecated
    public static boolean isMatchEnvironment(DynamicObject apply) {
        String curTenantId = RequestContext.get().getTenantId();
        String curAccountId = RequestContext.get().getAccountId();
        return curTenantId.equals(apply.getString("tenantid")) && curAccountId.equals(apply.getString("accountid"));
    }

    class MyEntryGridControl
    extends EntryGrid {
        MyEntryGridControl() {
        }

        protected boolean onFetchPageData(int pageIndex, int pageRows) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (this.getModel().getDataChanged()) {
                // empty if block
            }
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity(this.getKey());
            entryEntities.clear();
            int startRowIndex = (pageIndex - 1) * pageRows;
            String filter = OpenApiCloudUpdatePlugin.this.getPageCache().get("filter");
            String idsStr = OpenApiCloudUpdatePlugin.this.getPageCache().get(filter);
            List ids = (List)JSON.parse((String)idsStr);
            try {
                ApiResourceQueryResultDto resourceQueryResultDto = OpenApiCloudUpdatePlugin.this.queryApiListByPage(ids, PAGESIZE, pageIndex);
                OpenApiCloudUpdatePlugin.this.buildEntity(resourceQueryResultDto);
            }
            catch (Exception e) {
                log.info(e.getMessage(), (Object)e);
            }
            dataEntity.getDataEntityState().setEntryStartRowIndex(this.getKey(), startRowIndex);
            dataEntity.getDataEntityState().setEntryPageSize(this.getKey(), PAGESIZE.intValue());
            return true;
        }

        public void setPageRows(int rows) {
            AbstractGrid.GridState entryState = this.getEntryState();
            if (this.onFetchPageData(entryState.getCurrentPageIndex(), rows)) {
                super.setPageRows(rows);
            }
        }
    }
}

