/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.filter;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.openapi.base.util.CompareTypeUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.util.CollectionUtils;

public class FilterBuilderUtil {
    public static FilterBuilder getFilterBuilder(String entityNumber, DynamicObjectCollection filterEntry) {
        if (StringUtil.isEmpty((String)entityNumber)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterBuilder_0", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, FilterBuilderUtil.getFilterCondition(entityType, filterEntry));
        FilterObject filterObject = filterBuilder.getFilterObject();
        for (FilterRow filterRow : filterObject.getFilterRows()) {
            FilterField filterField = filterRow.getFilterField();
            IDataEntityProperty fieldProp = filterField.getFieldProp();
            if (!(fieldProp instanceof DateTimeProp) && !(fieldProp instanceof DecimalProp) && !"id".equals(fieldProp.getName())) continue;
            filterField.setFieldType(-9);
        }
        filterBuilder.buildFilter(true);
        return filterBuilder;
    }

    private static FilterCondition getFilterCondition(MainEntityType entityType, DynamicObjectCollection filterEntry) {
        FilterCondition filterCondition = new FilterCondition();
        if (CollectionUtils.isEmpty((Collection)filterEntry)) {
            return filterCondition;
        }
        filterCondition.setFilterRow(FilterBuilderUtil.getSimpleFilterRow(entityType, filterEntry));
        return filterCondition;
    }

    private static List<SimpleFilterRow> getSimpleFilterRow(MainEntityType entityType, DynamicObjectCollection filterEntry) {
        ArrayList<SimpleFilterRow> rows = new ArrayList<SimpleFilterRow>(filterEntry.size());
        for (DynamicObject entry : filterEntry) {
            String filterColumn = entry.getString("filter_column");
            if (StringUtil.isEmpty((String)filterColumn)) continue;
            SimpleFilterRow row = new SimpleFilterRow();
            row.setEntityNumber(entityType.getName());
            row.setLeftBracket(entry.getString("filter_left_bracket"));
            row.setFieldName(filterColumn);
            String filterCompare = entry.getString("filter_compare");
            if (StringUtil.isEmpty((String)filterCompare)) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u6bd4\u8f83\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterBuilder_1", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            CompareTypeEnum typeEnum = CompareTypeEnum.valueOf((String)filterCompare);
            row.setCompareType(CompareTypeUtil.getCompareType((CompareTypeEnum)typeEnum, (FilterField)FilterField.create((MainEntityType)entityType, (String)filterColumn)));
            row.setCompareTypeDesc(CompareTypeUtil.getDesc((CompareTypeEnum)typeEnum));
            if (entry.getString("filter_value") != null) {
                row.setValue(FilterBuilderUtil.getValue(entry.getString("filter_value"), typeEnum, "filter_value"));
            } else {
                row.setValue(FilterBuilderUtil.getValue(entry.getString("filter_constant"), typeEnum, "filter_constant"));
            }
            row.setRightBracket(entry.getString("filter_right_bracket"));
            row.setLogic(entry.getString("filter_link"));
            rows.add(row);
        }
        return rows;
    }

    private static List<FilterValue> getValue(String filterValueVar, CompareTypeEnum typeEnum, String entryFiledName) {
        FilterValue filterValue = new FilterValue();
        if (CompareTypeUtil.isMustInput((CompareTypeEnum)typeEnum)) {
            if (entryFiledName.equals("filter_value")) {
                filterValue.setValue((Object)("#{" + filterValueVar + "}"));
            } else {
                Object object = JsonUtil.parseJson((String)filterValueVar);
                if (object instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)object;
                    ArrayList<FilterValue> result = new ArrayList<FilterValue>(jsonArray.size());
                    for (Object o : jsonArray) {
                        FilterValue filterValue1 = new FilterValue();
                        filterValue1.setValue((Object)DataUtil.s(o));
                        result.add(filterValue1);
                    }
                    return result;
                }
                filterValue.setValue((Object)DataUtil.s((Object)object));
            }
        } else {
            filterValue.setValue((Object)"");
        }
        return Collections.singletonList(filterValue);
    }
}

