/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.msgalarm;

import java.util.EventObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.openapi.common.model.AlarmTypeEnum;
import kd.bos.openapi.common.model.DefaultAlarmMsgEnum;

public class OpenApiAlarmConfigPlugin
extends AbstractFormPlugin {
    private static final String MSGTITLE = "msgtitle";
    private static final String MSGTEMPLATE = "msgtemplate";
    private static final String MSGTITLE_CODEEDIT = "msgtitle_codeedit";
    private static final String MSGTEMPLATE_CODEEDIT = "msgtemplate_codeedit";
    private static final String ALARMTYPE = "alarmtype";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            CodeEdit msgtitleCodeEdit = (CodeEdit)this.getControl(MSGTITLE_CODEEDIT);
            String msgtitle = msgtitleCodeEdit.getText();
            this.getModel().setValue(MSGTITLE, (Object)msgtitle);
            CodeEdit msgtemplateCodeEdit = (CodeEdit)this.getControl(MSGTEMPLATE_CODEEDIT);
            String msgtemplate = msgtemplateCodeEdit.getText();
            this.getModel().setValue(MSGTEMPLATE, (Object)msgtemplate);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CodeEdit msgtitleCodeEdit = (CodeEdit)this.getControl(MSGTITLE_CODEEDIT);
        msgtitleCodeEdit.setText(this.getModel().getValue(MSGTITLE).toString());
        CodeEdit msgtemplateCodeEdit = (CodeEdit)this.getControl(MSGTEMPLATE_CODEEDIT);
        msgtemplateCodeEdit.setText(this.getModel().getValue(MSGTEMPLATE).toString());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (ALARMTYPE.equals(propName)) {
            this.preSetTitleAndContent();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.preSetTitleAndContent();
    }

    private void preSetTitleAndContent() {
        String alarmtype = this.getModel().getValue(ALARMTYPE).toString();
        if (AlarmTypeEnum.SLOWINTERFACE.getCode().equals(alarmtype)) {
            this.getModel().setValue(MSGTITLE, (Object)DefaultAlarmMsgEnum.SLOWINTERFACE_MSG.getTitle());
            this.getModel().setValue(MSGTEMPLATE, (Object)DefaultAlarmMsgEnum.SLOWINTERFACE_MSG.getMsg());
            CodeEdit msgtitleCodeEdit = (CodeEdit)this.getControl(MSGTITLE_CODEEDIT);
            CodeEdit msgtemplateCodeEdit = (CodeEdit)this.getControl(MSGTEMPLATE_CODEEDIT);
            msgtitleCodeEdit.setText(this.getModel().getValue(MSGTITLE).toString());
            msgtemplateCodeEdit.setText(this.getModel().getValue(MSGTEMPLATE).toString());
        }
    }
}

