/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.form.control.Listbox;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.openapi.base.statdata.ApiAggrService;
import kd.bos.openapi.common.model.OpenApiBillModel;
import kd.bos.openapi.common.spi.OpenApiBillService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.form.plugin.report.util.ReportFormUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class OpenApiChargingBillReportPlugin
extends AbstractReportFormPlugin
implements ListboxClickListener,
HyperLinkClickListener {
    public static final Integer MONTH = 0;
    public static final Integer DAY = 1;
    public static final Integer DETAIL = 2;
    public static final String LINK_DAY_TIME = "linkDayTime";
    public static final String LINK_MONTH_TIME = "linkMonthTime";

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            DynamicObject thirdapp = row.getDynamicObject("thirdid");
            if (thirdapp == null) {
                row.set("thirdappnumber", (Object)"N/A");
            } else {
                row.set("thirdappnumber", (Object)thirdapp.getString("number"));
            }
            DynamicObject api = row.getDynamicObject("apiid");
            if (api == null) {
                row.set("apiname", (Object)"N/A");
                row.set("apiurl", (Object)"N/A");
                continue;
            }
            row.set("apiname", api.getLocaleString("name").getDefaultItem());
            row.set("apiurl", (Object)api.getString("urlformat"));
        }
    }

    protected void filterContainerInit(FilterContainerInitEvent event, ReportQueryParam queryParam) {
        super.filterContainerInit(event, queryParam);
        if (this.getPageCache().get("type").equals("0")) {
            List commonFilterColumns = event.getCommonFilterColumns();
            for (FilterColumn column : commonFilterColumns) {
                String fieldName = column.getFieldName();
                if (!"time_filter".equals(fieldName)) continue;
                column.setDefaultValue("");
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        if (null != this.getPageCache().get("type")) {
            if (this.getPageCache().get("type").equals("1")) {
                String linkMonthTime = this.getPageCache().get(LINK_MONTH_TIME);
                if (linkMonthTime != null) {
                    map.put(LINK_MONTH_TIME, linkMonthTime);
                }
                map.put("type", DAY);
            } else if (this.getPageCache().get("type").equals("2")) {
                String linkDayTime = this.getPageCache().get(LINK_DAY_TIME);
                if (linkDayTime != null) {
                    map.put(LINK_DAY_TIME, linkDayTime);
                }
                map.put("type", DETAIL);
            } else if (this.getPageCache().get("type").equals("0")) {
                map.put("type", MONTH);
            }
        }
        queryParam.setCustomParam(map);
        this.getPageCache().remove(LINK_DAY_TIME);
        this.getPageCache().remove(LINK_MONTH_TIME);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        box.addListboxClickListener((ListboxClickListener)this);
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("refresh".equals(operate.getOperateKey())) {
            ApiAggrService apiAggrService = new ApiAggrService();
            apiAggrService.start(true);
            this.setLicenseInfo();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        ListboxItem listboxItem0 = new ListboxItem("month", ResManager.loadKDString((String)"\u6708", (String)"OpenApiLogReportPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ListboxItem listboxItem1 = new ListboxItem("day", ResManager.loadKDString((String)"\u5929", (String)"OpenApiLogReportPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ListboxItem listboxItem2 = new ListboxItem("detail", ResManager.loadKDString((String)"\u660e\u7ec6", (String)"OpenApiLogReportPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>();
        itemlist.add(listboxItem0);
        itemlist.add(listboxItem1);
        itemlist.add(listboxItem2);
        box.addItems(itemlist);
        box.activeItem("month");
        this.getPageCache().put("type", MONTH.toString());
        this.setTableFieldVisible("month");
        this.setLicenseInfo();
    }

    private void setLicenseInfo() {
        OpenApiBillService billService = OpenApiDataServiceFactory.getOpenApiBillService();
        OpenApiBillModel billModel = billService.getBillModelFromCache(true);
        long licenseCnt = billModel.getLicenseCnt();
        long billCnt = billModel.getBillCnt();
        this.getModel().setValue("license_cnt", (Object)licenseCnt);
        this.getModel().setValue("bill_cnt", (Object)billCnt);
        this.getModel().setValue("diff_cnt", (Object)(licenseCnt - billCnt));
        this.getModel().setValue("licenseDateFm", (Object)billModel.getLicenseDateFm());
        this.getModel().setValue("licenseDateTo", (Object)billModel.getLicenseDateTo());
    }

    public void listboxClick(ListboxEvent arg) {
        this.setTableFieldVisible(arg.getItemId());
        if (arg.getItemId().equals("month")) {
            this.getPageCache().put("type", MONTH.toString());
        } else if (arg.getItemId().equals("day")) {
            this.getPageCache().put("type", DAY.toString());
        } else if (arg.getItemId().equals("detail")) {
            this.getPageCache().put("type", DETAIL.toString());
        }
        this.getView().updateView();
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            List<String> sortList;
            List<String> filterList = Arrays.asList("billcnt", "cnt", "apiid", "thirdappnumber", "apiurl");
            if (filterList.contains(event.getColumnName())) {
                event.setFilter(true);
            }
            if (!(sortList = Arrays.asList("month_time", "day_time", "billcnt", "cnt")).contains(event.getColumnName())) continue;
            event.setSort(true);
        }
    }

    private void setTableFieldVisible(String boxItemId) {
        if (boxItemId.equals("month")) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("thirdid", Boolean.TRUE);
            map.put("thirdappnumber", Boolean.TRUE);
            map.put("apiname", Boolean.TRUE);
            map.put("apiid", Boolean.TRUE);
            map.put("apiurl", Boolean.TRUE);
            map.put("day_time", Boolean.TRUE);
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"openapi_charging_bill_reportlistap_reportcolumnsmap", (String)SerializationUtils.serializeToBase64(map));
        } else if (boxItemId.equals("day")) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("thirdid", Boolean.TRUE);
            map.put("thirdappnumber", Boolean.TRUE);
            map.put("apiname", Boolean.TRUE);
            map.put("apiid", Boolean.TRUE);
            map.put("apiurl", Boolean.TRUE);
            map.put("month_time", Boolean.TRUE);
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"openapi_charging_bill_reportlistap_reportcolumnsmap", (String)SerializationUtils.serializeToBase64(map));
        } else {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("thirdid", Boolean.TRUE);
            map.put("apiname", Boolean.FALSE);
            map.put("apiid", Boolean.TRUE);
            map.put("month_time", Boolean.TRUE);
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"openapi_charging_bill_reportlistap_reportcolumnsmap", (String)SerializationUtils.serializeToBase64(map));
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        String type = this.getPageCache().get("type");
        if (type != null) {
            if (MONTH.toString().equals(type) && "month_time".equals(fieldName)) {
                Date linkMonthTime = hyperLinkClickEvent.getRowData().getDate("month_time");
                Listbox box = (Listbox)this.getView().getControl("listboxap");
                box.activeItem("day");
                this.getPageCache().put("type", DAY.toString());
                this.getPageCache().put(LINK_MONTH_TIME, String.valueOf(linkMonthTime.getTime()));
                this.setTableFieldVisible("day");
                this.getView().invokeOperation("refresh");
            } else if (DAY.toString().equals(type) && "day_time".equals(fieldName)) {
                Date linkDayTime = hyperLinkClickEvent.getRowData().getDate("day_time");
                Listbox box = (Listbox)this.getView().getControl("listboxap");
                box.activeItem("detail");
                this.getPageCache().put("type", DETAIL.toString());
                this.getPageCache().put(LINK_DAY_TIME, String.valueOf(linkDayTime.getTime()));
                this.setTableFieldVisible("detail");
                this.getView().invokeOperation("refresh");
            } else if (DETAIL.toString().equals(type) && "day_time".equals(fieldName)) {
                Date startDate = hyperLinkClickEvent.getRowData().getDate("day_time");
                Date endDate = DateUtil.getDateAdd((Date)startDate, (int)5, (int)1);
                QFilter filter = new QFilter("opdate", ">", (Object)startDate).and(new QFilter("opdate", "<", (Object)endDate)).and(new QFilter("isbill", "=", (Object)"1"));
                DynamicObject api = hyperLinkClickEvent.getRowData().getDynamicObject("apiid");
                if (api != null) {
                    filter.and(new QFilter("apiid", "=", (Object)api.getString("id")));
                }
                ReportFormUtil.openApiLogBillList((AbstractFormPlugin)this, Collections.singletonList(filter), "");
            }
        }
    }
}

