/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.report;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.report.util.OpenApiLogTimeFilterEnum;
import kd.bos.openapi.form.plugin.report.util.ReportFormUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class OpenApiErrorCodeReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            List<String> filterList = Arrays.asList("opdesc", "errorcode", "errorcode");
            List<String> sotrList = Collections.singletonList("invoke_count");
            if (filterList.contains(event.getColumnName())) {
                event.setFilter(true);
            }
            if (!sotrList.contains(event.getColumnName())) continue;
            event.setSort(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("opdesc".equals(fieldName)) {
            DynamicObject rowData = hyperLinkClickEvent.getRowData();
            String url = rowData.getString("opdesc");
            String errorcode = rowData.getString("errorcode");
            QFilter filter = new QFilter("opdesc", "=", (Object)url).and(new QFilter("errorcode", "=", (Object)errorcode));
            ReportFormUtil.openApiLogBillList((AbstractFormPlugin)this, Collections.singletonList(filter), this.getLogTimeFilter());
        }
    }

    private String getLogTimeFilter() {
        List qFilters = this.getQueryParam().getFilter().getQFilters();
        if (CollectionUtil.isNotEmpty((Collection)qFilters)) {
            String curReportTimeFilter = ((QFilter)qFilters.get(0)).getValue().toString();
            if (StringUtil.isNotEmpty((String)curReportTimeFilter)) {
                switch (curReportTimeFilter) {
                    case "0": {
                        return OpenApiLogTimeFilterEnum.TODAY.getCode();
                    }
                    case "1": {
                        return OpenApiLogTimeFilterEnum.THISWEEK.getCode();
                    }
                }
                return OpenApiLogTimeFilterEnum.PAST_MONTH.getCode();
            }
            return OpenApiLogTimeFilterEnum.TODAY.getCode();
        }
        return OpenApiLogTimeFilterEnum.TODAY.getCode();
    }
}

