/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.script;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.form.util.TreeNodeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OpenApScriptManageListPlugin
extends StandardTreeListPlugin
implements IConfirmCallBack,
TreeNodeClickListener {
    private static final Log log = LogFactory.getLog(OpenApScriptManageListPlugin.class);
    private static final String BILL_LIST_STAP = "billlistap";
    private static final String TREE_VIEW = "treeview";
    private static final String FIELD_VERSION = "version";
    private static final String FORM_SCRIPT_SORT = "openapi_script_sort";
    private static final String FORM_SCRIPT = "openapi_script";
    private static final String BTN_NEW = "new";
    private static final String BTN_EDIT = "edit";
    private static final String BTN_DEL = "del";
    private static final String TBL_NEW = "tblnew";
    private static final String TBL_REFRESH = "tblrefresh";
    private static final String SCRIPT_SORT_NUMBER = "scriptSortNumber";
    private static final String ADD_SCRIPT_SORT = "addscriptsort";
    private static final String EDIT_SCRIPT_SORT = "editscriptsort";
    private static final String DEL_SCRIPT_SORT = "editscriptsort";
    public static final String CALLBACK_NODE = "callback_node";
    public static final String DEL_NODE = "del_node";
    public static final String IS_PRESET = "is_preset";
    public static final String CURRENT_NODE = "current_node";
    public static final String ADD_SCRIPT = "add_script";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildTree();
        this.defaultClickNode(this.getTreeModel().getRoot());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.getView().getFormShowParameter().getParentFormId() == null) {
            return;
        }
        if (null != this.getView().getPageCache().get(SCRIPT_SORT_NUMBER)) {
            String nodeId = this.getView().getPageCache().get(SCRIPT_SORT_NUMBER);
            TreeNode root = this.getTreeModel().getRoot();
            TreeNode targetNode = TreeNodeUtil.getTreeNodeById(root, nodeId);
            ArrayList<String> allChildId = new ArrayList<String>();
            TreeNodeUtil.getAllChildId(allChildId, targetNode);
            if (allChildId.size() > 0) {
                e.getQFilters().add(new QFilter("script_sort.number", "in", (Object)allChildId.toArray()));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent arg) {
        super.beforeItemClick(arg);
    }

    public void treeToolbarClick(EventObject e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (TBL_NEW.equals(evt.getItemKey())) {
            BillShowParameter param = new BillShowParameter();
            param.setFormId(FORM_SCRIPT);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.ADDNEW);
            param.setCustomParam(CURRENT_NODE, (Object)this.getTreeModel().getCurrentNodeId().toString());
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_SCRIPT));
            param.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u4ee3\u7801\u7247\u6bb5", (String)"OpenApScriptManageListPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)param);
        } else if (TBL_REFRESH.equals(evt.getItemKey())) {
            this.refreshList();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent arg) {
        super.beforeShowBill(arg);
        BaseShowParameter showParameter = (BaseShowParameter)arg.getParameter();
        showParameter.setFormId(FORM_SCRIPT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(BTN_NEW)) {
            this.getPageCache().put(CALLBACK_NODE, this.getTreeModel().getCurrentNodeId().toString());
            BillShowParameter param = new BillShowParameter();
            param.setFormId(FORM_SCRIPT_SORT);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.ADDNEW);
            param.setCustomParam(CURRENT_NODE, (Object)this.getTreeModel().getCurrentNodeId().toString());
            param.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u4ee3\u7801\u7247\u6bb5\u5206\u7c7b", (String)"OpenApScriptManageListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            param.setCustomParam(CURRENT_NODE, (Object)this.getTreeModel().getCurrentNodeId().toString());
            this.getTreeModel().getCurrentNodeId();
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_SCRIPT_SORT));
            this.getView().showForm((FormShowParameter)param);
        } else if (control.getKey().equals(BTN_EDIT)) {
            if ("".equals(this.getTreeModel().getCurrentNodeId().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8282\u70b9\u3002", (String)"OpenApScriptManageListPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (this.isPreSetSort(this.getTreeModel().getCurrentNodeId().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u811a\u672c\u5206\u7c7b\u4e0d\u80fd\u4fee\u6539\u3002", (String)"OpenApScriptManageListPlugin_3", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(CALLBACK_NODE, this.getTreeModel().getCurrentNodeId().toString());
            BillShowParameter param = new BillShowParameter();
            param.setFormId(FORM_SCRIPT_SORT);
            param.setPkId((Object)this.getPkIdByNumber(this.getTreeModel().getCurrentNodeId().toString()));
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.EDIT);
            param.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u811a\u672c\u5206\u7c7b", (String)"OpenApScriptManageListPlugin_4", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editscriptsort"));
            this.getView().showForm((FormShowParameter)param);
        } else if (control.getKey().equals(BTN_DEL)) {
            this.getPageCache().put(DEL_NODE, this.getTreeModel().getCurrentNodeId().toString());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5206\u7c7b\uff1f", (String)"OpenApScriptManageListPlugin_5", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("editscriptsort"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult() && StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)"editscriptsort")) {
            String number = this.getPageCache().get(DEL_NODE);
            if ("".equals(number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"OpenApScriptManageListPlugin_6", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                this.delScriptSort(number);
            }
        }
    }

    private void delScriptSort(String number) {
        if (this.isPreSetSort(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u811a\u672c\u5206\u7c7b\u4e0d\u80fd\u5220\u9664", (String)"OpenApScriptManageListPlugin_7", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)FORM_SCRIPT_SORT, (Object[])new Object[]{this.getPkIdByNumber(number)}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.buildTree();
            this.defaultClickNode(this.getTreeModel().getRoot());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OpenApScriptManageListPlugin_8", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"OpenApScriptManageListPlugin_9", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private Long getPkIdByNumber(String number) {
        QFilter[] qFilters = QFilterUtil.builder().put("number", "=", (Object)number).build();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)FORM_SCRIPT_SORT, (String)"Id", (QFilter[])qFilters);
        Long id = dynamicObject.getLong("Id");
        return id;
    }

    private boolean isPreSetSort(String number) {
        QFilter[] qFilters = QFilterUtil.builder().put("number", "=", (Object)number).build();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)FORM_SCRIPT_SORT, (String)IS_PRESET, (QFilter[])qFilters);
        return dynamicObject.getBoolean(IS_PRESET);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)ADD_SCRIPT_SORT) || StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"editscriptsort")) {
            this.buildTree();
            String treeNodeId = this.getPageCache().get(CALLBACK_NODE);
            if (treeNodeId != null && !"".equals(treeNodeId)) {
                TreeNode treeNode = TreeNodeUtil.getTreeNodeById(this.getTreeModel().getRoot(), treeNodeId);
                this.defaultClickNode(treeNode);
            }
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)ADD_SCRIPT)) {
            this.refreshList();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.getView().getPageCache().remove(SCRIPT_SORT_NUMBER);
        if (null != e.getNodeId() && !"".equals(e.getNodeId().toString())) {
            this.getView().getPageCache().put(SCRIPT_SORT_NUMBER, e.getNodeId().toString());
        }
        this.getTreeModel().getListFilter();
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        billList.refresh();
    }

    private void refreshList() {
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        billList.clearSelection();
        billList.refresh();
    }

    private void buildTree() {
        TreeView tv1 = (TreeView)this.getView().getControl(TREE_VIEW);
        tv1.deleteAllNodes();
        TreeNode root = TreeNodeUtil.buildScriptSortTree();
        tv1.addNode(root);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().updateView(TREE_VIEW);
    }

    private void defaultClickNode(TreeNode node) {
        if (node == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.focusNode(node);
        treeView.treeNodeClick(node.getParentid(), node.getId());
    }
}

