/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.script;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.isc.util.misc.Json2;
import kd.bos.openapi.base.script.OpenApiScript;
import kd.bos.openapi.base.script.OpenApiScriptUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.SysUtil;
import kd.bos.util.SystemProperties;

public class OpenApiScriptDebugPlugin
extends AbstractFormPlugin {
    private static final String EXECUTE = "execute";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (SysUtil.isProdEnv()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EXECUTE});
        }
    }

    private Boolean validatePWD(String password) {
        if (password == null) {
            return false;
        }
        String required_password = D.s((Object)SystemProperties.getWithEnv((String)"ISC_TEST_PASSWORD"));
        if (required_password == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u5bc6\u7801\u672a\u8bbe\u7f6e!", (String)"OpenApiScriptDebugPlugin_5", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (!required_password.equals(password)) {
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (EXECUTE.equals(event.getOperateKey())) {
            if (SysUtil.isProdEnv()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u7981\u6b62\u6267\u884c\u3002", (String)"OpenApiScriptDebugPlugin_6", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String password = D.s((Object)this.getModel().getValue("test_validate"));
            IPageCache pageCache = this.getView().getPageCache();
            int try_pwd_count = D.i((Object)pageCache.get("try_pwd_count"));
            if (try_pwd_count >= 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u5236\u6b21\u6570\uff1a10\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u76f8\u5e94\u6d4b\u8bd5\u5bc6\u7801\u3002", (String)"OpenApiScriptDebugPlugin_3", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!this.validatePWD(password).booleanValue()) {
                pageCache.put("try_pwd_count", D.s((Object)(++try_pwd_count)));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002\uff08\u5df2\u5c1d\u8bd5%s\u6b21\uff09\u3002", (String)"OpenApiScriptDebugPlugin_4", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), try_pwd_count));
                return;
            }
            CodeEdit scriptCode = (CodeEdit)this.getView().getControl("script_code");
            String script = D.s((Object)scriptCode.getText());
            if (StringUtil.isEmpty((String)script)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u4e3a\u7a7a\u3002", (String)"OpenApiScriptDebugPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            CodeEdit scriptResult = (CodeEdit)this.getView().getControl("script_result");
            try {
                Object result;
                if (OpenApiScriptUtil.isExprScript((Object)script)) {
                    result = OpenApiScriptUtil.handleExpr((String)script, Collections.emptyMap());
                } else {
                    OpenApiScript openApiScript = OpenApiScript.compile((String)script);
                    openApiScript.setTimeout(60000);
                    result = openApiScript.eval();
                }
                String json = result instanceof CharSequence ? result.toString() : Json2.toString((Object)result);
                scriptResult.setText(json);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"OpenApiScriptDebugPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            catch (Exception e) {
                scriptResult.setText(DataUtil.toString((Throwable)e));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"OpenApiScriptDebugPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }
}

