/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.script.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.common.util.IOUtil;
import kd.bos.openapi.form.plugin.script.util.ScriptCategoryEnum;
import kd.bos.openapi.form.plugin.script.util.ScriptItem;
import kd.bos.servicehelper.inte.InteServiceHelper;

public enum ScriptItemEnum {
    DB_EXECUTE(ScriptCategoryEnum.DB, 1, "DB.execute"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u6267\u884c\u63d2\u5165/\u5220\u9664", (String)"ScriptItemEnum_0", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(1.getFileContent(this.getNumber()));
        }
    }
    ,
    DB_EXECUTE_BATCH(ScriptCategoryEnum.DB, 2, "DB.executeBatch"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u6267\u884c\u6279\u91cf\u63d2\u5165/\u5220\u9664", (String)"ScriptItemEnum_2", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(2.getFileContent(this.getNumber()));
        }
    }
    ,
    DB_UPDATE(ScriptCategoryEnum.DB, 3, "DB.update"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u6267\u884c\u66f4\u65b0", (String)"ScriptItemEnum_3", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(3.getFileContent(this.getNumber()));
        }
    }
    ,
    DB_QUERY_ONE(ScriptCategoryEnum.DB, 4, "DB.queryOne"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u6267\u884c\u67e5\u8be2", (String)"ScriptItemEnum_4", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(4.getFileContent(this.getNumber()));
        }
    }
    ,
    DB_QUERY_LIST(ScriptCategoryEnum.DB, 5, "DB.queryList"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u6267\u884c\u67e5\u8be2", (String)"ScriptItemEnum_4", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(5.getFileContent(this.getNumber()));
        }
    }
    ,
    MS_INVOKE_BOS_SERVICE(ScriptCategoryEnum.MS, 1, "MS.invokeBosService"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u5e73\u53f0\u5fae\u670d\u52a1\u8c03\u7528", (String)"ScriptItemEnum_5", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(6.getFileContent(this.getNumber()));
        }
    }
    ,
    MS_INVOKE_BIZ_SERVICE(ScriptCategoryEnum.MS, 2, "MS.invokeBizService"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u4e1a\u52a1\u5fae\u670d\u52a1\u8c03\u7528", (String)"ScriptItemEnum_6", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(7.getFileContent(this.getNumber()));
        }
    }
    ,
    MS_INVOKE_SERVICE(ScriptCategoryEnum.MS, 3, "MS.invokeService"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u4e8c\u5f00\u4e1a\u52a1\u5fae\u670d\u52a1\u8c03\u7528", (String)"ScriptItemEnum_7", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(8.getFileContent(this.getNumber()));
        }
    }
    ,
    JSON_TO_JSON_STRING(ScriptCategoryEnum.JSON, 1, "JSON.toJSONString"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u5bf9\u8c61\u8f6cJSON\u5b57\u7b26\u4e32", (String)"ScriptItemEnum_8", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(9.getFileContent(this.getNumber()));
        }
    }
    ,
    JSON_PARSE(ScriptCategoryEnum.JSON, 2, "JSON.parse"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"JSON\u5b57\u7b26\u4e32\u8f6cObject", (String)"ScriptItemEnum_15", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u51af\u9553\u68da", (String)"ScriptItemEnum_13", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(10.getFileContent(this.getNumber()));
        }
    }
    ,
    JSON_PARSEOBJECT(ScriptCategoryEnum.JSON, 3, "JSON.parseObject"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"JSON\u5b57\u7b26\u4e32\u8f6cJSONObject", (String)"ScriptItemEnum_16", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u51af\u9553\u68da", (String)"ScriptItemEnum_13", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(11.getFileContent(this.getNumber()));
        }
    }
    ,
    JSON_PARSARRAY(ScriptCategoryEnum.JSON, 4, "JSON.parseArray"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"JSON\u5b57\u7b26\u4e32\u8f6cJSONArray", (String)"ScriptItemEnum_17", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u51af\u9553\u68da", (String)"ScriptItemEnum_13", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(12.getFileContent(this.getNumber()));
        }
    }
    ,
    API_SDK_UTIL_INVOKE(ScriptCategoryEnum.API_SDK_UTIL, 1, "OpenApiSdkUtil.invoke"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"API\u8c03\u7528", (String)"ScriptItemEnum_9", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(13.getFileContent(this.getNumber()));
        }
    }
    ,
    API_SDK_UTIL_QUERY(ScriptCategoryEnum.API_SDK_UTIL, 2, "OpenApiSdkUtil.query"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"API\u8c03\u7528 (\u67e5\u8be2\u64cd\u4f5c)", (String)"ScriptItemEnum_10", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(14.getFileContent(this.getNumber()));
        }
    }
    ,
    FILTER_VALUE_EXAMPLE(ScriptCategoryEnum.FILTERVALUE, 1, "ScriptFilterExample"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u6bd4\u8f83\u5e38\u91cf\u793a\u4f8b", (String)"ScriptItemEnum_11", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(15.getFileContent(this.getNumber()));
        }
    }
    ,
    DY_TOMAP(ScriptCategoryEnum.DYNAMICOBJECT_UTIL, 1, "DynamicObjectUtil.toMap"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u5355\u4e2a\u52a8\u6001\u5bf9\u8c61\u8f6cmap", (String)"ScriptItemEnum_12", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u51af\u9553\u68da", (String)"ScriptItemEnum_13", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(16.getFileContent(this.getNumber()));
        }
    }
    ,
    DY_TOLISTMAP(ScriptCategoryEnum.DYNAMICOBJECT_UTIL, 2, "DynamicObjectUtil.toListMap"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u52a8\u6001\u5bf9\u8c61\u6570\u7ec4\u8f6cmap", (String)"ScriptItemEnum_14", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u51af\u9553\u68da", (String)"ScriptItemEnum_13", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(17.getFileContent(this.getNumber()));
        }
    }
    ,
    THROW_EX(ScriptCategoryEnum.THROW, 2, "Throw.ex"){

        @Override
        public ScriptItem getScriptItem() {
            return ScriptItem.build().setId(this.getId()).setNumber(this.getNumber()).setName(ResManager.loadKDString((String)"\u629b\u51fa\u5f02\u5e38", (String)"ScriptItemEnum_18", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setGroup(this.getParent()).setAuthor(ResManager.loadKDString((String)"\u5415\u54c1\u35ca", (String)"ScriptItemEnum_1", (String)ScriptItemEnum.BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])).setContent(18.getFileContent(this.getNumber()));
        }
    };

    private static final String OPEN_API_SCRIPT_DOCUMENT = "OpenAPI_Script_Document";
    private static final int TIME_OUT_IN_SECONDS = 172800;
    private final String id;
    private final String number;
    private final ScriptCategoryEnum parent;
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";

    private ScriptItemEnum(ScriptCategoryEnum parent, int seq, String number) {
        this.id = parent.getId() + "-" + seq;
        this.number = number;
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public ScriptCategoryEnum getParent() {
        return this.parent;
    }

    public abstract ScriptItem getScriptItem();

    public static String getFileContent(String number) {
        ArrayDeque<String> langDeque = new ArrayDeque<String>(3);
        langDeque.addLast(Lang.get().toString());
        ScriptItemEnum.addLast(langDeque, InteServiceHelper.getDefaultLangNumber());
        ScriptItemEnum.addLast(langDeque, Lang.zh_CN.toString());
        return ScriptItemEnum.getFileContent(number, langDeque);
    }

    private static void addLast(Deque<String> langDeque, String lang) {
        if (!langDeque.contains(lang)) {
            langDeque.addLast(lang);
        }
    }

    private static String getFileContent(String number, Deque<String> langDeque) {
        if (langDeque.isEmpty()) {
            return null;
        }
        String content = ScriptItemEnum.getFileContentByLang(number + "_" + langDeque.pop());
        if (content == null) {
            return ScriptItemEnum.getFileContent(number, langDeque);
        }
        return content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getFileContentByLang(String numberLang) {
        String mdContent = (String)LocalCacheUtil.getCacheByKey((String)OPEN_API_SCRIPT_DOCUMENT, (String)numberLang);
        if (mdContent != null) {
            return mdContent;
        }
        String filePath = "/help/docs/" + numberLang + ".md";
        try (InputStream inputStream = ScriptItemEnum.class.getResourceAsStream(filePath);){
            if (inputStream == null) {
                String string2 = null;
                return string2;
            }
            mdContent = IOUtil.getString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            LocalCacheUtil.setCacheByKey((String)OPEN_API_SCRIPT_DOCUMENT, (String)numberLang, (Object)mdContent, (int)172800);
            String string = mdContent;
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }
}

