/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.script.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.KHashMap;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.script.util.ScriptCategory;
import kd.bos.openapi.form.plugin.script.util.ScriptCategoryEnum;
import kd.bos.openapi.form.plugin.script.util.ScriptItem;
import kd.bos.openapi.form.plugin.script.util.ScriptItemEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ShowScriptHelpUtil {
    private static final KHashMap<String, List<String>> PARENT_LEVEL_EXCLUDE = KHashMap.create().set((Object)"-", Arrays.asList("SQL", "service_interface", "script_examples")).set((Object)"SCRIPT.FUNCTION", Arrays.asList("FTP", "DATAFILE", "DBA", "FILEOP", "Mongo"));
    private static final List<String> EXCLUDE_ITEMS = Arrays.asList("FastJsonFormat", "FastJsonParse", "GetContext", "THIS_URL", "decode", "encode", "new_boid", "new_int_id", "new_uuid", "RSA_Decrypt", "RSA_Encrypt", "SM4_Decrypt", "SM4_Encrypt", "LicenseInfo", "WithContext");
    private static final List<Object> EXCLUDE_ITEM_IDS;

    public static QFilter getExcludeCategoryFilter() {
        return new QFilter("number", "not in", PARENT_LEVEL_EXCLUDE.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public static QFilter getExcludeItemFilter() {
        return new QFilter("id", "not in", EXCLUDE_ITEM_IDS);
    }

    public static List<TreeNode> getOpenApiTreeNode() {
        return ShowScriptHelpUtil.getOpenApiTreeNode("0");
    }

    public static List<TreeNode> getOpenApiTreeNode(String parentId) {
        Map<String, List<ScriptCategoryEnum>> pidMap = EnumSet.allOf(ScriptCategoryEnum.class).stream().collect(Collectors.groupingBy(ScriptCategoryEnum::getParentId));
        return ShowScriptHelpUtil.getOpenApiTreeNode(parentId, pidMap);
    }

    private static List<TreeNode> getOpenApiTreeNode(String parentId, Map<String, List<ScriptCategoryEnum>> pidMap) {
        List<ScriptCategoryEnum> categoryEnums = pidMap.get(parentId);
        if (CollectionUtil.isEmpty(categoryEnums)) {
            return Collections.emptyList();
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(categoryEnums.size());
        for (ScriptCategoryEnum categoryEnum : categoryEnums) {
            TreeNode node = new TreeNode(categoryEnum.getParentId(), categoryEnum.getId(), categoryEnum.getName());
            node.addChildren(ShowScriptHelpUtil.getOpenApiTreeNode(categoryEnum.getId(), pidMap));
            if (node.getChildren().isEmpty()) {
                node.setLeaf(true);
                node.setChildren(null);
            }
            nodes.add(node);
        }
        return nodes;
    }

    public static boolean addOpenApiScript(String nodeId, int level, BillList billList) {
        if (!ScriptCategory.isStartsWithOpenRoot(nodeId)) {
            return false;
        }
        ShowScriptHelpUtil.addCreateListDataProviderListener(billList, nodeId, level, null);
        billList.refresh();
        billList.clearSelection();
        return true;
    }

    public static void addCreateListDataProviderListener(BillList billList, final String nodeId, int level, final String keyword) {
        billList.addCreateListDataProviderListener(event -> event.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection items = super.getData(start, limit);
                if (ScriptCategory.isStartsWithOpenRoot(nodeId)) {
                    items.clear();
                }
                if (StringUtil.isNotEmpty((String)keyword) && StringUtil.isEmpty((String)nodeId)) {
                    items.removeIf(next -> !next.getString("number").contains(keyword) && !next.getString("name").contains(keyword) && !next.getString("group.name").contains(keyword));
                }
                for (ScriptItemEnum entry : ScriptItemEnum.values()) {
                    ScriptItem item;
                    if (StringUtil.isEmpty((String)keyword) ? !"0".equals(nodeId) && !entry.getId().startsWith(nodeId + "-") : StringUtil.isNotEmpty((String)nodeId) && !entry.getId().startsWith(nodeId + "-") || !((String)(item = entry.getScriptItem()).getNumber().getValue()).contains(keyword) && !((LocaleString)item.getName().getValue()).getLocaleValue().contains(keyword) && !((DynamicObject)item.getGroup().getValue()).getString("name").contains(keyword)) continue;
                    ShowScriptHelpUtil.addOpenApiScriptItem(items, entry.getScriptItem());
                }
                QueryResult queryResult = this.getQueryResult();
                queryResult.setBillDataCount(items.size());
                queryResult.setDataCount(items.size());
                return items;
            }
        }));
    }

    public static String getScriptContent(String number) {
        for (ScriptItemEnum entry : ScriptItemEnum.values()) {
            ScriptItem item = entry.getScriptItem();
            if (!((String)item.getNumber().getValue()).equals(number)) continue;
            return (String)item.getContent().getValue();
        }
        return null;
    }

    public static void addAllOpenApiScriptCategory(Map<String, String> cache) {
        List<TreeNode> nodes = ShowScriptHelpUtil.getOpenApiTreeNode();
        ShowScriptHelpUtil.addAllOpenApiScriptCategory(cache, nodes);
    }

    private static void addAllOpenApiScriptCategory(Map<String, String> cache, List<TreeNode> nodes) {
        if (CollectionUtil.isEmpty(nodes)) {
            return;
        }
        for (TreeNode node : nodes) {
            ShowScriptHelpUtil.addOpenApiScriptCategory(cache, node);
            ShowScriptHelpUtil.addAllOpenApiScriptCategory(cache, node.getChildren());
        }
    }

    private static void addOpenApiScriptCategory(Map<String, String> cache, TreeNode node) {
        cache.put(node.getId(), node.getText() + ":" + node.getParentid());
    }

    private static void addOpenApiScriptItem(DynamicObjectCollection items, ScriptItem item) {
        DynamicObject addNew = items.addNew();
        addNew.set((String)item.getId().getKey(), item.getId().getValue());
        addNew.set((String)item.getNumber().getKey(), item.getNumber().getValue());
        addNew.set((String)item.getName().getKey(), item.getName().getValue());
        addNew.set((String)item.getGroup().getKey(), item.getGroup().getValue());
    }

    public static void addAllOpenApiScriptItem(Map<String, String> cache) {
        for (ScriptItemEnum entry : ScriptItemEnum.values()) {
            ScriptItem item = entry.getScriptItem();
            cache.put((String)item.getId().getValue(), ((LocaleString)item.getName().getValue()).getLocaleValue() + ":" + (String)item.getNumber().getValue() + ":" + item.getParentId());
        }
    }

    static {
        QFilter[] filters = QFilterUtil.builder().put("number", "in", EXCLUDE_ITEMS).build();
        EXCLUDE_ITEM_IDS = QueryServiceHelper.queryPrimaryKeys((String)"isc_help_item", (QFilter[])filters, null, (int)10000);
    }
}

