/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.test;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.openapi.base.custom.CustomApiUtil;
import kd.bos.openapi.common.constant.ApiDefType;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.test.OpenApiTestCaseListPlugin;
import kd.bos.openapi.form.util.OpenApiDataPreviewUtil;
import kd.bos.openapi.form.util.OpenApiTestUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.util.Pair;

public class OpenApiTestCaseFormPlugin
extends AbstractBasePlugIn
implements TreeNodeClickListener,
BeforeF7SelectListener,
Consumer<BeforeF7ViewDetailEvent> {
    private static final String BAR_SYNC = "synchronization";
    private static final String BAR_TEST = "bar_test";
    private static final String BAR_RECORD = "bar_record";
    private static final String BAR_SAVE = "save";
    private static final String KEY_API = "api";
    private static final String KEY_BD_TYPE = "bd_type";
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_TESTRECORD = "testrecord";
    private static final String FORM_OPENAPI_TEST_RECORD = "openapi_test_record";
    private static final String OP_BEAUTIFY = "beautify";
    private static final String ID = "id";
    private static final String RECORDID = "recordId";
    private static final String PRE_TREE_VIEW = "pretreeview";
    private static final String POS_TREE_VIEW = "postreeview";
    private static final String BODY_SCRIPT_CODE = "body_script_code";
    private static final String BD_TEXT_TAG = "bd_text_tag";
    private static final String HTTPMETHOD = "httpmethod";
    private static final String APISERVICETYPE = "apiservicetype";
    private static final String KEY_HEADER_ENTRY = "headerentryentity";
    private static final String HEADERNAME = "headername";
    private static final String HEADERVALUE = "headervalue";
    private static final String HEADERDES = "headerdes";
    private static final String KEY_URLPARAM_ENTRY = "urlparamentryentity";
    private static final String URLPARAMKEY = "urlparamkey";
    private static final String URLPARAMVALUE = "urlparamvalue";
    private static final String URLPARAMDES = "urlparamdes";
    private static final String KEY_BODY_ENTRY = "bodyentryentity";
    private static final String PARAMNAME = "paramname";
    private static final String EXAMPLE = "example";
    private static final String BODYPARAMDES = "bodyparamdes";
    private static final String SCRIPTHELPER = "scripthelper";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView preTree = (TreeView)this.getView().getControl(PRE_TREE_VIEW);
        preTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView posTree = (TreeView)this.getView().getControl(POS_TREE_VIEW);
        posTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        BasedataEdit api = (BasedataEdit)this.getControl(KEY_API);
        api.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        api.addBeforeF7ViewDetailListener((Consumer)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildTwoScriptTree();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.buildScript();
        Tab tab = (Tab)this.getControl(KEY_TABAP);
        if (((DynamicObject)this.getModel().getValue(KEY_API)).getString(HTTPMETHOD).equals("0")) {
            tab.activeTab("queryparam");
        } else {
            tab.activeTab("bodytab");
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.buildScript();
    }

    public void afterBindData(EventObject e) {
        String envType;
        super.afterBindData(e);
        this.hideBodyTabOp();
        if (null != this.getView().getFormShowParameter().getCustomParam("isRecord")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tabap1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"newhttpentry", "deletehttpentry", "respentrydelete", "respentrynew"});
        }
        if ("prod".equals(envType = System.getProperty("env.type"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_TEST});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals(KEY_BD_TYPE)) {
            this.hideBodyTabOp();
        } else if (propName.equals(KEY_API)) {
            Tab tab = (Tab)this.getControl(KEY_TABAP);
            tab.activeTab("headertab");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if (arg0.getProperty().getName().equals(KEY_API)) {
            // empty if block
        }
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent t) {
        DynamicObject api = (DynamicObject)this.getModel().getValue(KEY_API);
        if (!api.getString(APISERVICETYPE).equals("0")) {
            t.setCancel(true);
            BaseShowParameter showParameter = new BaseShowParameter();
            if (api.getString(APISERVICETYPE).equals("2")) {
                showParameter.setFormId("openapi_customapi");
            } else if (api.getString(APISERVICETYPE).equals("3")) {
                showParameter.setFormId("openapi_scriptapi");
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId(t.getPkId());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (BAR_SAVE.equals(operateKey)) {
            this.setScriptInHiddenParam();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (!SCRIPTHELPER.equals(opKey) && OP_BEAUTIFY.equals(opKey)) {
            CodeEdit bdEdit = (CodeEdit)this.getView().getControl(BODY_SCRIPT_CODE);
            try {
                String text = bdEdit.getText() != null ? bdEdit.getText() : this.getModel().getValue(BD_TEXT_TAG).toString();
                bdEdit.setText(JSON.toJSONString((Object)JSONObject.parseObject((String)text), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
            }
            catch (Exception e) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%1$s %1$s %1$s", (String)"OpenApiTestCaseFormPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), "\\r", "\\n", e.getMessage()));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (evt.getItemKey().equals(BAR_SYNC)) {
            if (null == this.getModel().getValue(KEY_API)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9API\u3002", (String)"OpenApiTestCaseFormPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (evt.getItemKey().equals(BAR_TEST)) {
            OpenApiTestUtil util;
            Long pk = (Long)this.getModel().getDataEntity().getPkValue();
            if (pk <= 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u7528\u4f8b\u3002", (String)"OpenApiTestCaseFormPlugin_3", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (((DynamicObject)this.getModel().getValue(KEY_API)).get("status").equals("D")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"API\u5df2\u7981\u7528\u65e0\u6cd5\u8c03\u7528\u3002", (String)"OpenApiTestCaseListPlugin_22", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if ("no3rdApp".equals((util = new OpenApiTestUtil()).checkIsHasApitest3rdApp())) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("apitest", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"API\u6d4b\u8bd5\u8bf7\u6c42\u521b\u5efa\u7b2c\u4e09\u65b9\u5e94\u7528\uff08openapi_unittest\uff09", (String)"OpenApiFormPlugin_89", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals(BAR_SYNC)) {
            if (null != this.getModel().getValue(KEY_API)) {
                try {
                    this.syncApiData();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"OpenApiTestCaseFormPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showMessage(e.getMessage());
                }
            }
        } else if (evt.getItemKey().equals(BAR_TEST)) {
            this.dotest();
        } else if (evt.getItemKey().equals(BAR_RECORD)) {
            String number = (String)this.getModel().getValue(KEY_NUMBER);
            String recordId = "";
            if (null != this.getPageCache().get(RECORDID)) {
                recordId = this.getPageCache().get(RECORDID);
            } else {
                DynamicObject record = QueryServiceHelper.queryOne((String)FORM_OPENAPI_TEST_RECORD, (String)ID, (QFilter[])new QFilter("billno", "=", (Object)(number + "_record")).toArray());
                recordId = record.getString(ID);
            }
            if (null != recordId) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(FORM_OPENAPI_TEST_RECORD);
                showParameter.setPkId((Object)recordId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6d4b\u8bd5\u7ed3\u679c\u3002", (String)"OpenApiTestCaseListPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (null != this.getPageCache().get("isRecordChanged")) {
            e.setCheckDataChange(false);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("apitest") && evt.getResult() == MessageBoxResult.Yes) {
            OpenApiTestUtil util = new OpenApiTestUtil();
            util.createUnittestApp();
            this.dotest();
        }
    }

    private void buildTwoScriptTree() {
    }

    private void setScriptInHiddenParam() {
        CodeEdit bdEdit = (CodeEdit)this.getView().getControl(BODY_SCRIPT_CODE);
        String bdText = bdEdit.getText();
        if (StringUtil.isNotEmpty((String)bdText)) {
            this.getModel().setValue(BD_TEXT_TAG, (Object)bdText);
        }
    }

    private void hideBodyTabOp() {
        String bdType = this.getModel().getValue(KEY_BD_TYPE).toString();
        if (bdType.equals("1")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"Beautify"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"newbodyentry", "delbodyentry", "addchildentry", "upbodyentry", "downbodyentry"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"newbodyentry", "delbodyentry", "addchildentry", "upbodyentry", "downbodyentry"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"Beautify"});
        }
    }

    private void syncApiData() {
        DynamicObjectCollection bodys;
        this.clearApiEntrys();
        DynamicObject apiId = (DynamicObject)this.getModel().getValue(KEY_API);
        DynamicObject api = null;
        api = apiId.getString(APISERVICETYPE).equals("2") ? BusinessDataServiceHelper.loadSingle((Object)apiId.get(ID), (String)ApiServiceType.CUSTOM.getEntityName()) : BusinessDataServiceHelper.loadSingle((Object)apiId.get(ID), (String)ApiServiceType.OPERATION.getEntityName());
        DynamicObjectCollection headers = api.getDynamicObjectCollection(KEY_HEADER_ENTRY);
        if (CollectionUtil.isNotEmpty((Collection)headers)) {
            DynamicObjectType headerType = this.getModel().getEntryEntity(KEY_HEADER_ENTRY).getDynamicObjectType();
            for (DynamicObject header : headers) {
                DynamicObject testHeader = new DynamicObject(headerType);
                testHeader.set(HEADERNAME, header.get(HEADERNAME));
                testHeader.set(HEADERVALUE, header.get(HEADERVALUE));
                testHeader.set(HEADERDES, header.get(HEADERDES));
                this.getModel().createNewEntryRow(KEY_HEADER_ENTRY, testHeader);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(bodys = api.getDynamicObjectCollection(KEY_BODY_ENTRY)))) {
            if (apiId.getString(HTTPMETHOD).equals("0")) {
                for (DynamicObject body : bodys) {
                    DynamicObjectType paramType = this.getModel().getEntryEntity(KEY_URLPARAM_ENTRY).getDynamicObjectType();
                    if (body.get("paramtype").toString().contains("Array") && null != body.get(EXAMPLE)) {
                        JSONArray array = (JSONArray)JSONArray.parse((String)body.get(EXAMPLE).toString());
                        for (Object object : array) {
                            this.createParamRow(paramType, body, object);
                        }
                        continue;
                    }
                    this.createParamRow(paramType, body, null);
                }
            } else {
                this.paramPreview(api);
            }
        }
    }

    private void createParamRow(DynamicObjectType paramType, DynamicObject body, Object object) {
        DynamicObject testParam = new DynamicObject(paramType);
        testParam.set(URLPARAMKEY, body.get(PARAMNAME));
        testParam.set(URLPARAMVALUE, object != null ? object : body.get(EXAMPLE));
        testParam.set(URLPARAMDES, body.get(BODYPARAMDES));
        this.getModel().createNewEntryRow(KEY_URLPARAM_ENTRY, testParam);
    }

    private void clearApiEntrys() {
        this.getModel().deleteEntryData(KEY_HEADER_ENTRY);
        this.getModel().deleteEntryData(KEY_BODY_ENTRY);
        this.getModel().deleteEntryData(KEY_URLPARAM_ENTRY);
    }

    private void buildScript() {
        CodeEdit bdEdit = (CodeEdit)this.getView().getControl(BODY_SCRIPT_CODE);
        Object bdText = this.getModel().getValue(BD_TEXT_TAG);
        if (bdText != null) {
            bdEdit.setText(bdText.toString());
            this.getView().updateView(BODY_SCRIPT_CODE);
        }
    }

    private void paramPreview(DynamicObject api) {
        CodeEdit bdEdit = (CodeEdit)this.getView().getControl(BODY_SCRIPT_CODE);
        if (api.getString(APISERVICETYPE).equals("0")) {
            String operation = DataUtil.s((Object)api.get("operation"));
            int httpMethod = DataUtil.i((Object)api.get(HTTPMETHOD));
            Pair<Map<String, Object>, Boolean> result = OpenApiDataPreviewUtil.getDataPair("", KEY_BODY_ENTRY, api.getDynamicObjectCollection(KEY_BODY_ENTRY), operation, httpMethod);
            bdEdit.setText(JSON.toJSONString((Object)JSONObject.parseObject((String)JsonUtil.toJsonString((Object)new JSONObject((Map)result.getKey()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField, SerializerFeature.MapSortField})), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
        } else if (api.getString(APISERVICETYPE).equals("2")) {
            String className = (String)api.get("classname");
            String methodName = (String)api.get("methodname");
            DynamicObject bizApp = (DynamicObject)api.get("appId");
            String apiDefType = api.get("apideftype").toString();
            if (ApiDefType.AUTOSCAN.getCode().equalsIgnoreCase(apiDefType) && (StringUtil.isEmpty((String)className) || StringUtil.isEmpty((String)methodName) || bizApp == null)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u5c5e\u5e94\u7528\uff0c\u7c7b\u540d\uff0c\u65b9\u6cd5\u540d\u662f\u5426\u4e3a\u7a7a\u3002", (String)"OpenApiCustomApiFormPlugin_10", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dynamicObjects = api.getDynamicObjectCollection(KEY_BODY_ENTRY);
            String jsonStr = null;
            if (dynamicObjects.size() > 0) {
                Object resultObj = ApiDefType.AUTOSCAN.getCode().equalsIgnoreCase(apiDefType) ? CustomApiUtil.getRequestObj((String)bizApp.getString(KEY_NUMBER), (String)className, (String)methodName) : CustomApiUtil.getCustomParams((String)KEY_BODY_ENTRY, (DynamicObjectCollection)dynamicObjects);
                jsonStr = JSON.toJSONString((Object)resultObj);
            } else {
                Object resultObj = ApiDefType.AUTOSCAN.getCode().equalsIgnoreCase(apiDefType) ? CustomApiUtil.getResponseObj((String)bizApp.getString(KEY_NUMBER), (String)className, (String)methodName) : CustomApiUtil.getCustomParams((String)KEY_BODY_ENTRY, (DynamicObjectCollection)dynamicObjects);
                OpenApiResult openApiResult = OpenApiResult.builder().success(resultObj);
                openApiResult.setMessage("");
                jsonStr = JSON.toJSONString((Object)openApiResult);
            }
            bdEdit.setText(JSON.toJSONString((Object)JSONObject.parseObject((String)jsonStr), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
        } else {
            DynamicObjectCollection dynamicObjects = api.getDynamicObjectCollection(KEY_BODY_ENTRY);
            bdEdit.setText(JSON.toJSONString((Object)CustomApiUtil.getCustomParams((String)KEY_BODY_ENTRY, (DynamicObjectCollection)dynamicObjects), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
        }
    }

    private void dotest() {
        try {
            OpenApiTestCaseListPlugin listPlugin = new OpenApiTestCaseListPlugin();
            DynamicObject dataCase = this.getModel().getDataEntity();
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)dataCase.getPkValue(), (DynamicObjectType)dataCase.getDynamicObjectType());
            Object id = listPlugin.apiTest(data, true);
            if (null != id) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u529f\u3002", (String)"OpenApiTestApiPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                if (id instanceof DynamicObject) {
                    this.getPageCache().put(RECORDID, ((DynamicObject)id).getPkValue().toString());
                    this.getModel().setValue("testtime", (Object)new Date());
                    this.getModel().setValue(KEY_TESTRECORD, (Object)((DynamicObject)id).getString("testresult"));
                    this.getPageCache().put("isRecordChanged", "1");
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25\u3002", (String)"OpenApiTestApiPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25\u3002", (String)"OpenApiTestApiPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        }
    }
}

