/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateRouteService;
import kd.bos.openapi.form.util.CertUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.util.AESUtils;

public class AuthStrategyEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
ItemClickListener,
ClickListener {
    private static final Log log = LogFactory.getLog(AuthStrategyEditPlugin.class);
    public static final String ACCESS_STRATEGY = "access_strategy";
    private static final String BUTTON_NEXT = "btnok";
    private static final String BUTTON_CANCEL = "btncancel";
    public static final String STRATEGY_TYPE_ID = "strategytypeid";
    public static final String STRATEGY_TYPE_TYPE = "strategytypetype";
    public static final String EYE_KEY_SHOW = "eyekeyshow";
    public static final String IS_NEW = "isnew";
    public static final String BASEIC_AUTH_ID = "basicauthid";
    public static final String VT_SHOW_PD_DIGESTKEY = "vtshowpd_digestkey";
    public static final String VT_SHOW_PD_ACCESSTOKEN = "vtshowpd_accesstoken";
    public static final String VT_SHOW_PD_JWTKEY = "vtshowpd_jwtkey";
    public static final String VT_SHOW_PD_SIGNKEY = "vtshowpd_signkey";
    public static final String FIELD_TYPE_TEXT = "text";
    public static final String FIELD_TYPE_PWB = "passwordbox";
    public static final String FIELD_ITEM = "item";
    public static final String VT_SHOW_PD_BIYAN = "kdfont kdfont-biyan";
    public static final String VT_SHOW_PD_OPENYAN = "kdfont kdfont-yanjing";
    public static final String REFRESH_BASICSIGN = "refresh_basicsign";
    public static final String FIELD_SIGN_AGENT_USER_ID = "signagentuserid";
    public static final String FIELD_SIGN_SECRET_KEY = "signsecretkey";
    public static final String FIELD_SIGN_SECRET_DB_KEY = "signsecretkeydb";
    private static final String PWGFORMAT = "******";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CANCEL, BUTTON_NEXT});
        TextEdit digestSignKey = (TextEdit)this.getView().getControl("publickey");
        digestSignKey.addClickListener((ClickListener)this);
        TextEdit jwtSignKey = (TextEdit)this.getView().getControl("securitypublickey");
        jwtSignKey.addClickListener((ClickListener)this);
        TextEdit signKey = (TextEdit)this.getView().getControl("signature_key");
        signKey.addClickListener((ClickListener)this);
        TextEdit secretKeyDisp = (TextEdit)this.getView().getControl("secretkeydisp");
        secretKeyDisp.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{VT_SHOW_PD_DIGESTKEY, VT_SHOW_PD_ACCESSTOKEN, VT_SHOW_PD_JWTKEY, VT_SHOW_PD_SIGNKEY});
        BasedataEdit edit = (BasedataEdit)this.getControl("agentuserid");
        if (edit != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit agControl = (BasedataEdit)this.getControl("agentuserid");
        agControl.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity("entryentity_basicauth");
            ArrayList<Object> pks = new ArrayList<Object>(16);
            for (DynamicObject object : entryentity) {
                Object agentuser = object.get("agentuserid");
                if (!"open".equals(object.getString("systag")) || agentuser == null) continue;
                pks.add(((DynamicObject)agentuser).getPkValue());
            }
            parameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)pks.toArray()).and(new QFilter("enable", "!=", (Object)"0")));
        });
        BasedataEdit signAgentEdit = (BasedataEdit)this.getControl(FIELD_SIGN_AGENT_USER_ID);
        if (signAgentEdit != null) {
            signAgentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit signAgentUserControl = (BasedataEdit)this.getControl(FIELD_SIGN_AGENT_USER_ID);
        signAgentUserControl.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity("entryentity_basicauth");
            ArrayList<Object> pks = new ArrayList<Object>(16);
            for (DynamicObject object : entryentity) {
                Object agentuser = object.get("agentuserid");
                if (agentuser == null) continue;
                pks.add(((DynamicObject)agentuser).getPkValue());
            }
            parameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)pks.toArray()).and(new QFilter("enable", "!=", (Object)"0")));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter billShowParameter = this.getView().getFormShowParameter();
        String strategyCode = (String)billShowParameter.getCustomParam("strategycode");
        this.getModel().setValue("strategycode", (Object)strategyCode);
        this.getModel().setValue("thirdAppModel", billShowParameter.getCustomParam("thirdAppModel"));
        this.openOrCloseEyeForKey(this.getView());
        StrategyUpdateRouteService.getStrategyUpdateService(strategyCode).loadData(this.getModel());
    }

    public void openOrCloseEyeForKey(IFormView formView) {
        this.openOrCloseEyeForKey(formView, FIELD_SIGN_SECRET_KEY, VT_SHOW_PD_SIGNKEY);
    }

    protected void openOrCloseEyeForKey(IFormView formView, String pKey, String eyeKey) {
        boolean isShowPwd = false;
        if ("1".equals(formView.getPageCache().get(EYE_KEY_SHOW))) {
            isShowPwd = true;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> item = new HashMap<String, HashMap<String, String>>();
        map.put("type", isShowPwd ? FIELD_TYPE_TEXT : FIELD_TYPE_PWB);
        item.put(FIELD_ITEM, map);
        formView.updateControlMetadata(pKey, item);
        map = new HashMap();
        item = new HashMap();
        map.put("fontClass", isShowPwd ? VT_SHOW_PD_BIYAN : VT_SHOW_PD_OPENYAN);
        item.put(FIELD_ITEM, map);
        formView.updateControlMetadata(eyeKey, item);
        formView.getPageCache().put(EYE_KEY_SHOW, isShowPwd ? "0" : "1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPwdFormat();
    }

    private void setPwdFormat() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get("syspwd"))) {
            proxy.setFieldProperty("syspwd", "v", (Object)PWGFORMAT);
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get("publickey"))) {
            proxy.setFieldProperty("publickey", "v", (Object)PWGFORMAT);
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get("securitypublickey"))) {
            proxy.setFieldProperty("securitypublickey", "v", (Object)PWGFORMAT);
        }
        if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get("signature_key"))) {
            proxy.setFieldProperty("signature_key", "v", (Object)PWGFORMAT);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        try {
            Control control;
            if (evt.getSource() instanceof TextEdit) {
                TextEdit textEdit = (TextEdit)evt.getSource();
                if ("publickey".equalsIgnoreCase(textEdit.getKey())) {
                    this.refreshDigst("publickey");
                } else if ("signature_key".equalsIgnoreCase(textEdit.getKey())) {
                    this.refreshDigst("signature_key");
                } else if ("secretkeydisp".equalsIgnoreCase(textEdit.getKey())) {
                    ThirdAppEditDto thirdAppEditDto = (ThirdAppEditDto)JSON.parseObject((String)((String)this.getModel().getValue("thirdAppModel")), ThirdAppEditDto.class);
                    if (thirdAppEditDto.getId() == null || thirdAppEditDto.getId() == 0L) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (this.getModel().getValue("basesigncode") == null || !"".equals(this.getModel().getValue("basesigncode").toString())) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5237\u65b0\u79d8\u94a5\u4f1a\u5bfc\u81f4\u539f\u6709\u79d8\u94a5\u5931\u6548\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OpenApi3rdappsPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(REFRESH_BASICSIGN));
                    } else {
                        this.refreshBasicAuthCode();
                    }
                }
            } else if (evt.getSource() instanceof Control && (VT_SHOW_PD_DIGESTKEY.equals((control = (Control)evt.getSource()).getKey()) || VT_SHOW_PD_ACCESSTOKEN.equals(control.getKey()) || VT_SHOW_PD_JWTKEY.equals(control.getKey()) || VT_SHOW_PD_SIGNKEY.equals(control.getKey()))) {
                this.openOrCloseEyeForKey(this.getView());
            }
        }
        catch (OpenApiException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit edit = (BasedataEdit)arg0.getSource();
        if (edit.getFieldKey().equals("agentuserid") && null != this.getModel().getValue("agentuserid")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff01\u82e5\u4fee\u6539\u4ee3\u7406\u7528\u6237\uff0c\u7cfb\u7edf\u4f1a\u91cd\u65b0\u751f\u6210\u65b0\u7684\u57fa\u672c\u8ba4\u8bc1\u5bc6\u94a5\u3002", (String)"OpenApi3rdappsPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshDigst(String key) {
        try {
            String base64EncodeKey = AESUtils.getBase64EncodeKey();
            this.getModel().setValue(key, (Object)base64EncodeKey);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u79f0\u52a0\u5bc6\u79d8\u94a5\u751f\u6210\u5931\u8d25!", (String)"OpenApi3rdappsPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshJWT() {
        try {
            String base64EncodeKey = AESUtils.getBase64EncodeKey();
            this.getModel().setValue("securitypublickey", (Object)base64EncodeKey);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u79f0\u52a0\u5bc6\u79d8\u94a5\u751f\u6210\u5931\u8d25!", (String)"OpenApi3rdappsPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("jwt_type", (Object)"1");
    }

    private void refreshBasicAuthCode() {
        DynamicObject agencyUser = (DynamicObject)this.getModel().getValue("agentuserid");
        if (agencyUser == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ee3\u7406\u7528\u6237\u3002", (String)"OpenApi3rdappsPlugin_10", (String)"bos-open-formplugin", (Object[])new Object[0]));
            return;
        }
        ThirdAppEditDto thirdAppEditDto = (ThirdAppEditDto)JSON.parseObject((String)((String)this.getModel().getValue("thirdAppModel")), ThirdAppEditDto.class);
        String thirdId = thirdAppEditDto.getId().toString();
        String agencyUserId = agencyUser.getPkValue().toString();
        String key = EncryptUtil.genSign((String)thirdId, (String)agencyUserId);
        this.getModel().setValue("showsecretkey", (Object)true);
        this.getModel().setValue("basesigncode", (Object)key);
        this.getModel().setValue("secretkeydisp", (Object)EncryptUtil.genSignWithAccountId((String)key, (String)RequestContext.get().getAccountId()));
        this.getModel().updateCache();
        this.getView().updateView("entryentity_basicauth");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        ThirdAppEditDto thirdAppEditDto = (ThirdAppEditDto)JSON.parseObject((String)((String)this.getModel().getValue("thirdAppModel")), ThirdAppEditDto.class);
        if ("agentuserid".equals(name)) {
            Long id;
            DynamicObject agentUser;
            if (thirdAppEditDto.getId() == null || thirdAppEditDto.getId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            this.refreshBasicAuthCode();
            if (thirdAppEditDto.isAgencyUser() && (agentUser = (DynamicObject)this.getModel().getValue("agentuserid", rowIndex)) != null && agentUser.get("id") != null && agentUser.getLong("id") != 0L) {
                this.getModel().setValue("basicstatus", (Object)(this.checkBasicAgentUserValidate(agentUser.getLong("id"), thirdAppEditDto) ? "1" : "0"), rowIndex);
            }
            if ((id = (Long)this.getModel().getValue(BASEIC_AUTH_ID, rowIndex)) == 0L) {
                id = DB.genLongId((String)"t_open_3rdapps_basicauth");
                this.getModel().setValue(BASEIC_AUTH_ID, (Object)id, rowIndex);
            }
            if (StringUtil.isEmpty((String)((String)this.getModel().getValue("systag", rowIndex)))) {
                this.getModel().setValue("systag", (Object)"open", rowIndex);
                this.getModel().setValue("remark", (Object)"open", rowIndex);
            }
            this.getView().updateView("entryentity_basicauth");
        } else if ("showsecretkey".equals(name)) {
            Boolean isShow = (Boolean)this.getModel().getValue("showsecretkey");
            Object baseCode = this.getModel().getValue("basesigncode");
            if (baseCode == null || "".equals(baseCode.toString())) {
                return;
            }
            String baseCodeStr = baseCode.toString();
            if (isShow.booleanValue()) {
                if (EncrypterFactory.getEncrypter().isEncrypted(baseCodeStr)) {
                    baseCodeStr = EncrypterFactory.getEncrypter().decode(baseCodeStr);
                }
                this.getModel().setValue("secretkeydisp", (Object)EncryptUtil.genSignWithAccountId((String)baseCodeStr, (String)RequestContext.get().getAccountId()));
            } else {
                this.getModel().setValue("secretkeydisp", (Object)PWGFORMAT);
            }
            this.getView().updateView("entryentity_basicauth");
        } else if ("basicstatus".equals(name)) {
            DynamicObject agentUser;
            if (thirdAppEditDto.isAgencyUser() && (agentUser = (DynamicObject)this.getModel().getValue("agentuserid", rowIndex)) != null && agentUser.get("id") != null && agentUser.getLong("id") != 0L && !this.checkBasicAgentUserValidate(agentUser.getLong("id"), thirdAppEditDto) && ((Boolean)this.getModel().getValue("basicstatus", rowIndex)).booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6548\uff0c\u8bf7\u53d6\u6d88\u7b2c\u4e09\u65b9\u5e94\u7528\u4ee3\u7406\u7528\u6237\u63a7\u5236\u6216\u5c06\u8be5\u7528\u6237\u8bbe\u4e3a\u4ee3\u7406\u7528\u6237\u3002", (String)"AuthStrategyEditPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
        } else if (FIELD_SIGN_AGENT_USER_ID.equals(name)) {
            if (thirdAppEditDto.getId() == null || thirdAppEditDto.getId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            String thirdId = thirdAppEditDto.getId().toString();
            String agencyUserId = D.l((Object)((DynamicObject)this.getModel().getValue(FIELD_SIGN_AGENT_USER_ID)).getPkValue()) + "";
            String key = EncryptUtil.genSign((String)thirdId, (String)agencyUserId);
            this.getModel().setValue(FIELD_SIGN_SECRET_DB_KEY, (Object)key);
            this.getModel().setValue(FIELD_SIGN_SECRET_KEY, (Object)EncryptUtil.genSignWithAccountId((String)key, (String)RequestContext.get().getAccountId()));
        } else if ("jwtasymmetic".equals(name)) {
            this.refreshJWT();
        } else if ("jwt_type".equals(name)) {
            boolean result;
            String jwtType = D.s((Object)this.getModel().getValue("jwt_type"));
            if ("1".equals(jwtType)) {
                this.refreshJWT();
            } else if ("2".equals(jwtType) && !(result = CertUtil.createJWTCert(thirdAppEditDto.getId()))) {
                throw new OpenApiException(ApiErrorCode.Data_UpdateFail, "Create JWT RSA cert failed.", new Object[0]);
            }
        }
    }

    private boolean checkBasicAgentUserValidate(Long userId, ThirdAppEditDto thirdAppEditDto) {
        if (thirdAppEditDto.getAgencyUserMap() == null || thirdAppEditDto.getAgencyUserMap().isEmpty()) {
            return false;
        }
        return thirdAppEditDto.getAgencyUserMap().get(userId) != null && thirdAppEditDto.getAgencyUserMap().get(userId) == 1;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String eventId = event.getCallBackId();
        if (REFRESH_BASICSIGN.equalsIgnoreCase(eventId) && event.getResult() == MessageBoxResult.Yes) {
            this.refreshBasicAuthCode();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        try {
            if ("confirm_ext".equals(operate.getOperateKey())) {
                FormShowParameter billShowParameter = this.getView().getFormShowParameter();
                String strategyCode = (String)billShowParameter.getCustomParam("strategycode");
                ThirdAppEditDto thirdAppEditDto = (ThirdAppEditDto)JSON.parseObject((String)((String)this.getModel().getValue("thirdAppModel")), ThirdAppEditDto.class);
                if (("4".equals(strategyCode) || "5".equals(strategyCode)) && (thirdAppEditDto.getId() == null || thirdAppEditDto.getId() == 0L)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                thirdAppEditDto = StrategyUpdateRouteService.getStrategyUpdateService(strategyCode).confirm(this.getModel());
                thirdAppEditDto.setTitle(billShowParameter.getCaption());
                this.getView().returnDataToParent((Object)thirdAppEditDto);
                this.getView().close();
            }
        }
        catch (OpenApiException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.getView().close();
    }
}

