/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.form.plugin.thirdapp.entity.StrategyTypeEnum;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateRouteService;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class StrategySelectPlugin
extends AbstractFormPlugin
implements IFormPlugin,
ClickListener {
    private static final Log log = LogFactory.getLog(StrategySelectPlugin.class);
    public static final String SELECT_STRATEGY_FORM = "select_strategy";
    private static final String ACCESS_STRATEGY_ENTRY = "entryaccessstrategy";
    public static final String ACCESS_STRATEGY_TYPE = "access_strategy_type";
    public static final String ACCESS_STRATEGY_TYPE_FIELDS = "id,number,type,name,desc,group";
    public static final String ACCESS_STRATEGY_TYPE_ENABLE = "enable";
    public static final String ACCESS_STRATEGY_TYPE_TYPE = "type";
    private static final String BUTTON_ALL_STRATEGY = "btallstrategy";
    private static final String BUTTON_NEXT = "btnok";
    private static final String TOOL_BAR = "toolbarap";
    private static final String ACCESS_STRATEGY_CALLBACK = "accessStragegyCallback";
    public static final String STRATEGY_ID = "strategyid";
    public static final String STRATEGY_NAME = "strategyname";
    public static final String STRATEGY_TYPE = "strategytype";
    public static final String STRATEGY_DESC = "strategydesc";
    public static final String STRATEGY_CODE = "strategycode";
    public static final String NO_SELECTED_FORCE_COLOR = "#666666";
    public static final String WHITE_COLOR = "#FFFFFF";
    public static final String BACK_COLOR_THEME = "themeColor";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_NEXT});
        this.addItemClickListeners(new String[]{TOOL_BAR});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.updateList(null);
        }
        catch (OpenApiException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void updateList(StrategyTypeEnum strategyType) {
        this.getModel().deleteEntryData(ACCESS_STRATEGY_ENTRY);
        ArrayList<QFilter> qFilterListlterList = new ArrayList<QFilter>();
        qFilterListlterList.add(new QFilter(ACCESS_STRATEGY_TYPE_ENABLE, "=", (Object)"1"));
        String btnName = BUTTON_ALL_STRATEGY;
        if (strategyType != null) {
            qFilterListlterList.add(new QFilter(ACCESS_STRATEGY_TYPE_TYPE, "=", (Object)strategyType.getType()));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("fc", WHITE_COLOR);
            params.put("bc", BACK_COLOR_THEME);
            this.getView().updateControlMetadata(strategyType.getName(), params);
            btnName = strategyType.getName();
        }
        this.setButtonStyle(btnName, WHITE_COLOR, BACK_COLOR_THEME);
        QFilter[] filters = qFilterListlterList.toArray(new QFilter[0]);
        DynamicObject[] typeList = BusinessDataServiceHelper.load((String)ACCESS_STRATEGY_TYPE, (String)ACCESS_STRATEGY_TYPE_FIELDS, (QFilter[])filters);
        FormShowParameter billShowParameter = this.getView().getFormShowParameter();
        Map exitsMap = (Map)billShowParameter.getCustomParam("selectedStrategy");
        if (typeList != null && typeList.length > 0) {
            for (DynamicObject dynamicObject : typeList) {
                String strategyCode = dynamicObject.getString("number");
                if (exitsMap.get(strategyCode) != null && ((Boolean)exitsMap.get(strategyCode)).booleanValue()) continue;
                int index = this.getModel().createNewEntryRow(ACCESS_STRATEGY_ENTRY);
                this.getModel().setValue(STRATEGY_ID, (Object)dynamicObject.getLong("id"), index);
                this.getModel().setValue(STRATEGY_CODE, (Object)dynamicObject.getString("number"), index);
                this.getModel().setValue(STRATEGY_NAME, (Object)dynamicObject.getString("name"), index);
                this.getModel().setValue(STRATEGY_TYPE, (Object)dynamicObject.getString(ACCESS_STRATEGY_TYPE_TYPE), index);
                this.getModel().setValue(STRATEGY_DESC, (Object)dynamicObject.getString("desc"), index);
            }
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ACCESS_STRATEGY_ENTRY);
        entryGrid.selectRows(0, true);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        try {
            if (BUTTON_NEXT.equals(control.getKey())) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ACCESS_STRATEGY_ENTRY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u79cd\u7b56\u7565", (String)"StrategySelectPlugin_1", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ACCESS_STRATEGY_ENTRY);
                DynamicObject selectedStrategy = (DynamicObject)dynamicObjectCollection.get(selectRows[0]);
                String type = selectedStrategy.getString(STRATEGY_TYPE);
                String code = selectedStrategy.getString(STRATEGY_CODE);
                Long strategyId = selectedStrategy.getLong(STRATEGY_ID);
                String page = "access_strategy";
                if (StrategyTypeEnum.AUTH.getType().equals(type)) {
                    page = "access_strategy";
                } else if (StrategyTypeEnum.ENCRYPT.getType().equals(type)) {
                    page = "encrypt_strategy_edit";
                } else if (StrategyTypeEnum.ACCESSCONTROL.getType().equals(type)) {
                    page = "acesscl_strategy_edit";
                }
                FormShowParameter billShowParameter = this.getView().getFormShowParameter();
                Map exitsMap = (Map)billShowParameter.getCustomParam("selectedStrategy");
                if ("31".equals(code) && exitsMap.get("32") != null && ((Boolean)exitsMap.get("32")).booleanValue() || "32".equals(code) && exitsMap.get("31") != null && ((Boolean)exitsMap.get("31")).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u540c\u65f6\u4f7f\u75281\u79cd\u52a0\u5bc6\u7b56\u7565\uff0c\u82e5\u9700\u8981\u4fee\u6539\uff0c\u8bf7\u5220\u9664\u5f53\u524d\u52a0\u5bc6\u7b56\u7565\u3002", (String)"StrategySelectPlugin_0", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> param = new HashMap<String, Object>(2);
                param.put(STRATEGY_CODE, code);
                Long thirdId = (Long)billShowParameter.getCustomParam("thirdId");
                ThirdAppEditDto thirdAppDto = new ThirdAppEditDto();
                thirdAppDto.setId(thirdId);
                thirdAppDto.setStrategyType(type);
                thirdAppDto.setStrategyCode(code);
                thirdAppDto.setStrategyId(strategyId);
                thirdAppDto.setIsNew("1");
                StrategyUpdateRouteService.getStrategyUpdateService(code).init(null, thirdAppDto);
                param.put("thirdAppModel", JSON.toJSONString((Object)thirdAppDto));
                FormShowParameter p = FormOpener.getFormShowParameter(this, page, selectedStrategy.getString(STRATEGY_NAME), param, ACCESS_STRATEGY_CALLBACK);
                p.getOpenStyle().setShowType(ShowType.Modal);
                if ("4".equals(code) || "5".equals(code)) {
                    StyleCss css = new StyleCss();
                    css.setWidth("554");
                    css.setHeight("332");
                    p.getOpenStyle().setInlineStyleCss(css);
                }
                this.getView().showForm(p);
            }
        }
        catch (OpenApiException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StrategyTypeEnum.AUTH.getName().equals(name)) {
            this.updateList(StrategyTypeEnum.AUTH);
        } else if (StrategyTypeEnum.ENCRYPT.getName().equals(name)) {
            this.updateList(StrategyTypeEnum.ENCRYPT);
        } else if (StrategyTypeEnum.ACCESSCONTROL.getName().equals(name)) {
            this.updateList(StrategyTypeEnum.ACCESSCONTROL);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (ACCESS_STRATEGY_CALLBACK.equals(action)) {
            if (evt.getReturnData() == null) {
                return;
            }
            this.getView().returnDataToParent(evt.getReturnData());
            this.getView().close();
        }
    }

    private void setButtonStyle(String btnKey, String foreColor, String backColor) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fc", foreColor);
        params.put("bc", backColor);
        this.getView().updateControlMetadata(btnKey, params);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.setButtonStyle(BUTTON_ALL_STRATEGY, NO_SELECTED_FORCE_COLOR, WHITE_COLOR);
        this.setButtonStyle(StrategyTypeEnum.AUTH.getName(), NO_SELECTED_FORCE_COLOR, WHITE_COLOR);
        this.setButtonStyle(StrategyTypeEnum.ENCRYPT.getName(), NO_SELECTED_FORCE_COLOR, WHITE_COLOR);
        this.setButtonStyle(StrategyTypeEnum.ACCESSCONTROL.getName(), NO_SELECTED_FORCE_COLOR, WHITE_COLOR);
        if (BUTTON_ALL_STRATEGY.equals(evt.getItemKey())) {
            this.updateList(null);
        } else if (StrategyTypeEnum.AUTH.getName().equals(evt.getItemKey())) {
            this.updateList(StrategyTypeEnum.AUTH);
        } else if (StrategyTypeEnum.ENCRYPT.getName().equals(evt.getItemKey())) {
            this.updateList(StrategyTypeEnum.ENCRYPT);
        } else if (StrategyTypeEnum.ACCESSCONTROL.getName().equals(evt.getItemKey())) {
            this.updateList(StrategyTypeEnum.ACCESSCONTROL);
        }
    }
}

