/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.isc.util.dt.D;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;
import kd.bos.util.PasswordEncryptUtil;

public class AccessTokenUpdateServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    private static final Log log = LogFactory.getLog(AccessTokenUpdateServiceImpl.class);

    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        thirdAppEditDto.setAccessToken((String)model.getValue("syspwd"));
        thirdAppEditDto.setNumber(D.s((Object)model.getValue("number")));
        thirdAppEditDto.setEnhanceToken(D.x((Object)model.getValue("isenhancetoken")));
        thirdAppEditDto.setAgencyUser(D.x((Object)model.getValue("isagencyuser")));
        DynamicObjectCollection dyc = model.getEntryEntity("agencyuser");
        model.setValue("accesstoken_old", model.getValue("syspwd"));
        thirdAppEditDto.setJwtAuthEnable(D.x((Object)model.getValue("jwtasymmetic")));
        thirdAppEditDto.setJwtShaKey((String)model.getValue("securitypublickey"));
        thirdAppEditDto.setJwtSignType((Long)model.getValue("jwt_type"));
        if (dyc != null) {
            HashMap<Long, Integer> agencyUserMap = new HashMap<Long, Integer>();
            dyc.forEach(dynamicObject -> agencyUserMap.put(dynamicObject.getLong("fbasedataid.id"), 1));
            thirdAppEditDto.setAgencyUserMap(agencyUserMap);
        }
    }

    @Override
    public void loadData(IDataModel model) {
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        model.setValue("syspwd", (Object)thirdAppEditDto.getAccessToken());
        model.setValue("accesstoken_old", (Object)thirdAppEditDto.getAccessToken());
        model.setValue("isenhancetoken", (Object)(thirdAppEditDto.isEnhanceToken() ? "1" : "0"));
        model.setValue("jwtasymmetic", (Object)(thirdAppEditDto.isJwtAuthEnable() ? "1" : "0"));
        model.setValue("jwt_type", (Object)("1".equals(thirdAppEditDto.getIsNew()) ? "1" : thirdAppEditDto.getJwtSignType() + ""));
        model.setValue("securitypublickey", (Object)thirdAppEditDto.getJwtShaKey());
        model.setValue("isagencyuser", (Object)thirdAppEditDto.isAgencyUser());
        if (thirdAppEditDto.getAgencyUserMap() != null && thirdAppEditDto.getAgencyUserMap().size() > 0) {
            DynamicObjectCollection dynamicObjectCollection = model.getEntryEntity("agencyuser");
            DynamicObjectType dynamicObjectType = dynamicObjectCollection.getDynamicObjectType();
            for (Map.Entry<Long, Integer> user : thirdAppEditDto.getAgencyUserMap().entrySet()) {
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set("fbasedataid_id", (Object)user.getKey());
                dynamicObjectCollection.add((Object)dynamicObject);
            }
            model.updateEntryCache(dynamicObjectCollection);
        }
    }

    @Override
    public void validate(IDataModel model) {
        if (model == null) {
            return;
        }
        String isSave = D.s((Object)model.getValue("issave"));
        String accessToken = (String)model.getValue("syspwd");
        String accessTokenOld = (String)model.getValue("accesstoken_old");
        if (!"1".equalsIgnoreCase(isSave) && !accessTokenOld.equals(accessToken) && StringUtils.isNotBlank((CharSequence)accessToken) && !accessToken.matches("^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{16,50}$")) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u5bc6\u94a5\u4e0d\u7b26\u5408\u5bc6\u7801\u590d\u6742\u6027\u53ca\u957f\u5ea6\u8981\u6c42\uff0816~50\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u6df7\u5408\uff09\u3002", (String)"OpenApi3rdappsPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        Boolean jwtEnable = D.x((Object)model.getValue("jwtasymmetic"));
        String jwtType = D.s((Object)model.getValue("jwt_type"));
        if (jwtEnable.booleanValue() && StringUtil.isEmpty((String)jwtType)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u542f\u7528JWT Token\u540e\uff0c\u9700\u8981\u9009\u62e9JWT\u7b7e\u540d\u7b56\u7565\u3002", (String)"AccessTokenUpdateServiceImpl_0", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        Boolean isEnhanceToken = D.x((Object)model.getValue("isenhancetoken"));
        if (isEnhanceToken.booleanValue() && (!((Boolean)model.getValue("isagencyuser")).booleanValue() || model.getValue("agencyuser") == null || ((MulBasedataDynamicObjectCollection)model.getValue("agencyuser")).isEmpty())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4f7f\u7528\u589e\u5f3a\u578bToken\u8ba4\u8bc1\uff0c\u5fc5\u987b\u5148\u542f\u7528\u4ee3\u7406\u7528\u6237\u63a7\u5236\u5e76\u7ef4\u62a4\u63a5\u53e3\u4ee3\u7406\u7528\u6237\u3002", (String)"AccessTokenUpdateServiceImpl_1", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        this.validate(model);
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        String accessToken = (String)model.getValue("syspwd");
        String accessTokenOld = (String)model.getValue("accesstoken_old");
        String encrypted = "";
        if (StringUtil.isEmpty((String)accessToken) && StringUtil.isEmpty((String)accessTokenOld) || accessTokenOld.equals(accessToken) || accessTokenOld.equals(PasswordEncryptUtil.getEncryptePasswordWithSalt((String)accessToken))) {
            encrypted = accessToken;
        } else if (StringUtil.isNotEmpty((String)accessToken)) {
            encrypted = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)accessToken);
        }
        thirdAppEditDto.setAccessToken(encrypted);
        boolean isEnhanceToken = D.x((Object)model.getValue("isenhancetoken"));
        if (isEnhanceToken != thirdAppEditDto.isEnhanceToken()) {
            thirdAppEditDto.setEnhanceToken(isEnhanceToken);
        }
        thirdAppEditDto.setJwtAuthEnable(D.x((Object)model.getValue("jwtasymmetic")));
        thirdAppEditDto.setJwtShaKey(this.encode((String)model.getValue("securitypublickey")));
        thirdAppEditDto.setJwtSignType(Long.valueOf((String)model.getValue("jwt_type")));
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        model.setValue("syspwd", (Object)thirdAppEditDto.getAccessToken());
        model.setValue("isenhancetoken", (Object)(thirdAppEditDto.isEnhanceToken() ? "1" : "0"));
        model.setValue("securitypublickey", (Object)thirdAppEditDto.getJwtShaKey());
        model.setValue("jwtasymmetic", (Object)(thirdAppEditDto.isJwtAuthEnable() ? "1" : "0"));
        model.setValue("jwt_type", (Object)thirdAppEditDto.getJwtSignType());
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdAppStrategyId) {
        throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u7b56\u7565\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ThirdAppPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
    }
}

