/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.isc.util.dt.D;
import kd.bos.openapi.base.util.CommonConfigUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;

public class ApiAuthExtUpdateServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        DynamicObjectCollection dyc = null;
        if (model == null) {
            DynamicObject thirdApp = this.loadThirdApp(thirdAppEditDto.getId());
            if (thirdApp != null) {
                thirdAppEditDto.setAuthPluginEnable(thirdApp.getString("authpluginenable"));
                thirdAppEditDto.setAgencyUser(thirdApp.getBoolean("isagencyuser"));
                dyc = thirdApp.getDynamicObjectCollection("agencyuser");
            }
        } else {
            thirdAppEditDto.setAuthPluginEnable(D.s((Object)model.getValue("authpluginenable")));
            thirdAppEditDto.setAgencyUser((Boolean)model.getValue("isagencyuser"));
            dyc = model.getEntryEntity("agencyuser");
        }
        if (dyc != null) {
            HashMap<Long, Integer> agencyUserMap = new HashMap<Long, Integer>();
            dyc.forEach(dynamicObject -> agencyUserMap.put(dynamicObject.getLong("fbasedataid.id"), 1));
            thirdAppEditDto.setAgencyUserMap(agencyUserMap);
        }
    }

    @Override
    public void loadData(IDataModel model) {
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        model.setValue("authpluginenable", (Object)thirdAppEditDto.getAuthPluginEnable());
        model.setValue("isagencyuser", (Object)thirdAppEditDto.isAgencyUser());
        if (thirdAppEditDto.getAgencyUserMap() != null && thirdAppEditDto.getAgencyUserMap().size() > 0) {
            DynamicObjectCollection dynamicObjectCollection = model.getEntryEntity("agencyuser");
            DynamicObjectType dynamicObjectType = dynamicObjectCollection.getDynamicObjectType();
            for (Map.Entry<Long, Integer> user : thirdAppEditDto.getAgencyUserMap().entrySet()) {
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                dynamicObject.set("fbasedataid_id", (Object)user.getKey());
                dynamicObjectCollection.add((Object)dynamicObject);
            }
            model.updateEntryCache(dynamicObjectCollection);
        }
    }

    @Override
    public void validate(IDataModel model) {
        Map pluginMap;
        List enableList;
        List list;
        if (model == null) {
            return;
        }
        String pluginInfo = CommonConfigUtil.getValue((int)7, (String)"api_global_authplugin", (String)RequestContext.get().getAccountId());
        boolean isPluginConfig = false;
        if (StringUtil.isNotEmpty((String)pluginInfo) && CollectionUtil.isNotEmpty((Collection)(list = (List)SerializationUtils.fromJsonString((String)pluginInfo, List.class))) && CollectionUtil.isNotEmpty(enableList = list.stream().filter(item -> item.get("Enabled") != null && (Boolean)item.get("Enabled") != false).collect(Collectors.toList())) && enableList.get(0) != null && StringUtil.isNotEmpty((String)D.s((pluginMap = (Map)enableList.get(0)).get("ClassName"))) && StringUtil.isNotEmpty((String)D.s(pluginMap.get("api_global_pluginappid")))) {
            isPluginConfig = true;
        }
        if (!isPluginConfig) {
            String appId = McConfigUtil.getPropertyByTenantWithDefault((String)RequestContext.get().getTenantId(), (String)"OpenApi.AuthExt.AppId", (String)"");
            String className = McConfigUtil.getPropertyByTenantWithDefault((String)RequestContext.get().getTenantId(), (String)"OpenApi.AuthExt.ClassName", (String)"");
            if (StringUtil.isEmpty((String)appId) || StringUtil.isEmpty((String)className)) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u7ba1\u7406\u5458\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91 - \u516c\u5171\u8bbe\u7f6e - \u53c2\u6570\u914d\u7f6e\uff0c\u7ef4\u62a4OpenAPI\u7cfb\u7edf\u7ea7\u53c2\u6570\u4e2d\uff0c\u914d\u7f6e\u597d\u63a5\u53e3\u9274\u6743\u63d2\u4ef6\u4e4b\u540e\u518d\u6dfb\u52a0\u3002", (String)"ApiAuthExtUpdateServiceImpl_0", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
            }
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        this.validate(model);
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        thirdAppEditDto.setAuthPluginEnable("1");
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        model.setValue("authpluginenable", (Object)thirdAppEditDto.getAuthPluginEnable());
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdAppStrategyId) {
        if (StringUtil.isEmpty((String)thirdAppStrategyId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdStrategyId is null.", new Object[0]);
        }
        model.setValue("authpluginenable", (Object)"0");
        this.updateAndDelete(model, Long.valueOf(thirdAppStrategyId));
    }
}

