/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.BasicAgentUserDto;
import kd.bos.openapi.form.plugin.thirdapp.entity.CommonEntryDto;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;

public class BasicAuthUpdateServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppDto) {
        DynamicObjectCollection dyEntry = null;
        DynamicObjectCollection dyc = null;
        if (model == null) {
            DynamicObject thirdApp = this.loadThirdApp(thirdAppDto.getId());
            if (thirdApp != null) {
                thirdAppDto.setAgencyUser(thirdApp.getBoolean("isagencyuser"));
                dyc = thirdApp.getDynamicObjectCollection("agencyuser");
                dyEntry = thirdApp.getDynamicObjectCollection("entryentity_basicauth");
            }
        } else {
            thirdAppDto.setAgencyUser((Boolean)model.getValue("isagencyuser"));
            dyc = model.getEntryEntity("agencyuser");
            dyEntry = model.getEntryEntity("entryentity_basicauth");
        }
        if (dyc != null) {
            HashMap<Long, Integer> agencyUserMap = new HashMap<Long, Integer>();
            dyc.forEach(dynamicObject -> agencyUserMap.put(dynamicObject.getLong("fbasedataid.id"), 1));
            thirdAppDto.setAgencyUserMap(agencyUserMap);
        }
        if (dyEntry != null) {
            HashMap<Long, BasicAgentUserDto> agentserMap = new HashMap<Long, BasicAgentUserDto>();
            dyEntry.forEach(dynamicObject -> {
                if ("0".equals(dynamicObject.getString("type"))) {
                    agentserMap.put(dynamicObject.getLong("id"), BasicAgentUserDto.ofThirdApp(dynamicObject));
                }
            });
            thirdAppDto.setAgentUserMap(agentserMap);
        }
        thirdAppDto.setBasicAuthEnable(true);
    }

    @Override
    public void loadData(IDataModel model) {
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        if (thirdAppEditDto.getAgentUserMap() != null && CollectionUtil.isNotEmpty(thirdAppEditDto.getAgentUserMap().values())) {
            ArrayList<BasicAgentUserDto> list = new ArrayList<BasicAgentUserDto>(thirdAppEditDto.getAgentUserMap().values());
            Collections.sort(list, Comparator.comparing(CommonEntryDto::getSeq));
            for (BasicAgentUserDto dto : list) {
                int index = model.createNewEntryRow("entryentity_basicauth");
                model.setValue("agentuserid", (Object)dto.getAgentUserId(), index);
                model.setValue("basesigncode", (Object)dto.getSecretKey(), index);
                model.setValue("showsecretkey", (Object)false, index);
                model.setValue("secretkeydisp", (Object)"******", index);
                model.setValue("basicstatus", (Object)dto.getStatus(), index);
                model.setValue("basicauthid", (Object)dto.getEntryId(), index);
                model.setValue("systag", (Object)dto.getSystag(), index);
                model.setValue("remark", (Object)dto.getRemark(), index);
            }
        }
    }

    @Override
    public void validate(IDataModel model) {
        if (model == null) {
            return;
        }
        StringBuilder message = new StringBuilder();
        DynamicObjectCollection data = model.getEntryEntity("entryentity_basicauth");
        if (data.isEmpty()) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ee3\u7406\u7528\u6237\u3002", (String)"OpenApi3rdappsPlugin_10", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        for (int i = 0; i < data.size(); ++i) {
            DynamicObject apiData = (DynamicObject)data.get(i);
            Long agentUserId = apiData.getLong("agentuserid.id");
            StringBuilder errorMsg = new StringBuilder();
            if (agentUserId == null || agentUserId == 0L) {
                errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u9009\u57fa\u672c\u8ba4\u8bc1-\u4ee3\u7406\u7528\u6237\u3002", (String)"BasicAuthUpdateServiceImpl_0", (String)"bos-open-formplugin", (Object[])new Object[0])).append(" ");
            }
            if (errorMsg.length() <= 0) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\uff1a%1$s, \u6821\u9a8c\u9519\u8bef\uff1a%2$s  %3$s", (String)"AccessControlStrategyEditPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), i + 1, errorMsg.toString(), "\n"));
        }
        if (message.length() > 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, message.toString(), new Object[0]);
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        DynamicObjectCollection saveAfter = model.getEntryEntity("entryentity_basicauth");
        this.validate(model);
        if (saveAfter.size() == 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u82e5\u8981\u4f7f\u7528\u57fa\u672c\u8ba4\u8bc1\uff0c\u8bf7\u7ef4\u62a4\u81f3\u5c11\u4e00\u4e2a\u4ee3\u7406\u7528\u6237\u3002", (String)"OpenApi3rdappsPlugin_13", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        HashMap<Long, BasicAgentUserDto> agentserMap = new HashMap<Long, BasicAgentUserDto>();
        saveAfter.forEach(dynamicObject -> agentserMap.put(dynamicObject.getLong("basicauthid"), BasicAgentUserDto.ofBasicAuthEdit(dynamicObject)));
        thirdAppEditDto.setAgentUserMap(agentserMap);
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        DynamicObjectCollection saveBefore = model.getEntryEntity("entryentity_basicauth");
        Map<Long, BasicAgentUserDto> saveAfter = thirdAppEditDto.getAgentUserMap();
        HashMap beforeDetailMap = new HashMap();
        HashMap<Long, BasicAgentUserDto> afterDetailMap = new HashMap<Long, BasicAgentUserDto>();
        ArrayList beforeIdList = new ArrayList();
        ArrayList<Long> afterIdList = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty((Collection)saveBefore)) {
            saveBefore.forEach(before -> {
                if ("0".equals(before.getString("type"))) {
                    beforeDetailMap.put(before.getLong("id"), before);
                    beforeIdList.add(before.getLong("id"));
                }
            });
        }
        if (saveAfter != null && saveAfter.size() > 0) {
            for (Map.Entry<Long, BasicAgentUserDto> entry : saveAfter.entrySet()) {
                afterIdList.add(entry.getKey());
                afterDetailMap.put(entry.getKey(), entry.getValue());
            }
        }
        List updateList = beforeIdList.stream().filter(num -> afterIdList.contains(num)).collect(Collectors.toList());
        List deleteList = beforeIdList.stream().filter(num -> !afterIdList.contains(num)).collect(Collectors.toList());
        List addList = afterIdList.stream().filter(num -> !beforeIdList.contains(num)).collect(Collectors.toList());
        ArrayList<Integer> deleteIndexList = new ArrayList<Integer>();
        for (int i = 0; i < saveBefore.size(); ++i) {
            DynamicObject agent = (DynamicObject)saveBefore.get(i);
            Long id = agent.getLong("id");
            if (deleteList.indexOf(id) > -1) {
                deleteIndexList.add(agent.getInt("seq") - 1);
                continue;
            }
            if (updateList.indexOf(id) <= -1) continue;
            BasicAgentUserDto afterDto = (BasicAgentUserDto)afterDetailMap.get(id);
            agent.set("agentuserid", (Object)afterDto.getAgentUserId());
            agent.set("basesigncode", (Object)this.encode(afterDto.getSecretKey()));
            agent.set("basicstatus", (Object)afterDto.getStatus());
            agent.set("agentuserid_id", (Object)afterDto.getAgentUserId());
            agent.set("type", (Object)"0");
            agent.set("systag", (Object)afterDto.getSystag());
            agent.set("remark", (Object)afterDto.getRemark());
        }
        if (CollectionUtil.isNotEmpty(deleteIndexList)) {
            model.deleteEntryRows("entryentity_basicauth", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity_basicauth");
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        for (Long newId : addList) {
            BasicAgentUserDto afterDto = (BasicAgentUserDto)afterDetailMap.get(newId);
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("id", (Object)afterDto.getEntryId());
            dynamicObject.set("agentuserid", (Object)afterDto.getAgentUserId());
            dynamicObject.set("basesigncode", (Object)this.encode(afterDto.getSecretKey()));
            dynamicObject.set("basicstatus", (Object)afterDto.getStatus());
            dynamicObject.set("agentuserid_id", (Object)afterDto.getAgentUserId());
            dynamicObject.set("type", (Object)"0");
            dynamicObject.set("systag", (Object)afterDto.getSystag());
            dynamicObject.set("remark", (Object)afterDto.getRemark());
            entryEntity.add((Object)dynamicObject);
        }
        model.updateEntryCache(entryEntity);
        model.setValue("isbasicauth", (Object)"1");
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdStrategyId) {
        if (StringUtil.isEmpty((String)thirdStrategyId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdStrategyId is null.", new Object[0]);
        }
        List deleteIndexList = model.getEntryEntity("entryentity_basicauth").stream().filter(agent -> "0".equals(agent.getString("type"))).map(dy -> dy.getInt("seq") - 1).collect(Collectors.toList());
        model.deleteEntryRows("entryentity_basicauth", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        model.setValue("isbasicauth", (Object)"0");
        this.updateAndDelete(model, Long.valueOf(thirdStrategyId));
    }
}

