/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.CommonEntryDto;
import kd.bos.openapi.form.plugin.thirdapp.entity.EncryptApiDto;
import kd.bos.openapi.form.plugin.thirdapp.entity.StrategyTypeCodeEnum;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;

public class EncryptUpdateServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppDto) {
        DynamicObjectCollection dyc = null;
        if (model == null) {
            DynamicObject thirdApp = this.loadThirdApp(thirdAppDto.getId());
            if (thirdApp != null) {
                thirdAppDto.setSignAuthEnable(thirdApp.getBoolean("is_signature"));
                thirdAppDto.setEncryptAllApi(thirdApp.getBoolean("encryptallapi"));
                thirdAppDto.setEncryption(thirdApp.getLong("apiencryption"));
                dyc = thirdApp.getDynamicObjectCollection("enstrategyentity");
            }
        } else {
            thirdAppDto.setSignAuthEnable((Boolean)model.getValue("is_signature"));
            thirdAppDto.setEncryptAllApi((Boolean)model.getValue("encryptallapi"));
            thirdAppDto.setEncryption((Long)model.getValue("apiencryption"));
            dyc = model.getEntryEntity("enstrategyentity");
        }
        if (dyc != null) {
            ArrayList<EncryptApiDto> encryptApiList = new ArrayList<EncryptApiDto>();
            dyc.forEach(dynamicObject -> encryptApiList.add(EncryptApiDto.ofThirdApp(dynamicObject)));
            thirdAppDto.setEncryptApiEditList(encryptApiList);
        }
    }

    @Override
    public void loadData(IDataModel model) {
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        model.setValue("encryptallapi", (Object)thirdAppEditDto.isEncryptAllApi());
        String isNew = thirdAppEditDto.getIsNew();
        String strategyCode = thirdAppEditDto.getStrategyCode();
        String apiEncryption = "1";
        if ("1".equals(isNew)) {
            if (StrategyTypeCodeEnum.ENCRYPT_AES.getType().equals(strategyCode)) {
                apiEncryption = "1";
            } else if (StrategyTypeCodeEnum.ENCRYPT_SM4.getType().equals(strategyCode)) {
                apiEncryption = "2";
            }
        } else {
            apiEncryption = thirdAppEditDto.getEncryption() == 0L ? "1" : thirdAppEditDto.getEncryption() + "";
        }
        model.setValue("apiencryption", (Object)apiEncryption);
        List<EncryptApiDto> list = thirdAppEditDto.getEncryptApiEditList();
        if (CollectionUtil.isNotEmpty(list)) {
            Collections.sort(list, Comparator.comparing(CommonEntryDto::getSeq));
            for (EncryptApiDto dto : list) {
                int index = model.createNewEntryRow("enstrategyentity");
                model.setValue("apiservice1", (Object)dto.getApiId(), index);
                model.setValue("thirdencryptapiid", (Object)dto.getEntryId(), index);
            }
        }
    }

    @Override
    public void validate(IDataModel model) {
        if (model == null) {
            return;
        }
        StringBuilder message = new StringBuilder();
        Boolean isEncryptAllApi = (Boolean)model.getValue("encryptallapi");
        if (!isEncryptAllApi.booleanValue()) {
            DynamicObjectCollection data = model.getEntryEntity("enstrategyentity");
            if (data.isEmpty()) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u52a0\u5bc6\u7684API\u3002", (String)"EncryptUpdateServiceImpl_0", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject apiData = (DynamicObject)data.get(i);
                Long apiId = apiData.getLong("apiservice1.id");
                StringBuilder errorMsg = new StringBuilder();
                if (apiId == null || apiId == 0L) {
                    errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u5728API\u7f16\u7801\u4e2d\u9009\u62e9API\u3002", (String)"EncryptUpdateServiceImpl_1", (String)"bos-open-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (errorMsg.length() <= 0) continue;
                message.append(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\uff1a%1$s, \u6821\u9a8c\u9519\u8bef\uff1a%2$s  %3$s", (String)"AccessControlStrategyEditPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), i + 1, errorMsg.toString(), "\n"));
            }
        }
        if (message.length() > 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, message.toString(), new Object[0]);
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        this.validate(model);
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        thirdAppEditDto.setEncryptAllApi((Boolean)model.getValue("encryptallapi"));
        thirdAppEditDto.setEncryption(Long.valueOf((String)model.getValue("apiencryption")));
        DynamicObjectCollection saveAfter = model.getEntryEntity("enstrategyentity");
        ArrayList<EncryptApiDto> encryptApiList = new ArrayList<EncryptApiDto>();
        saveAfter.forEach(dynamicObject -> encryptApiList.add(EncryptApiDto.ofEdit(dynamicObject, thirdAppEditDto.getId())));
        thirdAppEditDto.setEncryptApiEditList(encryptApiList);
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        DynamicObjectCollection saveBefore = model.getEntryEntity("enstrategyentity");
        List<EncryptApiDto> saveAfter = thirdAppEditDto.getEncryptApiEditList();
        HashMap beforeDetailMap = new HashMap();
        HashMap<Long, EncryptApiDto> afterDetailMap = new HashMap<Long, EncryptApiDto>();
        ArrayList beforeIdList = new ArrayList();
        ArrayList<Long> afterIdList = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty((Collection)saveBefore)) {
            saveBefore.forEach(before -> {
                beforeDetailMap.put(before.getLong("id"), before);
                beforeIdList.add(before.getLong("id"));
            });
        }
        if (saveAfter != null && saveAfter.size() > 0) {
            for (EncryptApiDto entry : saveAfter) {
                afterIdList.add(entry.getEntryId());
                afterDetailMap.put(entry.getEntryId(), entry);
            }
        }
        List updateList = beforeIdList.stream().filter(num -> afterIdList.contains(num)).collect(Collectors.toList());
        List deleteList = beforeIdList.stream().filter(num -> !afterIdList.contains(num)).collect(Collectors.toList());
        List addList = afterIdList.stream().filter(num -> !beforeIdList.contains(num)).collect(Collectors.toList());
        ArrayList<Integer> deleteIndexList = new ArrayList<Integer>();
        for (int i = 0; i < saveBefore.size(); ++i) {
            DynamicObject agent = (DynamicObject)saveBefore.get(i);
            Long id = agent.getLong("id");
            if (deleteList.indexOf(id) > -1) {
                deleteIndexList.add(agent.getInt("seq") - 1);
                continue;
            }
            if (updateList.indexOf(id) <= -1) continue;
            EncryptApiDto afterDto = (EncryptApiDto)afterDetailMap.get(id);
            agent.set("apiservice1_id", (Object)afterDto.getApiId());
        }
        if (CollectionUtil.isNotEmpty(deleteIndexList)) {
            model.deleteEntryRows("enstrategyentity", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("enstrategyentity");
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        for (Long newId : addList) {
            EncryptApiDto afterDto = (EncryptApiDto)afterDetailMap.get(newId);
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("id", (Object)afterDto.getEntryId());
            dynamicObject.set("apiservice1_id", (Object)afterDto.getApiId());
            entryEntity.add((Object)dynamicObject);
        }
        model.updateEntryCache(entryEntity);
        model.setValue("encryptallapi", (Object)(thirdAppEditDto.isEncryptAllApi() ? "1" : "0"));
        model.setValue("apiencryption", (Object)thirdAppEditDto.getEncryption());
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdStrategyId) {
        if (StringUtil.isEmpty((String)thirdStrategyId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdStrategyId is null.", new Object[0]);
        }
        List deleteIndexList = model.getEntryEntity("enstrategyentity").stream().map(dy -> dy.getInt("seq") - 1).collect(Collectors.toList());
        model.deleteEntryRows("enstrategyentity", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        model.setValue("encryptallapi", (Object)"0");
        this.updateAndDelete(model, Long.valueOf(thirdStrategyId));
    }
}

