/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.IpTypeEnum;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.IPWhiteListUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.CommonEntryDto;
import kd.bos.openapi.form.plugin.thirdapp.entity.IpPolicyDto;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;

public class IpListUpdateServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppDto) {
        DynamicObjectCollection dyc = null;
        if (model == null) {
            DynamicObject thirdApp = this.loadThirdApp(thirdAppDto.getId());
            if (thirdApp != null) {
                thirdAppDto.setAllowallapi(thirdApp.getBoolean("allowip"));
                dyc = thirdApp.getDynamicObjectCollection("entryentity_ip");
            }
        } else {
            thirdAppDto.setAllowallapi((Boolean)model.getValue("allowip"));
            dyc = model.getEntryEntity("entryentity_ip");
        }
        if (dyc != null) {
            HashMap<Long, IpPolicyDto> ipPolicyDtoMap = new HashMap<Long, IpPolicyDto>();
            dyc.forEach(dynamicObject -> ipPolicyDtoMap.put(dynamicObject.getLong("id"), IpPolicyDto.ofThirdApp(dynamicObject)));
            thirdAppDto.setIpPolicyEditMap(ipPolicyDtoMap);
        }
    }

    @Override
    public void loadData(IDataModel model) {
        ArrayList<IpPolicyDto> list;
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        model.setValue("allowip", (Object)thirdAppEditDto.isAllowallapi());
        if (thirdAppEditDto.getIpPolicyEditMap() != null && CollectionUtil.isNotEmpty(thirdAppEditDto.getIpPolicyEditMap().values()) && CollectionUtil.isNotEmpty(list = new ArrayList<IpPolicyDto>(thirdAppEditDto.getIpPolicyEditMap().values()))) {
            Collections.sort(list, Comparator.comparing(CommonEntryDto::getSeq));
            for (IpPolicyDto dto : list) {
                int index = model.createNewEntryRow("entryentity_ip");
                model.setValue("startip", (Object)dto.getStartIp(), index);
                model.setValue("endip", (Object)dto.getEndIp(), index);
                model.setValue("thirdipid", (Object)dto.getEntryId(), index);
                model.setValue("policytype", (Object)(StringUtil.isEmpty((String)dto.getPolicyType()) ? "0" : dto.getPolicyType()), index);
                model.setValue("iptype", (Object)(StringUtil.isEmpty((String)dto.getIpType()) ? "0" : dto.getIpType()), index);
            }
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        this.validate(model);
        DynamicObjectCollection saveAfter = model.getEntryEntity("entryentity_ip");
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        thirdAppEditDto.setAllowip((Boolean)model.getValue("allowip"));
        HashMap<Long, IpPolicyDto> ipPolicyDtoMap = new HashMap<Long, IpPolicyDto>();
        saveAfter.forEach(dynamicObject -> ipPolicyDtoMap.put(dynamicObject.getLong("thirdipid"), IpPolicyDto.ofEdit(dynamicObject, thirdAppEditDto.getId())));
        thirdAppEditDto.setIpPolicyEditMap(ipPolicyDtoMap);
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void validate(IDataModel model) {
        DynamicObjectCollection data = model.getEntryEntity("entryentity_ip");
        if (data == null || data.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            boolean endIpValidate;
            boolean startIpValidate;
            DynamicObject ipLine = (DynamicObject)data.get(i);
            String startIp = ipLine.getString("startip");
            String endIp = ipLine.getString("endip");
            String policyType = ipLine.getString("policytype");
            String ipType = ipLine.getString("iptype");
            ipType = StringUtil.isEmpty((String)ipType) ? IpTypeEnum.IPV4.getType() : ipType;
            StringBuilder errorMsg = new StringBuilder();
            if (IpTypeEnum.IPV4.getType().equals(ipType)) {
                startIpValidate = IPWhiteListUtil.isValidIpAddress((String)startIp);
                endIpValidate = IPWhiteListUtil.isValidIpAddress((String)endIp);
                if (!startIpValidate || !endIpValidate) {
                    errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684IPv4\uff0c\u8303\u56f40.0.0.0 ~ 255.255.255.255\u3002", (String)"OpenApi3rdappsPlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0])).append(" ");
                } else if (startIpValidate && endIpValidate && !IPWhiteListUtil.compareIp((String)startIp, (String)endIp)) {
                    errorMsg.append(ResManager.loadKDString((String)"\u7ed3\u675fIP\u5fc5\u987b\u5927\u4e8e\u8d77\u59cbIP\u3002", (String)"OpenApi3rdappsPlugin_5", (String)"bos-open-formplugin", (Object[])new Object[0])).append(" ");
                }
                if (StringUtil.isEmpty((String)policyType)) {
                    errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9IP\u7b56\u7565\u3002", (String)"IpListUpdateServiceImpl_1", (String)"bos-open-formplugin", (Object[])new Object[0])).append(" ");
                }
            } else if (IpTypeEnum.IPV6.getType().equals(ipType)) {
                startIpValidate = IPWhiteListUtil.isValidIpV6Address((String)startIp);
                endIpValidate = IPWhiteListUtil.isValidIpV6Address((String)endIp);
                if (!startIpValidate || !endIpValidate) {
                    errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684IPv6\u683c\u5f0f\uff0cxxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx\uff0c\u5176\u4e2d\uff0c\u6bcf\u4e2ax\u90fd\u662f\u5341\u516d\u8fdb\u5236\u6570\uff0c\u53ef\u7701\u7565\u524d\u5bfc\u96f6\u3002\u793a\u4f8b\uff1aCDDC:0000:0000:0000:8475:1111:3900:2020", (String)"IpListUpdateServiceImpl_0", (String)"bos-open-formplugin", (Object[])new Object[0])).append(" ");
                } else if (startIpValidate && endIpValidate && !IPWhiteListUtil.compareIpv6((String)startIp, (String)endIp)) {
                    errorMsg.append(ResManager.loadKDString((String)"\u7ed3\u675fIP\u5fc5\u987b\u5927\u4e8e\u8d77\u59cbIP\u3002", (String)"OpenApi3rdappsPlugin_5", (String)"bos-open-formplugin", (Object[])new Object[0])).append(" ");
                }
            } else {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "invalid ipType:" + ipType, new Object[0]);
            }
            if (errorMsg.length() <= 0) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\uff1a%1$s, \u6821\u9a8c\u9519\u8bef\uff1a%2$s  %3$s", (String)"AccessControlStrategyEditPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), i + 1, errorMsg.toString(), "\n"));
        }
        if (message.length() > 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, message.toString(), new Object[0]);
        }
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        DynamicObjectCollection saveBefore = model.getEntryEntity("entryentity_ip");
        Map<Long, IpPolicyDto> saveAfter = thirdAppEditDto.getIpPolicyEditMap();
        HashMap beforeDetailMap = new HashMap();
        HashMap<Long, IpPolicyDto> afterDetailMap = new HashMap<Long, IpPolicyDto>();
        ArrayList beforeIdList = new ArrayList();
        ArrayList<Long> afterIdList = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty((Collection)saveBefore)) {
            saveBefore.forEach(before -> {
                beforeDetailMap.put(before.getLong("id"), before);
                beforeIdList.add(before.getLong("id"));
            });
        }
        if (saveAfter != null && saveAfter.size() > 0) {
            for (Map.Entry<Long, IpPolicyDto> entry : saveAfter.entrySet()) {
                afterIdList.add(entry.getKey());
                afterDetailMap.put(entry.getKey(), entry.getValue());
            }
        }
        List updateList = beforeIdList.stream().filter(num -> afterIdList.contains(num)).collect(Collectors.toList());
        List deleteList = beforeIdList.stream().filter(num -> !afterIdList.contains(num)).collect(Collectors.toList());
        List addList = afterIdList.stream().filter(num -> !beforeIdList.contains(num)).collect(Collectors.toList());
        ArrayList<Integer> deleteIndexList = new ArrayList<Integer>();
        for (int i = 0; i < saveBefore.size(); ++i) {
            DynamicObject agent = (DynamicObject)saveBefore.get(i);
            Long id = agent.getLong("id");
            if (deleteList.indexOf(id) > -1) {
                deleteIndexList.add(agent.getInt("seq") - 1);
                continue;
            }
            if (updateList.indexOf(id) <= -1) continue;
            IpPolicyDto afterDto = (IpPolicyDto)afterDetailMap.get(id);
            agent.set("startip", (Object)afterDto.getStartIp());
            agent.set("endip", (Object)afterDto.getEndIp());
            agent.set("policytype", (Object)afterDto.getPolicyType());
            agent.set("iptype", (Object)afterDto.getIpType());
        }
        if (CollectionUtil.isNotEmpty(deleteIndexList)) {
            model.deleteEntryRows("entryentity_ip", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity_ip");
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        for (Long newId : addList) {
            IpPolicyDto afterDto = (IpPolicyDto)afterDetailMap.get(newId);
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("id", (Object)afterDto.getEntryId());
            dynamicObject.set("startip", (Object)afterDto.getStartIp());
            dynamicObject.set("endip", (Object)afterDto.getEndIp());
            dynamicObject.set("policytype", (Object)afterDto.getPolicyType());
            dynamicObject.set("iptype", (Object)afterDto.getIpType());
            entryEntity.add((Object)dynamicObject);
        }
        model.updateEntryCache(entryEntity);
        model.setValue("allowip", (Object)(thirdAppEditDto.isAllowip() ? "1" : "0"));
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdStrategyId) {
        if (StringUtil.isEmpty((String)thirdStrategyId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdStrategyId is null.", new Object[0]);
        }
        List deleteIndexList = model.getEntryEntity("entryentity_ip").stream().map(dy -> dy.getInt("seq") - 1).collect(Collectors.toList());
        model.deleteEntryRows("entryentity_ip", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        model.setValue("allowip", (Object)"1");
        this.updateAndDelete(model, Long.valueOf(thirdStrategyId));
    }
}

