/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;

public class JwtAuthUpdateServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        if (model == null) {
            DynamicObject thirdApp = this.loadThirdApp(thirdAppEditDto.getId());
            if (thirdApp != null) {
                thirdAppEditDto.setJwtShaKey(thirdApp.getString("securitypublickey"));
                thirdAppEditDto.setJwtSignType(thirdApp.getLong("jwt_type"));
            }
        } else {
            thirdAppEditDto.setJwtShaKey((String)model.getValue("securitypublickey"));
            thirdAppEditDto.setJwtSignType((Long)model.getValue("jwt_type"));
        }
        thirdAppEditDto.setJwtAuthEnable(true);
    }

    @Override
    public void loadData(IDataModel model) {
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        model.setValue("securitypublickey", (Object)thirdAppEditDto.getJwtShaKey());
        model.setValue("jwt_type", (Object)("1".equals(thirdAppEditDto.getIsNew()) ? "1" : thirdAppEditDto.getJwtSignType() + ""));
    }

    @Override
    public void validate(IDataModel model) {
        if (model == null) {
            return;
        }
        String jwtSignKey = (String)model.getValue("securitypublickey");
        if (StringUtils.isBlank((CharSequence)jwtSignKey)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u8ba4\u8bc1\u5bc6\u94a5\u3002", (String)"AuthStrategyEditPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        this.validate(model);
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        thirdAppEditDto.setJwtShaKey(this.encode((String)model.getValue("securitypublickey")));
        thirdAppEditDto.setJwtSignType(Long.valueOf((String)model.getValue("jwt_type")));
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        model.setValue("securitypublickey", (Object)thirdAppEditDto.getJwtShaKey());
        model.setValue("jwtasymmetic", (Object)"1");
        model.setValue("jwt_type", (Object)thirdAppEditDto.getJwtSignType());
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdAppStrategyId) {
        if (StringUtil.isEmpty((String)thirdAppStrategyId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdStrategyId is null.", new Object[0]);
        }
        model.setValue("jwtasymmetic", (Object)"0");
        model.setValue("securitypublickey", (Object)"");
        this.updateAndDelete(model, Long.valueOf(thirdAppStrategyId));
    }
}

