/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.CommonEntryDto;
import kd.bos.openapi.form.plugin.thirdapp.entity.SsoIpPolicyDto;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;

public class SsoIPServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppDto) {
        DynamicObjectCollection dyc = null;
        if (model == null) {
            DynamicObject thirdApp = this.loadThirdApp(thirdAppDto.getId());
            if (thirdApp != null) {
                dyc = thirdApp.getDynamicObjectCollection("entity_ssoip");
            }
        } else {
            dyc = model.getEntryEntity("entity_ssoip");
        }
        if (dyc != null) {
            HashMap<Long, SsoIpPolicyDto> ssoIpPolicyDtoMap = new HashMap<Long, SsoIpPolicyDto>();
            dyc.forEach(dynamicObject -> {
                SsoIpPolicyDto ssoIpPolicyDto = SsoIpPolicyDto.ofThirdApp(dynamicObject);
                ssoIpPolicyDtoMap.put(dynamicObject.getLong("id"), ssoIpPolicyDto);
            });
            thirdAppDto.setSsoIpPolicyEditMap(ssoIpPolicyDtoMap);
        }
    }

    @Override
    public void loadData(IDataModel model) {
        ArrayList<SsoIpPolicyDto> list;
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        if (thirdAppEditDto.getSsoIpPolicyEditMap() != null && CollectionUtil.isNotEmpty(thirdAppEditDto.getSsoIpPolicyEditMap().values()) && CollectionUtil.isNotEmpty(list = new ArrayList<SsoIpPolicyDto>(thirdAppEditDto.getSsoIpPolicyEditMap().values()))) {
            Collections.sort(list, Comparator.comparing(CommonEntryDto::getSeq));
            for (SsoIpPolicyDto dto : list) {
                int index = model.createNewEntryRow("entity_ssoip");
                model.setValue("domain_ip", (Object)dto.getDomainIp(), index);
                model.setValue("thirdipid1", (Object)dto.getEntryId(), index);
            }
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        this.validate(model);
        DynamicObjectCollection saveAfter = model.getEntryEntity("entity_ssoip");
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        HashMap<Long, SsoIpPolicyDto> ssoIpPolicyDtoMap = new HashMap<Long, SsoIpPolicyDto>();
        saveAfter.forEach(dynamicObject -> {
            SsoIpPolicyDto ssoIpPolicyDto = SsoIpPolicyDto.ofEdit(dynamicObject, thirdAppEditDto.getId());
            ssoIpPolicyDto.setDomainIp(dynamicObject.getString("domain_ip"));
            ssoIpPolicyDtoMap.put(dynamicObject.getLong("thirdipid1"), ssoIpPolicyDto);
        });
        thirdAppEditDto.setSsoIpPolicyEditMap(ssoIpPolicyDtoMap);
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void validate(IDataModel model) {
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        DynamicObjectCollection saveBefore = model.getEntryEntity("entity_ssoip");
        Map<Long, SsoIpPolicyDto> saveAfter = thirdAppEditDto.getSsoIpPolicyEditMap();
        HashMap beforeDetailMap = new HashMap();
        HashMap<Long, SsoIpPolicyDto> afterDetailMap = new HashMap<Long, SsoIpPolicyDto>();
        ArrayList beforeIdList = new ArrayList();
        ArrayList<Long> afterIdList = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty((Collection)saveBefore)) {
            saveBefore.forEach(before -> {
                beforeDetailMap.put(before.getLong("id"), before);
                beforeIdList.add(before.getLong("id"));
            });
        }
        if (saveAfter != null && saveAfter.size() > 0) {
            for (Map.Entry<Long, SsoIpPolicyDto> entry : saveAfter.entrySet()) {
                afterIdList.add(entry.getKey());
                afterDetailMap.put(entry.getKey(), entry.getValue());
            }
        }
        List updateList = beforeIdList.stream().filter(num -> afterIdList.contains(num)).collect(Collectors.toList());
        List deleteList = beforeIdList.stream().filter(num -> !afterIdList.contains(num)).collect(Collectors.toList());
        List addList = afterIdList.stream().filter(num -> !beforeIdList.contains(num)).collect(Collectors.toList());
        ArrayList<Integer> deleteIndexList = new ArrayList<Integer>();
        for (int i = 0; i < saveBefore.size(); ++i) {
            DynamicObject agent = (DynamicObject)saveBefore.get(i);
            Long id = agent.getLong("id");
            if (deleteList.indexOf(id) > -1) {
                deleteIndexList.add(agent.getInt("seq") - 1);
                continue;
            }
            if (updateList.indexOf(id) <= -1) continue;
            SsoIpPolicyDto afterDto = (SsoIpPolicyDto)afterDetailMap.get(id);
            agent.set("domain_ip", (Object)afterDto.getDomainIp());
        }
        if (CollectionUtil.isNotEmpty(deleteIndexList)) {
            model.deleteEntryRows("entity_ssoip", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entity_ssoip");
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        for (Long newId : addList) {
            SsoIpPolicyDto afterDto = (SsoIpPolicyDto)afterDetailMap.get(newId);
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("id", (Object)afterDto.getEntryId());
            dynamicObject.set("domain_ip", (Object)afterDto.getDomainIp());
            entryEntity.add((Object)dynamicObject);
        }
        model.updateEntryCache(entryEntity);
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdStrategyId) {
        if (StringUtil.isEmpty((String)thirdStrategyId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdStrategyId is null.", new Object[0]);
        }
        List deleteIndexList = model.getEntryEntity("entity_ssoip").stream().map(dy -> dy.getInt("seq") - 1).collect(Collectors.toList());
        model.deleteEntryRows("entity_ssoip", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        this.updateAndDelete(model, Long.valueOf(thirdStrategyId));
    }
}

