/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.openapi.api.plugin.ApiDeserializerPlugin;
import kd.bos.openapi.api.plugin.ApiSerializerPlugin;
import kd.bos.openapi.api.result.ApiServiceResult;
import kd.bos.openapi.api.util.ApiService;
import kd.bos.openapi.base.custom.CustomApiUtil;
import kd.bos.openapi.base.dts.EntityDts;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.AsyncTypeEnum;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.constant.PluginType;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.graph.DirectedGraph;
import kd.bos.openapi.common.model.PluginInfo;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.PluginUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.Triple;
import kd.bos.openapi.form.util.ApiResource;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.openapi.form.util.OpenApiTestUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.url.UrlService;

public class ApiPluginUtil {
    private static Log log = LogFactory.getLog(ApiPluginUtil.class);
    private static final String KEY_HEADER_ENTRY = "headerentryentity";
    private static final String HEADERNAME = "headername";
    public static final String ID = "id";
    private static final String ISV_KINGDEE = "kingdee";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_URLFORMAT = "urlformat";
    private static final String COSMIC_MATCH = "[1-9]\\d*[.]\\d+[.]\\d+";
    private static final String KEY_ALLOWGUEST = "allowguest";
    private static final String EXT_KEY = "ext_key";
    private static final String EXT_VALUE = "ext_value";
    private static final String BODYTAB = "bodytab";
    public static final String TABAP = "tabap";
    private static final String KEY_BIZOBJECT = "bizobject";
    private static final String SAVE = "save";
    private static final String KEY_OPERATION = "operation";
    private static final String FULLURLFORMAT = "fullurlformat";
    private static final Set<String> saveIgnoreStatusSet = new HashSet<String>();
    private static final Map<String, String> saveInEntryMap = new HashMap<String, String>();

    public static void beforeSaveSetExtEntry(IDataModel model, String formId) {
        saveInEntryMap.forEach((key_formId, value_field) -> {
            if (!key_formId.equals(formId)) {
                return;
            }
            String[] splitKey = value_field.split(",");
            Arrays.stream(splitKey).forEach(key -> ApiPluginUtil.setValueToExtEntry(key, model.getValue(key), model));
        });
    }

    public static void beforeLoadGetExtEntry(IDataModel model) {
        saveInEntryMap.forEach((mapKey, mapValue) -> {
            Object value = ApiPluginUtil.getValueFromExtEntry(mapValue, model);
            if (mapValue.equals("maxsaveentrysize")) {
                model.setValue("maxsaveentrysize", (Object)DataUtil.i((Object)value));
            } else {
                model.setValue(mapValue, value);
            }
        });
    }

    public static void beforeLoadGetExtEntry(IDataModel model, String formId) {
        model.beginInit();
        saveInEntryMap.forEach((mapKey, mapValue) -> {
            if (mapKey.equals(formId)) {
                String[] splitKey = mapValue.split(",");
                Arrays.stream(splitKey).forEach(key -> {
                    Object value = ApiPluginUtil.getValueFromExtEntry(key, model);
                    if (key.equals("maxsaveentrysize")) {
                        model.setValue("maxsaveentrysize", (Object)DataUtil.i((Object)value));
                    } else {
                        model.setValue(key, value);
                    }
                });
            }
        });
        model.endInit();
    }

    public static Object getValueFromExtEntry(String key, IDataModel model) {
        DynamicObjectCollection extEntity = model.getDataEntity(true).getDynamicObjectCollection("extentity");
        if (CollectionUtils.isEmpty((Collection)extEntity)) {
            return null;
        }
        Object value = null;
        for (DynamicObject obj : extEntity) {
            if (!key.equals(obj.getString(EXT_KEY))) continue;
            value = obj.get(EXT_VALUE);
        }
        return value;
    }

    public static void setValueToExtEntry(String key, Object value, IDataModel model) {
        DynamicObjectCollection extEntity = model.getDataEntity(true).getDynamicObjectCollection("extentity");
        if (CollectionUtils.isEmpty((Collection)extEntity)) {
            DynamicObject row = extEntity.addNew();
            row.set(EXT_KEY, (Object)key);
            row.set(EXT_VALUE, value);
            return;
        }
        boolean flag = true;
        for (DynamicObject obj : extEntity) {
            if (!key.equals(obj.getString(EXT_KEY))) continue;
            obj.set(EXT_VALUE, value);
            flag = false;
        }
        if (flag) {
            DynamicObject row = extEntity.addNew();
            row.set(EXT_KEY, (Object)key);
            row.set(EXT_VALUE, value);
        }
    }

    public static void isVisiableAnonymous(IFormView view) {
        String login_api_support_anonymous = SystemPropertyUtils.getProptyByTenant((String)"login_api_support_anonymous", (String)RequestContext.get().getTenantId());
        if ("true".equals(login_api_support_anonymous)) {
            view.setVisible(Boolean.TRUE, new String[]{KEY_ALLOWGUEST});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{KEY_ALLOWGUEST});
        }
    }

    public static void bodyOrQueryTabVisible(IFormView view) {
        if (view.getModel().getValue("httpmethod") != null) {
            String httpMethod = view.getModel().getValue("httpmethod").toString();
            TabPage bodyTab = (TabPage)view.getControl(BODYTAB);
            if ("0".equals(httpMethod)) {
                bodyTab.setText(new LocaleString(ResManager.loadKDString((String)"Query\u53c2\u6570", (String)"OpenApiCustomApiFormPlugin_23", (String)"bos-open-formplugin", (Object[])new Object[0])));
            } else {
                bodyTab.setText(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53", (String)"OpenApiCustomApiFormPlugin_22", (String)"bos-open-formplugin", (Object[])new Object[0])));
            }
            Tab tabap = (Tab)view.getControl(TABAP);
            tabap.activeTab(BODYTAB);
        }
    }

    public static void buildHeader(IDataModel model) {
        DynamicObjectCollection header = model.getDataEntity(false).getDynamicObjectCollection(KEY_HEADER_ENTRY);
        DynamicObjectCollection header2 = (DynamicObjectCollection)header.clone();
        int flag = 0;
        for (DynamicObject dynamicObject : header) {
            if (!ApiPluginUtil.isPreHeader(dynamicObject.getString(HEADERNAME))) continue;
            ++flag;
        }
        if (flag == 3) {
            return;
        }
        model.deleteEntryData(KEY_HEADER_ENTRY);
        int index1 = model.createNewEntryRow(KEY_HEADER_ENTRY);
        model.setValue(HEADERNAME, (Object)"Content-Type", index1);
        model.setValue("headervalue", (Object)"application/json", index1);
        model.setValue("headerdes", (Object)ResManager.loadKDString((String)"\u5185\u5bb9\u683c\u5f0f", (String)"OpenApiFormPlugin_78", (String)"bos-open-formplugin", (Object[])new Object[0]), index1);
        model.setValue("headerdefaultvalue", (Object)" ", index1);
        int index2 = model.createNewEntryRow(KEY_HEADER_ENTRY);
        model.setValue(HEADERNAME, (Object)"accessToken", index2);
        model.setValue("headervalue", (Object)ResManager.loadKDString((String)"\u83b7\u53d6\u7684accessToken\u503c", (String)"OpenApiFormPlugin_76", (String)"bos-open-formplugin", (Object[])new Object[0]), index2);
        model.setValue("headerdes", (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u4ee4\u724c", (String)"OpenApiFormPlugin_77", (String)"bos-open-formplugin", (Object[])new Object[0]), index2);
        model.setValue("headerdefaultvalue", (Object)" ", index2);
        int index3 = model.createNewEntryRow(KEY_HEADER_ENTRY);
        model.setValue(HEADERNAME, (Object)"Idempotency-Key", index3);
        model.setValue("headervalue", (Object)ResManager.loadKDString((String)"\u552f\u4e00\u7684requestId", (String)"OpenApiFormPlugin_94", (String)"bos-open-formplugin", (Object[])new Object[0]), index3);
        model.setValue("headerdes", (Object)ResManager.loadKDString((String)"\u975e\u5fc5\u4f20\u53c2\u6570\uff0c\u9632\u6b62\u63a5\u53e3\u88ab\u91cd\u590d\u8c03\u7528", (String)"OpenApiFormPlugin_75", (String)"bos-open-formplugin", (Object[])new Object[0]), index3);
        model.setValue("headerdefaultvalue", (Object)" ", index3);
        header2.forEach(it -> {
            if (ApiPluginUtil.isPreHeader(it.getString(HEADERNAME))) {
                return;
            }
            int index = model.createNewEntryRow(KEY_HEADER_ENTRY);
            model.setValue(HEADERNAME, (Object)it.getString(HEADERNAME), index);
            model.setValue("headervalue", (Object)it.getString("headervalue"), index);
            model.setValue("headerdes", (Object)it.getString("headerdes"), index);
            model.setValue("headerdefaultvalue", (Object)it.getString("headerdefaultvalue"), index);
        });
    }

    public static void checkHeaderBeforeSave(IDataModel model) {
        DynamicObjectCollection headers = model.getEntryEntity(KEY_HEADER_ENTRY);
        if (!CollectionUtils.isEmpty((Collection)headers)) {
            String name = null;
            for (DynamicObject header : headers) {
                int seq = header.getInt("seq");
                if (seq <= 3 || !ApiPluginUtil.isPreHeader(name = header.getString(HEADERNAME))) continue;
                throw new OpenApiException(ApiErrorCode.Data_Duplicate, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570->\u8bf7\u6c42\u5934\u90e8%1$s %2$s\u53c2\u6570\u540d\u79f0:%3$s\u5df2\u7531\u7cfb\u7edf\u9884\u7f6e\uff0c\u8bf7\u624b\u52a8\u79fb\u9664\u3002", (String)"OpenApiFormPlugin_10", (String)"bos-open-formplugin", (Object[])new Object[0]), "\\r", "\\n", name), new Object[0]);
            }
        }
    }

    public static void validatorMutiLang(ChangeData changeData, String propName, DataType type) {
        DynamicObjectCollection dataNewValueColection = (DynamicObjectCollection)changeData.getNewValue();
        if (dataNewValueColection == null || dataNewValueColection.size() <= 0) {
            return;
        }
        dataNewValueColection.forEach(dataNewValue -> {
            String newValueExample = String.valueOf(dataNewValue.get(propName));
            if (StringUtil.isEmpty((String)newValueExample)) {
                return;
            }
            if (type == DataType.STRUCT) {
                type.validator(JSON.parse((String)JacksonUtil.writeValueAsString((Object)newValueExample)));
                return;
            }
            type.validator(JSON.parse((String)newValueExample));
        });
    }

    public static void validatorHeaders(IDataModel headerModel, IFormView formView) {
        if (StringUtil.isEmpty((String)String.valueOf(headerModel.getValue("headerdefaultvalue")))) {
            return;
        }
        if ("accessToken".equalsIgnoreCase(String.valueOf(headerModel.getValue(HEADERNAME)))) {
            headerModel.setValue("headerdefaultvalue", null);
            formView.showTipNotification(ResManager.loadKDString((String)"accessToken\u4e0d\u652f\u6301\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u3002", (String)"OpenApiFormPlugin_103", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
        if ("Idempotency-Key".equalsIgnoreCase(String.valueOf(headerModel.getValue(HEADERNAME)))) {
            headerModel.setValue("headerdefaultvalue", null);
            formView.showTipNotification(ResManager.loadKDString((String)"Idempotency-Key\u4e0d\u652f\u6301\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u3002", (String)"OpenApiFormPlugin_104", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    public static void handleMulLang(IDataModel iDataModel, String files, ILocaleString localeString, int index) {
        OrmLocaleValue localeOrmValue = (OrmLocaleValue)iDataModel.getValue(files, index - 1);
        if (localeOrmValue == null || localeString == null) {
            return;
        }
        if (null == localeString.getLocaleValue() || "".equals(localeString.getLocaleValue())) {
            localeString.setLocaleValue("-");
        }
        localeOrmValue.putAll((Map)localeString);
        iDataModel.setValue(files, (Object)localeOrmValue, index - 1);
    }

    public static void handleMulLang(IDataModel iDataModel, String files, ILocaleString localeString) {
        OrmLocaleValue localeOrmValue = (OrmLocaleValue)iDataModel.getValue(files);
        if (localeOrmValue == null || localeString == null) {
            return;
        }
        localeOrmValue.putAll((Map)localeString);
        iDataModel.setValue(files, (Object)localeOrmValue);
    }

    public static void preSetHeader(IDataModel dataModel) {
        DynamicObjectCollection header = dataModel.getDataEntity(false).getDynamicObjectCollection(KEY_HEADER_ENTRY);
        if (header == null || header.size() <= 0) {
            ApiPluginUtil.buildHeader(dataModel);
        }
    }

    public static boolean isPreHeader(String name) {
        return "Content-Type".equalsIgnoreCase(name) || "accesstoken".equalsIgnoreCase(name) || "access_token".equalsIgnoreCase(name) || "Idempotency-Key".equalsIgnoreCase(name);
    }

    public static boolean checkHeaderRepeat(IDataModel dataModel, String val) {
        DynamicObjectCollection header = dataModel.getDataEntity(true).getDynamicObjectCollection(KEY_HEADER_ENTRY);
        HashMap map = new HashMap(header.size());
        header.stream().forEach(it -> {
            String headerName = it.getString(HEADERNAME);
            if (map.containsKey(headerName)) {
                map.put(headerName, (Integer)map.get(headerName) + 1);
            } else {
                map.put(headerName, 1);
            }
        });
        return map.containsKey(val) && (Integer)map.get(val) > 1;
    }

    public static void dealHeaderWhenChanged(IDataModel dataModel, IFormView view, String newVal) {
        if (newVal != null && ApiPluginUtil.checkHeaderRepeat(dataModel, newVal)) {
            dataModel.setValue(HEADERNAME, null);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%s \u53c2\u6570\u5df2\u5b58\u5728", (String)"OpenApiFormPlugin_81", (String)"bos-open-formplugin", (Object[])new Object[0]), newVal));
        }
    }

    public static void beforeDeleteHeader(EntryGrid headerEntry, IDataModel model, BeforeDoOperationEventArgs args, IFormView formView) {
        if (headerEntry.getSelectRows().length > 0) {
            for (int index : headerEntry.getSelectRows()) {
                String headername = model.getValue(HEADERNAME, index).toString();
                if (index >= 3 || !ApiPluginUtil.isPreHeader(headername)) continue;
                args.setCancel(true);
                formView.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u9879\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"OpenApiFormPlugin_79", (String)"bos-open-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public static void createTest3rdApp(BeforeItemClickEvent evt, AbstractBasePlugIn plugin) {
        OpenApiTestUtil util = new OpenApiTestUtil();
        if ("no3rdApp".equals(util.checkIsHasApitest3rdApp())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("apitest", (IFormPlugin)plugin);
            plugin.getView().showConfirm(ResManager.loadKDString((String)"API\u6d4b\u8bd5\u8bf7\u6c42\u521b\u5efa\u7b2c\u4e09\u65b9\u5e94\u7528\uff08openapi_unittest\uff09", (String)"OpenApiFormPlugin_89", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            evt.setCancel(true);
        } else if ("hasSelf3rdApp".equals(util.checkIsHasApitest3rdApp())) {
            plugin.getView().showMessage(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\uff08openapi_unittest\uff09\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u7b2c\u4e09\u65b9\u5e94\u7528\u7f16\u7801", (String)"OpenApiFormPlugin_90", (String)"bos-open-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public static void callbackUrl(AbstractFormPlugin form) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("apiid", form.getView().getModel().getValue(ID));
        FormOpener.showForm(form, "openapi_callback_list", ResManager.loadKDString((String)"\u56de\u8c03\u5730\u5740\u5217\u8868", (String)"OpenApiFormPlugin_80", (String)"bos-open-formplugin", (Object[])new Object[0]), param, null);
    }

    @Deprecated
    public static Boolean isAllowEdit(IDataModel dataModel, IFormView formView) {
        return true;
    }

    public static Boolean confirmBeforeSave(IFormView formView, BeforeItemClickEvent evt) {
        if ("true".equals(formView.getPageCache().get("isNew"))) {
            return true;
        }
        String status = formView.getModel().getValue("status").toString();
        if ("B".equals(status) || "C".equals(status)) {
            formView.showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u63a5\u53e3\u4fe1\u606f\u53ef\u80fd\u4f1a\u5f71\u54cd\u5df2\u53d1\u5e03\u6216\u7ef4\u62a4\u4e2d\u7684\u63a5\u53e3\u8c03\u7528\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u4fee\u6539\uff1f", (String)"ApiPluginUtil_8", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("update_api"));
            evt.setCancel(true);
            return false;
        }
        return true;
    }

    public static String getVisibleSysApi(IFormView formView) {
        String isVisibleSysApi = formView.getPageCache().get("isVisibleSysApi");
        if (isVisibleSysApi == null) {
            isVisibleSysApi = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("is_view_sysapi", "false");
            formView.getPageCache().put("isVisibleSysApi", isVisibleSysApi);
        }
        return isVisibleSysApi;
    }

    public static void checkIsKingdee(IDataModel model) {
        String apiIsvId;
        String isvId = ISVServiceHelper.getISVInfo().getId();
        String string = apiIsvId = model.getValue("isvid") == null ? "" : (String)model.getValue("isvid");
        if (ISV_KINGDEE.equals(apiIsvId) && !ISV_KINGDEE.equals(isvId)) {
            throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u63a5\u53e3\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u8bf7\u901a\u8fc7\u5217\u8868\u4e2d\u7684\u590d\u5236\u6309\u94ae\uff0c\u65b0\u589e\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"ApiPluginUtil_9", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    public static Boolean isSaveIgnoreIsvId(String propName) {
        if (saveIgnoreStatusSet.contains(propName)) {
            return true;
        }
        return false;
    }

    public static boolean validateNumberAndUrlFormat(BeforeDoOperationEventArgs evt, AbstractFormPlugin plugin) {
        String number = (String)plugin.getView().getModel().getValue(KEY_NUMBER);
        String urlFormat = (String)plugin.getView().getModel().getValue(KEY_URLFORMAT);
        if (ApiPluginUtil.isChinese(number)) {
            if (evt != null) {
                evt.setCancel(true);
            }
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"API\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"OpenApiFormPlugin_53", (String)"bos-open-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (ApiPluginUtil.isChinese(urlFormat)) {
            if (evt != null) {
                evt.setCancel(true);
            }
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"OpenApiFormPlugin_54", (String)"bos-open-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (number != null && number.contains(" ")) {
            if (evt != null) {
                evt.setCancel(true);
            }
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"OpenApiFormPlugin_82", (String)"bos-open-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean isChinese(String str) {
        if (str == null) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (!ApiPluginUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static String getCosmicVer() {
        IndustryVersionInfo csVersion = IndustryVersionServiceHelper.getVersion((String)"cosmic_bos", (String)ISV_KINGDEE);
        return ApiPluginUtil.removeLastVersion(csVersion.getVersion());
    }

    public static void matchCosmicVer(String ver, IFormView formView) {
        if (StringUtil.isEmpty((String)ver)) {
            return;
        }
        if (!ver.matches(COSMIC_MATCH)) {
            throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u9002\u7528\u7248\u672c\u53f7\u683c\u5f0f\u9519\u8bef, \u6b63\u786e\u683c\u5f0f\u53c2\u8003: 5.0.002\u3002", (String)"OpenApiFormPlugin_83", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    private static String removeLastVersion(String version) {
        String[] split;
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }

    public static void checkCycleRef(BeforeDoOperationEventArgs event, IDataModel dataModel, IFormView view) {
        DynamicObjectCollection resources = dataModel.getEntryEntity("resourceentity");
        if (CollectionUtil.isEmpty((Collection)resources)) {
            return;
        }
        long id = DataUtil.l((Object)dataModel.getValue(ID));
        String number = DataUtil.s((Object)dataModel.getValue(KEY_NUMBER));
        String name = DataUtil.s((Object)dataModel.getValue("name"));
        ApiResource from = new ApiResource(id, number, name);
        DirectedGraph.GraphBuilder graphBuilder = DirectedGraph.builder((boolean)true);
        for (DynamicObject resource : resources) {
            DynamicObject ref = resource.getDynamicObject("res_ref");
            if (ref == null) continue;
            DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)ref.getPkValue(), (String)EntityDts.openapi_scriptapi.name());
            ApiResource to = new ApiResource(res);
            graphBuilder.putEdge((Object)from, (Object)to);
            ApiPluginUtil.putEdge((DirectedGraph.GraphBuilder<ApiResource>)graphBuilder, to, res);
        }
        DirectedGraph graph = graphBuilder.build();
        Map cycles = graph.getCycles();
        if (CollectionUtil.isEmpty((Map)cycles)) {
            return;
        }
        event.setCancel(true);
        Optional optional = cycles.entrySet().stream().findFirst();
        if (optional.isPresent()) {
            String title = ResManager.loadKDString((String)"\u8d44\u6e90\u5b58\u5728\u5faa\u73af\u5f15\u7528", (String)"ApiPluginUtil_0", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]);
            FormOpener.showErrorMessage(view, title, "\u3010" + ((List)((Map.Entry)optional.get()).getKey()).stream().map(Triple::getB).collect(Collectors.joining(" -> ")) + "\u3011 => " + ((Map.Entry)optional.get()).getValue());
        }
    }

    private static void putEdge(DirectedGraph.GraphBuilder<ApiResource> graphBuilder, ApiResource from, DynamicObject fromObj) {
        if (!fromObj.containsProperty("resourceentity")) {
            return;
        }
        DynamicObjectCollection resources = fromObj.getDynamicObjectCollection("resourceentity");
        if (CollectionUtil.isEmpty((Collection)resources)) {
            return;
        }
        for (DynamicObject resource : resources) {
            DynamicObject ref = resource.getDynamicObject("res_ref");
            if (ref == null) continue;
            DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)ref.getPkValue(), (String)EntityDts.openapi_scriptapi.name());
            ApiResource to = new ApiResource(res);
            graphBuilder.putEdge((Object)from, (Object)to);
            ApiPluginUtil.putEdge(graphBuilder, to, res);
        }
    }

    public static void checkPlugin(String appid, String operation, String pluginInfoStr, BeforeDoOperationEventArgs args, IFormView view, IDataModel model) {
        List plugins = PluginUtil.getPlugins((String)pluginInfoStr);
        List enablePlugins = plugins.stream().filter(Plugin::isEnabled).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(enablePlugins)) {
            String tips;
            ArrayList<String> serializerClassList = new ArrayList<String>();
            ArrayList<String> deserializerClassList = new ArrayList<String>();
            ArrayList<PluginInfo> pluginInfoList = new ArrayList<PluginInfo>();
            for (Plugin plugin : enablePlugins) {
                Map pluginResult;
                String className = plugin.getClassName();
                try {
                    pluginResult = CustomApiUtil.getApiPluginResult((String)appid, (String)operation, (String)className, (Integer)plugin.getType());
                }
                catch (Throwable e) {
                    log.info("\u83b7\u53d6\u63d2\u4ef6\u5931\u8d25:", (Object)e);
                    view.showTipNotification(e.getMessage());
                    args.setCancel(true);
                    return;
                }
                HashSet<PluginType> plugintypeSet = new HashSet<PluginType>();
                if (pluginResult != null) {
                    if (StringUtil.isNotEmpty((String)operation)) {
                        ApiOperationType curOpt = ApiOperationType.getTypeByOp((String)operation);
                        Class pluginClass = curOpt.getPluginClass();
                        if (!(((Boolean)pluginResult.get(pluginClass)).booleanValue() || ((Boolean)pluginResult.get(ApiSerializerPlugin.class)).booleanValue() || ((Boolean)pluginResult.get(ApiDeserializerPlugin.class)).booleanValue())) {
                            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6269\u5c55\u63d2\u4ef6\u4e2d\u63d2\u4ef6\u201c%1$s\u201d\u6ca1\u6709\u5b9e\u73b0\u201c%2$s\u201d\u6216\u201cApiSerializerPlugin\u201d\u6216\u201cApiDeserializerPlugin\u201d\u63a5\u53e3\u3002", (String)"ApiPluginUtil_4", (String)"bos-open-formplugin", (Object[])new Object[0]), className, pluginClass.getSimpleName()));
                            args.setCancel(true);
                            return;
                        }
                        if (((Boolean)pluginResult.get(pluginClass)).booleanValue()) {
                            plugintypeSet.add(PluginType.ApiPlugin);
                        }
                    } else if (!((Boolean)pluginResult.get(ApiSerializerPlugin.class)).booleanValue() && !((Boolean)pluginResult.get(ApiDeserializerPlugin.class)).booleanValue()) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6269\u5c55\u63d2\u4ef6\u4e2d\u63d2\u4ef6\u201c%1$s\u201d\u6ca1\u6709\u5b9e\u73b0\u201cApiSerializerPlugin\u201d\u6216\u201cApiDeserializerPlugin\u201d\u63a5\u53e3\u3002", (String)"ApiPluginUtil_5", (String)"bos-open-formplugin", (Object[])new Object[0]), className));
                        args.setCancel(true);
                        return;
                    }
                    if (((Boolean)pluginResult.get(ApiSerializerPlugin.class)).booleanValue()) {
                        serializerClassList.add(className);
                        plugintypeSet.add(PluginType.ApiSerializerPlugin);
                    }
                    if (((Boolean)pluginResult.get(ApiDeserializerPlugin.class)).booleanValue()) {
                        deserializerClassList.add(className);
                        plugintypeSet.add(PluginType.ApiDeserializerPlugin);
                    }
                }
                pluginInfoList.add(new PluginInfo(className, plugintypeSet, Integer.valueOf(plugin.getType())));
            }
            if (serializerClassList.size() > 1) {
                tips = ApiPluginUtil.splicePluginName(serializerClassList);
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6269\u5c55\u63d2\u4ef6\u4e2d\u5b58\u5728\u591a\u4e2a\u63d2\u4ef6\u5b9e\u73b0\u4e86\u5e8f\u5217\u5316\u201cApiSerializerPlugin\u201d\u63a5\u53e3\uff0c\u5982\u4e0b\uff1a%1$s \u3002", (String)"ApiPluginUtil_6", (String)"bos-open-formplugin", (Object[])new Object[0]), tips));
                args.setCancel(true);
                return;
            }
            if (deserializerClassList.size() > 1) {
                tips = ApiPluginUtil.splicePluginName(deserializerClassList);
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6269\u5c55\u63d2\u4ef6\u4e2d\u5b58\u5728\u591a\u4e2a\u63d2\u4ef6\u5b9e\u73b0\u4e86\u53cd\u5e8f\u5217\u5316\u201cApiDeserializerPlugin\u201d\u63a5\u53e3\uff0c\u5982\u4e0b\uff1a%1$s \u3002", (String)"ApiPluginUtil_7", (String)"bos-open-formplugin", (Object[])new Object[0]), tips));
                args.setCancel(true);
                return;
            }
            model.setValue("hiddenplugin", (Object)JsonUtil.toJsonString(pluginInfoList, (SerializerFeature[])new SerializerFeature[0]));
        } else {
            model.setValue("hiddenplugin", (Object)"");
        }
    }

    private static String splicePluginName(List<String> list) {
        StringBuilder tips = new StringBuilder();
        for (String str : list) {
            tips.append("\u201c").append(str).append("\u201c").append(" ");
        }
        return tips.toString();
    }

    public static void visitButtonControl(IDataModel model, IFormView view) {
        Boolean isOnlyThirdAppAuth = (Boolean)model.getValue("isonlythirdappauth");
        if (isOnlyThirdAppAuth.booleanValue()) {
            model.setValue(KEY_ALLOWGUEST, (Object)Boolean.FALSE);
        }
    }

    public static void allowguestControl(IDataModel model, IFormView view) {
        boolean allowguest = (Boolean)model.getValue(KEY_ALLOWGUEST);
        Boolean isOnlyThirdAppAuth = (Boolean)model.getValue("isonlythirdappauth");
        if (isOnlyThirdAppAuth.booleanValue() && allowguest) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5173\u95ed\u7b2c\u4e09\u65b9\u5e94\u7528\u6388\u6743\u5f00\u5173\u3002", (String)"OpenApiCustomApiFormPlugin_36", (String)"bos-open-formplugin", (Object[])new Object[0]));
            model.setValue(KEY_ALLOWGUEST, (Object)Boolean.FALSE);
            return;
        }
        if (allowguest) {
            view.showTipNotification(ResManager.loadKDString((String)"\u542f\u7528\u533f\u540d\u540e\u8be5API\u65e0\u9700\u767b\u5f55\u8ba4\u8bc1\u5373\u53ef\u8bbf\u95ee\uff0c\u60a8\u9700\u81ea\u884c\u627f\u62c5\u8be5API\u56e0\u533f\u540d\u8bbf\u95ee\u5bfc\u81f4\u7684\u6570\u636e\u6cc4\u9732\u98ce\u9669\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\uff01", (String)"OpenApiCustomApiFormPlugin_31", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    public static DynamicObjectCollection buildQueryEntryData(String op, DynamicObjectCollection queryResp) {
        DynamicObjectCollection cloneQueryResp = (DynamicObjectCollection)queryResp.clone();
        queryResp.clear();
        ApiServiceResult data = ApiService.getTypeByOp((String)op.toUpperCase()).getResultType();
        Map data1 = (Map)JsonUtil.toJSON((Object)OpenApiResult.builder().success((Object)data));
        for (Map.Entry entryMap : data1.entrySet()) {
            DynamicObject row = new DynamicObject(queryResp.getDynamicObjectType());
            if (((String)entryMap.getKey()).equals("data")) {
                row.set("Id", (Object)1L);
                row.set("pid", (Object)0L);
                row.set("respparamname", entryMap.getKey());
                row.set("respparamtype", (Object)"Array");
                row.set("respdes", (Object)ResManager.loadKDString((String)"\u7ed3\u679c\u6570\u636e", (String)"OpenApiFormPlugin_63", (String)"bos-open-formplugin", (Object[])new Object[0]));
                row.set("resp_level", (Object)"1");
                row.set("respexample", (Object)"{}");
                row.set("respobjpropname", entryMap.getKey());
                queryResp.add((Object)row);
                Map dataChild = (Map)entryMap.getValue();
                for (Map.Entry entryMap1 : dataChild.entrySet()) {
                    DynamicObject child = new DynamicObject(queryResp.getDynamicObjectType());
                    child.set("pid", row.get("Id"));
                    child.set("respparamname", entryMap1.getKey());
                    if (((String)entryMap1.getKey()).equals("filter")) {
                        child.set("Id", (Object)9L);
                        child.set("respparamtype", (Object)"String");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"OpenApiFormPlugin_66", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)ResManager.loadKDString((String)"\"\u64cd\u4f5c\u6267\u884c\u7684\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5982\uff1abillno in ('CGSQ-220228-000258','CGSQ-220228-000259')\"", (String)"ApiPluginUtil_10", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    } else if (((String)entryMap1.getKey()).equals("totalCount")) {
                        child.set("Id", (Object)10L);
                        child.set("respparamtype", (Object)"String");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u603b\u6570", (String)"OpenApiFormPlugin_69", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)"\"-1\"");
                    } else if (((String)entryMap1.getKey()).equals("lastPage")) {
                        child.set("Id", (Object)11L);
                        child.set("respparamtype", (Object)"Boolean");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u662f\u5426\u6700\u540e\u4e00\u9875", (String)"OpenApiFormPlugin_69", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)"\"true/false\"");
                    } else if (((String)entryMap1.getKey()).equals("pageNo")) {
                        child.set("Id", (Object)12L);
                        child.set("respparamtype", (Object)"Integer");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\uff0c\u67e5\u8be2\u9875\u7801", (String)"OpenApiFormPlugin_69", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)new LocaleString("1"));
                    } else if (((String)entryMap1.getKey()).equals("pageSize")) {
                        child.set("Id", (Object)13L);
                        child.set("respparamtype", (Object)"Integer");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\uff0c\u5206\u9875\u6570\u91cf", (String)"OpenApiFormPlugin_69", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)new LocaleString("10"));
                    } else if (((String)entryMap1.getKey()).equals("rows")) {
                        child.set("Id", (Object)14L);
                        child.set("respparamtype", (Object)"Array");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u7ed3\u679c\u6570\u636e\u5217\u8868", (String)"OpenApiFormPlugin_69", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)"[]");
                        for (DynamicObject queryRe : cloneQueryResp) {
                            DynamicObject respChild = new DynamicObject(queryResp.getDynamicObjectType());
                            respChild.set("pid", !"0".equals(queryRe.getString("pid")) ? queryRe.get("pid") : child.get("Id"));
                            respChild.set("Id", queryRe.get("Id"));
                            respChild.set("respparamname", (Object)queryRe.getString("respparamname"));
                            respChild.set("respparamtype", (Object)queryRe.getString("respparamtype"));
                            respChild.set("respdes", (Object)queryRe.getString("respdes"));
                            respChild.set("respexample", (Object)queryRe.getString("respexample"));
                            respChild.set("respobjpropname", (Object)("data.rows." + queryRe.getString("respobjpropname")));
                            respChild.set("resp_level", (Object)(Integer.parseInt(queryRe.getString("resp_level")) + 2));
                            queryResp.add((Object)respChild);
                        }
                    }
                    child.set("respobjpropname", (Object)("data." + child.getString("respparamname")));
                    child.set("resp_level", (Object)"2");
                    queryResp.add((Object)child);
                }
                continue;
            }
            row.set("respparamname", entryMap.getKey());
            if (((String)entryMap.getKey()).equals("errorCode")) {
                row.set("Id", (Object)2L);
                row.set("pid", (Object)0L);
                row.set("respparamtype", (Object)"String");
                row.set("respdes", (Object)ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"OpenApiFormPlugin_70", (String)"bos-open-formplugin", (Object[])new Object[0]));
                row.set("resp_level", (Object)"1");
                row.set("respexample", (Object)ResManager.loadKDString((String)"\"\u6210\u529f\u65f6\u4e3a0\uff0c\u5931\u8d25\u65f6\u4f1a\u8fd4\u56de\u9519\u8bef\u7801\u5982400\"", (String)"ApiPluginUtil_11", (String)"bos-open-formplugin", (Object[])new Object[0]));
            } else if (((String)entryMap.getKey()).equals("message")) {
                row.set("Id", (Object)3L);
                row.set("pid", (Object)0L);
                row.set("respparamtype", (Object)"String");
                row.set("respdes", (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u9519\u8bef\u4fe1\u606f", (String)"OpenApiFormPlugin_72", (String)"bos-open-formplugin", (Object[])new Object[0]));
                row.set("resp_level", (Object)"1");
                row.set("respexample", (Object)ResManager.loadKDString((String)"\"\u6210\u529f\u65f6\u4e3a\u7a7a\uff0c\u5931\u8d25\u65f6\u4f1a\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u5982\u201c\u64cd\u4f5c\u5931\u8d25\u201d\"", (String)"ApiPluginUtil_12", (String)"bos-open-formplugin", (Object[])new Object[0]));
            } else if (((String)entryMap.getKey()).equals("status")) {
                row.set("Id", (Object)4L);
                row.set("pid", (Object)0L);
                row.set("respparamtype", (Object)"Boolean");
                row.set("respdes", (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u8bbf\u95ee\u662f\u5426\u6210\u529f", (String)"OpenApiFormPlugin_74", (String)"bos-open-formplugin", (Object[])new Object[0]));
                row.set("resp_level", (Object)"1");
                row.set("respexample", (Object)"\"true/false\"");
            }
            row.set("respobjpropname", (Object)row.getString("respparamname"));
            queryResp.add((Object)row);
        }
        return queryResp;
    }

    public static void digestLogFormShow(String entityKey, IDataModel model, IFormView view, String callbackClassName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("digestlogtemplate");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(callbackClassName, entityKey));
        formShowParameter.setCustomParam("scriptText", (Object)model.getValue(entityKey).toString());
        formShowParameter.setCustomParam("apiservicetype", (Object)model.getValue("apiservicetype").toString());
        view.showForm(formShowParameter);
    }

    public static void checkGroupIsNull(IDataModel model, IFormView view, BeforeDoOperationEventArgs args) {
        Object group = model.getValue("group");
        if (group == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApiPluginUtil_13", (String)"bos-open-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public static void setFullUrlformat(IDataModel model) {
        Object value = model.getValue(KEY_URLFORMAT);
        if (value != null) {
            String urlformat = value.toString();
            String urlCosmic = UrlService.getDomainContextUrl();
            StringBuilder builder = new StringBuilder();
            StringBuilder sb = builder.append(urlCosmic).append("/kapi").append(urlformat);
            model.setValue(FULLURLFORMAT, (Object)sb.toString());
        }
    }

    public static void updateAsyncUrlFlag(String isasync, IDataModel model) {
        if ("true".equals(isasync)) {
            model.setValue("isasync", (Object)AsyncTypeEnum.ASYNC.getValue());
            String url = (String)model.getValue(KEY_URLFORMAT);
            if (StringUtil.isNotEmpty((String)url)) {
                String newUrl = url.substring(0, 3) + "/async" + url.substring(3);
                model.setValue(KEY_URLFORMAT, (Object)newUrl);
            }
        }
    }

    static {
        saveIgnoreStatusSet.add("isdyobjresult");
        saveIgnoreStatusSet.add("isonlythirdappauth");
        saveIgnoreStatusSet.add("isoutparawithoutstatus");
        saveIgnoreStatusSet.add("org_author_filter");
        saveIgnoreStatusSet.add("maxsaveentrysize");
        saveIgnoreStatusSet.add(KEY_ALLOWGUEST);
        saveIgnoreStatusSet.add("check_repeat_req");
        saveIgnoreStatusSet.add("ismulilang");
        saveIgnoreStatusSet.add("isserializedefaultvalue");
        saveIgnoreStatusSet.add("privacy_transdatatag");
        saveIgnoreStatusSet.add(FULLURLFORMAT);
        saveIgnoreStatusSet.add("isdesensitize");
        saveIgnoreStatusSet.add("indigesttemplate");
        saveIgnoreStatusSet.add("outdigesttemplate");
        List<String> openapi_apilist_keys = Arrays.asList("maxsaveentrysize", "hiddenplugin", "ismulilang", "pvurlformat", "isserializedefaultvalue");
        List<String> openapi_customapi_keys = Arrays.asList("hiddenplugin", "pvurlformat");
        List<String> openapi_scriptapi_keys = Arrays.asList("hiddenplugin", "pvurlformat");
        saveInEntryMap.put("openapi_apilist", String.join((CharSequence)",", openapi_apilist_keys));
        saveInEntryMap.put("openapi_customapi", String.join((CharSequence)",", openapi_customapi_keys));
        saveInEntryMap.put("openapi_scriptapi", String.join((CharSequence)",", openapi_scriptapi_keys));
    }
}

