/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import kd.bos.context.RequestContext;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.security.model.CertificateInfo;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;

public class CertUtil {
    private static final String CERT_SERVICE = "CertService";
    private static final String CERT_SERVICE_CREATE = "createCert";
    private static final String CERT_SERVICE_FIND = "findCert";
    private static final String CERT_SERVICE_CHECK_CERT = "checkCertExits";

    public static String createBosOpenCert(Long thirdId) {
        if (thirdId == null) {
            return "";
        }
        CertificateInfo certificateInfo = new CertificateInfo();
        certificateInfo.setAccountId(RequestContext.get().getAccountId());
        certificateInfo.setCertType("0");
        certificateInfo.setThirdId(thirdId);
        certificateInfo.setModifierid(Long.valueOf(RequestContext.get().getCurrUserId()));
        boolean result = (Boolean)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)CERT_SERVICE, (String)CERT_SERVICE_CREATE, (Object[])new Object[]{certificateInfo});
        CertificateInfo certinfo = null;
        if (!result) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "create cert error:", new Object[0]);
        }
        certinfo = (CertificateInfo)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)CERT_SERVICE, (String)CERT_SERVICE_FIND, (Object[])new Object[]{certificateInfo});
        return certinfo != null ? certinfo.getPublicKeyBase64() : "";
    }

    public static boolean createNewBosOpenCert(Long thirdId) {
        if (thirdId == null) {
            return false;
        }
        CertificateInfo certificateInfo = new CertificateInfo();
        certificateInfo.setAccountId(RequestContext.get().getAccountId());
        certificateInfo.setCertType("0");
        certificateInfo.setThirdId(thirdId);
        certificateInfo.setModifierid(Long.valueOf(RequestContext.get().getCurrUserId()));
        certificateInfo.setCreateNew(true);
        boolean result = (Boolean)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)CERT_SERVICE, (String)CERT_SERVICE_CREATE, (Object[])new Object[]{certificateInfo});
        return result;
    }

    public static boolean createJWTCert(Long thirdId) {
        if (thirdId == null) {
            return false;
        }
        boolean result = (Boolean)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)CERT_SERVICE, (String)CERT_SERVICE_CHECK_CERT, (Object[])new Object[]{RequestContext.get().getAccountId(), "2", thirdId});
        if (!result) {
            CertificateInfo certificateInfo = new CertificateInfo();
            certificateInfo.setAccountId(RequestContext.get().getAccountId());
            certificateInfo.setCertType("2");
            certificateInfo.setThirdId(thirdId);
            certificateInfo.setModifierid(Long.valueOf(RequestContext.get().getCurrUserId()));
            result = (Boolean)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)CERT_SERVICE, (String)CERT_SERVICE_CREATE, (Object[])new Object[]{certificateInfo});
        }
        return result;
    }
}

