/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.openapi.common.util.DateUtil;

public class CustomChartHelper {
    private PointLineChart customchart;

    public PointLineChart getCustomchart() {
        return this.customchart;
    }

    public void setCustomchart(PointLineChart customchart) {
        this.customchart = customchart;
    }

    public void drawChart(PointLineChart customchart, List<DynamicObject> datas, int type) {
        customchart.clearData();
        this.setHandlechartXaxisTick(customchart, type);
        this.setHandleChartData(customchart, datas, type);
        customchart.setMargin(Position.right, "30px");
        customchart.setMargin(Position.top, "90px");
    }

    private Axis setHandlechartXaxisTick(PointLineChart customchart, int type) {
        LocalDate now = LocalDate.now();
        ArrayList<String> xDimensions = new ArrayList<String>();
        Axis xAxis = null;
        if (7 == type) {
            xAxis = customchart.createXAxis(ResManager.loadKDString((String)"\u65e5", (String)"CustomChartHelper_0", (String)"bos-open-formplugin", (Object[])new Object[0]), AxisType.category);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM.dd");
            for (int i = 29; i >= 0; --i) {
                xDimensions.add(now.minusDays(i).format(formatter) + "");
            }
        } else if (1 == type) {
            xAxis = customchart.createXAxis(ResManager.loadKDString((String)"\u65f6", (String)"CustomChartHelper_1", (String)"bos-open-formplugin", (Object[])new Object[0]), AxisType.category);
            for (int i = 23; i >= 0; --i) {
                LocalDateTime nowTime = LocalDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH");
                xDimensions.add(nowTime.minusHours(i).format(formatter) + ":00");
            }
        }
        if (xAxis != null) {
            xAxis.setCategorys(xDimensions);
            HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
            axisTick.put("interval", Integer.valueOf(0));
            axisTick.put("show", Boolean.FALSE);
            xAxis.setPropValue("axisTick", axisTick);
            this.setLineColor(xAxis, "#999999");
        }
        return xAxis;
    }

    private void setHandleChartData(PointLineChart customchart, List<DynamicObject> datas, int type) {
        Axis yAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf/\u6b21", (String)"CustomChartHelper_2", (String)"bos-open-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisTick);
        List<DynamicObject> collection = datas;
        LineSeries expireSeries = customchart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u603b\u6b21\u6570", (String)"CustomChartHelper_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
        expireSeries.setItemColor("#2386EE");
        Number[] handleData = this.getTrendChartData(collection, type);
        expireSeries.setData(handleData);
        LineSeries expireSeries1 = customchart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u5931\u8d25\u6b21\u6570", (String)"CustomChartHelper_4", (String)"bos-open-formplugin", (Object[])new Object[0]));
        Number[] handleTaskData1 = this.getDefeatedChartData(collection, type);
        expireSeries1.setItemColor("#D9001B");
        expireSeries1.setData(handleTaskData1);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(yAxis, "#999999");
        Axis y1Axis = customchart.createYAxis(ResManager.loadKDString((String)"\u5e73\u5747\u54cd\u5e94\u65f6\u95f4/ms", (String)"CustomChartHelper_5", (String)"bos-open-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisLabel = new HashMap<String, Boolean>();
        axisLabel.put("show", Boolean.TRUE);
        y1Axis.setPropValue("axisLabel", axisLabel);
        LineSeries expireSeriesend1 = customchart.createSeries(ResManager.loadKDString((String)"API\u5e73\u5747\u54cd\u5e94\u65f6\u95f4", (String)"CustomChartHelper_6", (String)"bos-open-formplugin", (Object[])new Object[0]));
        expireSeriesend1.setYAxisIndex(1);
        Number[] handleTaskDataend1 = this.getAverageChartData(collection, type);
        expireSeriesend1.setItemColor("#66CC83");
        expireSeriesend1.setData(handleTaskDataend1);
        this.setLineColor(y1Axis, "#999999");
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.setLegendVertical(false);
        int[] padding = new int[]{10, 100, 0, 0};
        customchart.setLegendPropValue("padding", (Object)padding);
        customchart.bindData((BindingContext)null);
    }

    private Double[] getTrendChartData(List<DynamicObject> collection, int type) {
        LinkedHashMap<String, Double> dataMap = new LinkedHashMap<String, Double>();
        Map<String, List<DynamicObject>> groupByTimeMap = null;
        if (collection != null) {
            groupByTimeMap = collection.stream().collect(Collectors.groupingBy(it -> it.getString("time")));
        }
        this.setXYaxis(dataMap, type);
        if (null != groupByTimeMap && groupByTimeMap.size() > 0) {
            String finalTimeForMat = this.getTimeFormatByType(type);
            groupByTimeMap.forEach((time, dynamicObjectList) -> {
                Double sum = dynamicObjectList.stream().map(data -> data.getBigDecimal("cnt")).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue();
                String timeMd = DateUtil.convertToStr((String)finalTimeForMat, (Date)new Date(Long.parseLong(time)));
                if (dataMap.containsKey(timeMd)) {
                    dataMap.put(timeMd, sum);
                }
            });
        }
        Collection datas = dataMap.values();
        Double[] doubles = datas.toArray(new Double[datas.size()]);
        return doubles;
    }

    private Double[] getDefeatedChartData(List<DynamicObject> collection, int type) {
        LinkedHashMap<String, Double> dataMap = new LinkedHashMap<String, Double>();
        Map<String, List<DynamicObject>> groupByTimeMap = null;
        if (collection != null) {
            groupByTimeMap = collection.stream().collect(Collectors.groupingBy(it -> it.getString("time")));
        }
        this.setXYaxis(dataMap, type);
        if (null != groupByTimeMap && groupByTimeMap.size() > 0) {
            String finalTimeForMat = this.getTimeFormatByType(type);
            groupByTimeMap.forEach((time, dynamicObjectList) -> {
                Double sum = dynamicObjectList.stream().map(data -> data.getBigDecimal("cnt")).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue();
                Double successSum = dynamicObjectList.stream().map(data -> data.getBigDecimal("successcnt")).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue();
                String timeMd = DateUtil.convertToStr((String)finalTimeForMat, (Date)new Date(Long.parseLong(time)));
                if (dataMap.containsKey(timeMd)) {
                    dataMap.put(timeMd, sum - successSum);
                }
            });
        }
        Collection datas = dataMap.values();
        Double[] doubles = datas.toArray(new Double[datas.size()]);
        return doubles;
    }

    private Double[] getAverageChartData(List<DynamicObject> collection, int type) {
        LinkedHashMap<String, Double> dataMap = new LinkedHashMap<String, Double>();
        Map<String, List<DynamicObject>> groupByTimeMap = null;
        if (collection != null) {
            groupByTimeMap = collection.stream().collect(Collectors.groupingBy(it -> it.getString("time")));
        }
        this.setXYaxis(dataMap, type);
        if (null != groupByTimeMap && groupByTimeMap.size() > 0) {
            String finalTimeForMat = this.getTimeFormatByType(type);
            groupByTimeMap.forEach((time, dynamicObjectList) -> {
                Double sum = dynamicObjectList.stream().map(data -> data.getBigDecimal("cnt")).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue();
                Double cost = dynamicObjectList.stream().map(data -> data.getBigDecimal("cost")).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue();
                String timeMd = DateUtil.convertToStr((String)finalTimeForMat, (Date)new Date(Long.parseLong(time)));
                if (dataMap.containsKey(timeMd)) {
                    Double result = cost / sum;
                    dataMap.put(timeMd, (double)Math.round(result * 100.0) / 100.0);
                }
            });
        }
        Collection datas = dataMap.values();
        Double[] doubles = datas.toArray(new Double[datas.size()]);
        return doubles;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private void setXYaxis(Map<String, Double> dataMap, int type) {
        String timeForMat = null;
        LinkedList<String> list = new LinkedList<String>();
        LocalDate now = LocalDate.now();
        if (7 == type) {
            timeForMat = "MM.dd";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timeForMat);
            for (int i = 29; i >= 0; --i) {
                list.add(now.minusDays(i).format(formatter) + "");
            }
            for (String day : list) {
                dataMap.put(day, 0.0);
            }
        } else if (1 == type) {
            LocalDateTime nowTime = LocalDateTime.now();
            timeForMat = "HH";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timeForMat);
            for (int i = 23; i >= 0; --i) {
                list.add(nowTime.minusHours(i).format(formatter));
            }
            list.forEach(hour -> dataMap.put((String)hour, 0.0));
        }
    }

    private String getTimeFormatByType(int type) {
        String timeForMat = null;
        if (7 == type) {
            timeForMat = "MM.dd";
        } else if (1 == type) {
            timeForMat = "HH";
        }
        return timeForMat;
    }
}

