/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.form.util.enums.ParamTypeEnum;

public class OpenApiDocToMapUtils {
    public static List<Map<String, Object>> getListData(DynamicObjectCollection collection, String typeKey, String nameKey, String valueKey) {
        Iterator iterator = collection.iterator();
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (0L != dynamicObject.getLong("pid")) continue;
            tops.add(dynamicObject);
            iterator.remove();
        }
        List<Map<String, Object>> resultMap = OpenApiDocToMapUtils.packageListFormat(collection, tops, typeKey, nameKey, valueKey);
        return resultMap;
    }

    private static List<Map<String, Object>> packageListFormat(DynamicObjectCollection dynamicObjects, List<DynamicObject> tops, String typeKey, String nameKey, String valueKey) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (nameKey == null && valueKey == null) {
            boolean isBodyColl = "customBody".equals(typeKey);
            for (DynamicObject top : tops) {
                Map<String, Object> map = isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(top) : OpenApiDocToMapUtils.buildResponseToMap(top);
                List<Object> child = OpenApiDocToMapUtils.getCustomApiChildData(dynamicObjects, top, typeKey);
                if (child.size() > 0) {
                    map.put("items", OpenApiDocToMapUtils.getCustomApiChildData(dynamicObjects, top, typeKey));
                }
                resultList.add(map);
            }
        } else {
            boolean isBodyColl = "paramtype".equals(typeKey);
            for (DynamicObject top : tops) {
                String type = top.getString(typeKey);
                ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
                if (typeEnum != ParamTypeEnum.ENTRIES && typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                    resultList.add(isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(top) : OpenApiDocToMapUtils.buildResponseToMap(top));
                    continue;
                }
                if (typeEnum == ParamTypeEnum.ARRAY || typeEnum == ParamTypeEnum.ENTRIES) {
                    Map<String, Object> map = isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(top) : OpenApiDocToMapUtils.buildResponseToMap(top);
                    map.put("items", OpenApiDocToMapUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, top));
                    resultList.add(map);
                    continue;
                }
                resultList.add(isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(top) : OpenApiDocToMapUtils.buildResponseToMap(top));
            }
        }
        return resultList;
    }

    private static List<Object> getCustomApiChildData(DynamicObjectCollection dynamicObjects, DynamicObject parent, String typeKey) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        boolean isBodyColl = "customBody".equals(typeKey);
        for (DynamicObject dy : dynamicObjects) {
            String pid = dy.getString("pid");
            if (!pid.equals(parent.getPkValue().toString())) continue;
            Map<String, Object> map = isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(dy) : OpenApiDocToMapUtils.buildResponseToMap(dy);
            List<Object> child = OpenApiDocToMapUtils.getCustomApiChildData(dynamicObjects, dy, typeKey);
            if (child.size() > 0) {
                map.put("items", OpenApiDocToMapUtils.getCustomApiChildData(dynamicObjects, dy, typeKey));
            }
            list.add(map);
        }
        return list;
    }

    private static List<Object> getArrayFormatData(DynamicObjectCollection dynamicObjects, String typeKey, String nameKey, String valueKey, DynamicObject parent) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        boolean isBodyColl = "paramtype".equals(typeKey);
        int filedCount = 0;
        int subFiledCount = 0;
        for (DynamicObject response : dynamicObjects) {
            String type = response.getString(typeKey);
            ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
            if (!parent.getPkValue().toString().equals(response.getString("pid"))) continue;
            ++subFiledCount;
            if (!parent.getPkValue().toString().equals(response.getString("pid"))) continue;
            ++filedCount;
            if (typeEnum != ParamTypeEnum.ENTRIES && typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                list.add(isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(response) : OpenApiDocToMapUtils.buildResponseToMap(response));
                continue;
            }
            if (typeEnum == ParamTypeEnum.OBJECT) {
                list.add(isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(response) : OpenApiDocToMapUtils.buildResponseToMap(response));
                continue;
            }
            if (typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.ENTRIES) continue;
            Map<String, Object> map = isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(response) : OpenApiDocToMapUtils.buildResponseToMap(response);
            map.put("items", OpenApiDocToMapUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
            list.add(map);
        }
        if (filedCount == subFiledCount) {
            return list;
        }
        list.clear();
        list.add(OpenApiDocToMapUtils.packageJsonFormat(dynamicObjects, parent, typeKey, nameKey, valueKey));
        return list;
    }

    private static List<Map<String, Object>> packageJsonFormat(DynamicObjectCollection dynamicObjects, DynamicObject object, String typeKey, String nameKey, String valueKey) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        boolean isBodyColl = "paramtype".equals(typeKey);
        for (DynamicObject response : dynamicObjects) {
            String type = response.getString(typeKey);
            ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
            if (!object.getPkValue().toString().equals(response.getString("pid"))) continue;
            if (typeEnum != ParamTypeEnum.ENTRIES && typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                result.add(isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(response) : OpenApiDocToMapUtils.buildResponseToMap(response));
                continue;
            }
            if (typeEnum == ParamTypeEnum.OBJECT) {
                Map<String, Object> data = isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(response) : OpenApiDocToMapUtils.buildResponseToMap(response);
                data.put("items", OpenApiDocToMapUtils.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                result.add(data);
                continue;
            }
            result.add(isBodyColl ? OpenApiDocToMapUtils.buildBodyToMap(response) : OpenApiDocToMapUtils.buildResponseToMap(response));
        }
        return result;
    }

    public static Map<String, Object> buildResponseToMap(DynamicObject top) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
        map.put("Id", top.getString("Id"));
        map.put("respparamname", top.getString("respparamname"));
        map.put("respobjpropname", top.getString("respobjpropname"));
        map.put("respparamtype", top.getString("respparamtype"));
        map.put("respdes", top.getString("respdes"));
        map.put("resp_level", top.getString("resp_level"));
        map.put("is_resp_custom", top.getBoolean("is_resp_custom") ? "Y" : "");
        map.put("respexample", null == top.getString("respexample") ? "" : JSON.parse((String)JSON.toJSONString((Object)top.getString("respexample"))));
        map.put("is_mul_value", top.getBoolean("is_resp_mul_value") ? "Y" : "");
        return map;
    }

    public static Map<String, Object> buildBodyToMap(DynamicObject dy) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Id", dy.getString("Id"));
        map.put("paramname", dy.getString("paramname"));
        map.put("objpropname", dy.getString("objpropname"));
        map.put("paramtype", dy.getString("paramtype"));
        map.put("must", dy.getString("must").equals("1") ? "Y" : "");
        map.put("bodyparamdes", dy.getString("bodyparamdes"));
        map.put("is_unique_key", dy.getBoolean("is_unique_key") ? "Y" : "");
        map.put("body_level", dy.getString("body_level"));
        map.put("is_body_custom", dy.getBoolean("is_body_custom") ? "Y" : "");
        map.put("example", null == dy.getString("example") ? "" : JSON.parse((String)JSON.toJSONString((Object)dy.getString("example"))).toString());
        map.put("is_mul_value", dy.getBoolean("is_req_mul_value") ? "Y" : "");
        return map;
    }
}

