/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.login.utils.LoginUtils;
import kd.bos.openapi.base.util.CommonConfigUtil;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.common.constant.ConfigConstant;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.openapi.thirdapp.ThirdAppDto;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiTestUtil {
    private static Logger logger = LoggerFactory.getLogger(OpenApiTestUtil.class);
    private static final String FORM_OPENAPI_3RDAPPS = "third_app";
    private static final String NUM_OPENAPI_UNITTEST = "openapi_unittest";
    private static final String KEY_NUMBER = "number";
    public static final String ACCESS_TOKEN = "access_token";
    private static final String THIRD_APP_SERVICE = "ThirdAppService";
    private final String ACCESS_TOKEN_CACHE_TYPE = "bos_open_accesstoken";
    private final String ACCESS_TOKEN_CACHE_KEY = "openapi_unittest_access_token_";
    private final String X_ACGW_IDENTITY = "x-acgw-identity";
    private static int default_connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 30000);
    private static int default_readTimeout = Integer.getInteger("httpclient.readTimeout", 60000);

    @Deprecated
    public String checkHasApitest3rdApp() {
        return null;
    }

    public String checkIsHasApitest3rdApp() {
        DynamicObject thirdApp = QueryServiceHelper.queryOne((String)FORM_OPENAPI_3RDAPPS, (String)"id,number,syspwd,allowallapi", (QFilter[])new QFilter(KEY_NUMBER, "=", (Object)NUM_OPENAPI_UNITTEST).toArray());
        String token = this.getUnitTestToken();
        String result = "no3rdApp";
        if (thirdApp != null) {
            String accessToken = thirdApp.getString("syspwd");
            if (StringUtil.isNotEmpty((String)accessToken) && this.isMatchPd(thirdApp, token, accessToken) && thirdApp.getBoolean("allowallapi")) {
                result = "has3rdApp";
            } else {
                result = "has3rdApp";
                String newPwd = EncryptUtil.generatePwCode();
                ThirdAppDto thirdAppDto = new ThirdAppDto();
                thirdAppDto.setNumber(NUM_OPENAPI_UNITTEST);
                thirdAppDto.setAccessToken(newPwd);
                thirdAppDto.setAllowallapi(true);
                thirdAppDto.setEnable(true);
                thirdAppDto.setAllowip(true);
                thirdAppDto.setModifier(Long.valueOf(RequestContext.get().getCurrUserId()));
                DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)THIRD_APP_SERVICE, (String)"updateThirdApp", (Object[])new Object[]{thirdAppDto});
                this.setUnitTestToken(newPwd);
            }
        }
        return result;
    }

    private boolean isMatchPd(DynamicObject thirdApp, String accessTokenNewToken, String oldToken) {
        String fid = thirdApp.getLong("id") + "";
        return PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt((String)fid), (String)accessTokenNewToken, (String)oldToken);
    }

    public void createUnittestApp() {
        String pwd = EncryptUtil.generatePwCode();
        ThirdAppDto thirdAppDto = new ThirdAppDto();
        thirdAppDto.setNumber(NUM_OPENAPI_UNITTEST);
        List list = (List)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)THIRD_APP_SERVICE, (String)"findThirdApp", (Object[])new Object[]{thirdAppDto});
        if (CollectionUtil.isEmpty((Collection)list)) {
            thirdAppDto.setName(NUM_OPENAPI_UNITTEST);
            thirdAppDto.setAccessToken(pwd);
            thirdAppDto.setModifier(Long.valueOf(RequestContext.get().getCurrUserId()));
            thirdAppDto.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
            thirdAppDto.setAllowallapi(true);
            thirdAppDto.setSignAuthEnable(false);
            thirdAppDto.setStatus("A");
            thirdAppDto.setBasicAuthEnable(false);
            thirdAppDto.setJwtAuthEnable(false);
            thirdAppDto.setDigestAuthEnable(false);
            thirdAppDto.setEncryptAllApi(false);
            thirdAppDto.setEnable(true);
            thirdAppDto.setAllowip(true);
            DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)THIRD_APP_SERVICE, (String)"createThirdApp", (Object[])new Object[]{thirdAppDto});
        }
        this.setUnitTestToken(pwd);
    }

    public Map<String, Object> getAccessTokenByAppId() throws Exception {
        JSONObject resData;
        JSONObject resData2;
        String accessToken;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String key = "openapi_unittest_access_token_" + RequestContext.get().getUserId();
        String accessTokenObj = DistributeCacheUtil.getCacheByKey((String)"bos_open_accesstoken", (String)key);
        String string = accessToken = accessTokenObj == null ? "" : accessTokenObj;
        if (StringUtils.isNotEmpty((String)accessToken)) {
            map.put(ACCESS_TOKEN, accessToken);
            return map;
        }
        String urlCosmic = UrlService.getDomainContextUrl();
        String getAppTokenUrl = urlCosmic + "/api/getAppToken.do";
        String getAccessTokenUrl = urlCosmic + "/api/login.do";
        String appToken = "";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appId", NUM_OPENAPI_UNITTEST);
        body.put("appSecuret", this.getUnitTestToken());
        body.put("tenantid", RequestContext.get().getTenantId());
        body.put("accountId", RequestContext.get().getAccountId());
        body.put("language", RequestContext.get().getLang());
        logger.info("getAccessTokenByAppId getAppToken url======" + getAppTokenUrl);
        String res = null;
        JSONObject resb = null;
        try {
            res = HttpClientUtils.postjson((String)getAppTokenUrl, header, (String)JSON.toJSONString(body), (int)default_connectionTimeout, (int)default_readTimeout);
        }
        catch (Exception e) {
            logger.error("getAccessTokenByAppId getAppToken et:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        if (StringUtil.isNotEmpty((String)res) && (resb = JSON.parseObject((String)res)).getBoolean("status") != null && resb.getBoolean("status").booleanValue() && (resData2 = resb.getJSONObject("data")) != null && StringUtils.isNotEmpty((String)resData2.getString("app_token"))) {
            appToken = resData2.getString("app_token");
        }
        if (StringUtils.isEmpty((String)appToken)) {
            map.put("request", "getAppToken error:, response:" + res);
            map.put(ACCESS_TOKEN, null);
            return map;
        }
        body = new HashMap();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
        if (user == null || ObjectUtils.isEmpty((Object)user.get("phone"))) {
            map.put("request", ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u624b\u673a\u53f7\u4e3a\u7a7a", (String)"OpenApiTestUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
            map.put(ACCESS_TOKEN, null);
            return map;
        }
        body.put("user", user.get("phone"));
        body.put("apptoken", appToken);
        body.put("tenantid", RequestContext.get().getTenantId());
        body.put("accountId", RequestContext.get().getAccountId());
        body.put("usertype", "Mobile");
        body.put("language", RequestContext.get().getLang());
        res = null;
        try {
            res = HttpClientUtils.postjson((String)getAccessTokenUrl, header, (String)JSON.toJSONString(body), (int)default_connectionTimeout, (int)default_readTimeout);
        }
        catch (Exception e) {
            logger.error("getAccessToken et:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        if (StringUtil.isNotEmpty((String)res) && (resb = JSON.parseObject((String)res)).getBoolean("status") != null && resb.getBoolean("status").booleanValue() && (resData = resb.getJSONObject("data")) != null && StringUtils.isNotEmpty((String)resData.getString(ACCESS_TOKEN))) {
            accessToken = resData.getString(ACCESS_TOKEN);
            long expireTime = resData.getLong("expire_time");
            BigDecimal expireTimeB = new BigDecimal(expireTime + "");
            BigDecimal currentTimeB = new BigDecimal(System.currentTimeMillis() + "");
            BigDecimal result = expireTimeB.subtract(currentTimeB).divide(new BigDecimal(1000));
            DistributeCacheUtil.setCacheByKey((String)"bos_open_accesstoken", (String)key, (String)accessToken, (int)(result.intValue() - 30), (TimeUnit)TimeUnit.SECONDS);
            map.put(ACCESS_TOKEN, accessToken);
            return map;
        }
        if (StringUtils.isEmpty((String)appToken)) {
            map.put("request", "getAccessToken error:, response:" + res);
            map.put(ACCESS_TOKEN, null);
            return map;
        }
        return map;
    }

    public Map<String, String> getIdentityByThirdApp() {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)FORM_OPENAPI_3RDAPPS);
        if (null == dataEntityType.getProperty("identity")) {
            return null;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)FORM_OPENAPI_3RDAPPS, (String)"id,identity", (QFilter[])new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)NUM_OPENAPI_UNITTEST)});
        if (null == dynamicObject) {
            return null;
        }
        String identity = dynamicObject.getString("identity");
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("x-acgw-identity", identity);
        return map;
    }

    public Map<String, Object> getAccessTokenByAppIdFocus() throws Exception {
        String key = "openapi_unittest_access_token_" + RequestContext.get().getUserId();
        DistributeCacheUtil.removeCacheByKey((String)"bos_open_accesstoken", (String)key);
        return this.getAccessTokenByAppId();
    }

    @Deprecated
    private Map<String, Object> getAppParam() {
        AppParam appParam = new AppParam("W3NF+MX967M", "15", Long.valueOf(ParameterOrgUtils.getParamRootOrgId()), ConfigConstant.OPEN_SYS_PARAMS_ACT_BOOK_ID);
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return paramMap;
    }

    @Deprecated
    public void setPwdToAppParam(String pwd) {
        Map<String, Object> paramMap = this.getAppParam();
        paramMap.put("unittest_token", pwd);
        SystemParamServiceHelper.saveAppParameter((String)"15", (Long)ParameterOrgUtils.getParamRootOrgId(), (Long)ConfigConstant.OPEN_SYS_PARAMS_ACT_BOOK_ID, (String)"W3NF+MX967M", paramMap);
    }

    public String getUnitTestToken() {
        String token = CommonConfigUtil.getValue((int)6, (String)"unittest_token");
        return token;
    }

    public void setUnitTestToken(String token) {
        CommonConfigUtil.setValue((int)6, (String)"unittest_token", (String)EncrypterFactory.getEncrypter().encode(token));
    }
}

