/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TreeNodeUtil {
    private static final String FORM_SCRIPT_SORT = "openapi_script_sort";
    private static final String OPENAPI_SCRIPT = "openapi_script";
    public static final String TAG_LEAF = "leaf_";
    private static final String TREE_VIEW = "treeview";
    private static final String NODE_CLOUD = "cloud_";
    private static final String NODE_APP = "app_";
    private static final String NODE_BIZ = "biz_";
    private static final String NODE_CUS = "cus_";
    private static final String NODE_AI = "ai_";
    private static final String APPID = "appid";
    private static final String BIZID = "bizid";
    private static final String CUSID = "cusid";
    private static final String KEY_API_SERVICE_TYPE = "apiservicetype";
    private static final String ID = "Id";
    private static final String FORM_APISERVICE = "openapi_apilist";

    public static TreeNode getTreeNodeById(TreeNode node, String nodeId) {
        if (node == null) {
            return null;
        }
        if (nodeId.equals(node.getId())) {
            return node;
        }
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            for (TreeNode childNode : node.getChildren()) {
                TreeNode target = TreeNodeUtil.getTreeNodeById(childNode, nodeId);
                if (target == null) continue;
                return target;
            }
        }
        return null;
    }

    public static void getAllChildId(List<String> target, TreeNode node) {
        if (target == null) {
            return;
        }
        target.add(node.getId());
        if (node.getChildren() != null) {
            for (TreeNode n : node.getChildren()) {
                TreeNodeUtil.getAllChildId(target, n);
            }
        }
    }

    public static TreeNode buildScriptSortTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeNodeUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        DynamicObjectCollection scriptSort = QueryServiceHelper.query((String)FORM_SCRIPT_SORT, (String)"name,number,level,isleaf,parent.number", null);
        if (scriptSort != null && scriptSort.size() > 0) {
            TreeNodeUtil.fillTree(root, scriptSort, 1);
        }
        return root;
    }

    public static void addScriptIntoTree(TreeNode root, Map<String, List<DynamicObject>> scriptMap) {
        if (scriptMap == null || scriptMap.size() == 0) {
            return;
        }
        if (root.getChildren() == null) {
            ArrayList childNodeList = new ArrayList();
            List<DynamicObject> script = scriptMap.get(root.getId());
            if (script != null) {
                script.stream().forEach(it -> {
                    TreeNode node = new TreeNode();
                    node.setText("\u270e " + it.getString("name"));
                    node.setId(TAG_LEAF + it.getString(ID));
                    childNodeList.add(node);
                });
                root.setChildren(childNodeList);
            }
        } else {
            for (TreeNode node : root.getChildren()) {
                TreeNodeUtil.addScriptIntoTree(node, scriptMap);
            }
        }
    }

    public static Map<String, List<DynamicObject>> getAllScript(DynamicObjectCollection scriptSort) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>();
        if (scriptSort != null && scriptSort.size() > 0) {
            scriptSort.stream().forEach(it -> {
                String key = it.getString("script_sort.number");
                if (map.containsKey(key)) {
                    ((List)map.get(key)).add(it);
                } else {
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                    list.add((DynamicObject)it);
                    map.put(key, list);
                }
            });
        }
        return map;
    }

    public static DynamicObjectCollection getAllScript() {
        DynamicObjectCollection scriptSort = QueryServiceHelper.query((String)OPENAPI_SCRIPT, (String)"name,script_sort.number,Id", null);
        return scriptSort;
    }

    private static void fillTree(TreeNode root, DynamicObjectCollection collection, int level) {
        ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>();
        for (DynamicObject dynamicObject : collection) {
            String parentNumber;
            int dyLevel = dynamicObject.getInt("level");
            String string = parentNumber = dynamicObject.getString("parent.number") == null ? "" : dynamicObject.getString("parent.number");
            if (dyLevel != level || !root.getId().equals(parentNumber)) continue;
            String childId = dynamicObject.getString("number");
            String childName = dynamicObject.getString("name");
            TreeNode childNode = new TreeNode(root.getId(), childId, childName);
            childNodeList.add(childNode);
            if (dynamicObject.getBoolean("isleaf")) continue;
            TreeNodeUtil.fillTree(childNode, collection, level + 1);
        }
        root.setChildren(childNodeList);
    }

    public static TreeNode buildTreeByCloud(TreeView tv1, String cloudID) {
        DynamicObject[] apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"Id,name,type", (QFilter[])new QFilter("bizcloud", "=", (Object)cloudID).toArray());
        DynamicObject[] apis = BusinessDataServiceHelper.load((String)FORM_APISERVICE, (String)"Id,name,apiservicetype,bizobject.Id,bizobject.name,appid.Id,customsort.Id,customsort.name", (QFilter[])new QFilter("appid.bizcloud.Id", "=", (Object)cloudID).and(new QFilter("version", "=", (Object)"2")).toArray());
        TreeNode tnApp = null;
        TreeNode tnCus = null;
        TreeNode tnAi = null;
        TreeNode tn2 = null;
        HashSet<String> bizids = new HashSet<String>();
        HashSet<String> cusids = new HashSet<String>();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeNodeUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        boolean hasChild = false;
        for (DynamicObject app : apps) {
            String appName;
            if (apis.length > 0) {
                hasChild = true;
            }
            StringBuilder builder = new StringBuilder(StringUtil.isNotEmpty((String)(appName = app.getString("name"))) ? appName : ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"TreeNodeUtil_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
            if ("2".equals(app.getString("type"))) {
                builder.append(ResManager.loadKDString((String)"\u3010\u6269\u5c55\u3011", (String)"TreeNodeUtil_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
            tnApp = new TreeNode(null, NODE_APP + app.getString(ID), builder.toString(), hasChild);
            for (DynamicObject api : apis) {
                if (!api.getString("appid.Id").equals(app.getString(ID))) continue;
                if ("0".equals(api.getString(KEY_API_SERVICE_TYPE))) {
                    tn2 = new TreeNode(NODE_APP + app.getString(ID), NODE_APP + app.getString(ID) + "_" + NODE_BIZ + api.getString("bizobject.Id"), api.getString("bizobject.name"), false);
                    if (bizids.contains(api.getString("bizobject.Id"))) continue;
                    tnApp.addChild(tn2);
                    bizids.add(api.getString("bizobject.Id"));
                    continue;
                }
                if ("2".equals(api.getString(KEY_API_SERVICE_TYPE)) || "3".equals(api.getString(KEY_API_SERVICE_TYPE))) {
                    String customsortId = StringUtil.isEmpty((String)api.getString("customsort.Id")) ? "0" : api.getString("customsort.Id");
                    tnCus = new TreeNode(NODE_APP + app.getString(ID), NODE_APP + app.getString(ID) + "_" + NODE_CUS + customsortId, api.getString("customsort.name"), false);
                    if (cusids.contains(NODE_APP + app.getString(ID) + customsortId)) continue;
                    tnApp.addChild(tnCus);
                    cusids.add(NODE_APP + app.getString(ID) + customsortId);
                    continue;
                }
                if (!"1".equals(api.getString(KEY_API_SERVICE_TYPE)) || cusids.contains(NODE_APP + app.getString(ID) + api.getString("customsort.Id"))) continue;
                tnApp.addChild(tnAi);
                cusids.add(NODE_APP + app.getString(ID) + api.getString("customsort.Id"));
            }
            root.addChild(tnApp);
            tv1.addNode(root);
        }
        return root;
    }

    public static TreeNode buildAppTree(IFormView formView) {
        TreeNode rootNode = new TreeNode(null, "allApp", ResManager.loadKDString((String)"\u5168\u90e8\u5e94\u7528", (String)"OpenApiListPlugin_9", (String)"bos-open-formplugin", (Object[])new Object[0]), true);
        rootNode.setIsOpened(true);
        DynamicObject[] apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"name,type", null);
        TreeView tv1 = (TreeView)formView.getControl(TREE_VIEW);
        tv1.deleteAllNodes();
        for (DynamicObject app : apps) {
            String appName = app.getString("name");
            StringBuilder builder = new StringBuilder(StringUtil.isNotEmpty((String)appName) ? appName : ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"TreeNodeUtil_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
            if ("2".equals(app.getString("type"))) {
                builder.append(ResManager.loadKDString((String)"\u3010\u6269\u5c55\u3011", (String)"TreeNodeUtil_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
            TreeNode tnApp = new TreeNode("allApp", NODE_APP + app.getString(ID), builder.toString(), false);
            rootNode.addChild(tnApp);
        }
        tv1.addNode(rootNode);
        tv1.treeNodeClick(null, "allApp");
        tv1.checkNode(rootNode);
        return rootNode;
    }

    public static TreeNode initCustomGroupTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeNodeUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        DynamicObjectCollection customgroup = QueryServiceHelper.query((String)"open_customgroup", (String)"name,number,level,isleaf,parent.number", null, (String)"id desc");
        if (customgroup != null && customgroup.size() > 0) {
            TreeNodeUtil.fillTree(root, customgroup, 1);
        }
        return root;
    }
}

