/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util.pdf;

import com.lowagie.text.Document;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.form.util.pdf.CreatePdfText;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OpenApiPdfBuilder {
    private static final Log logger = LogFactory.getLog(OpenApiPdfBuilder.class);
    private String httpmethod;
    private DynamicObject api;
    private DynamicObjectCollection headEntity;
    private DynamicObjectCollection getEntity;
    private DynamicObjectCollection postEntity;
    private DynamicObjectCollection responseEntity;
    String queryaram = "apiservicetype,operation,name,discription,httpmethod,urlformat,filterparam,headerentryentity.id,headerentryentity.headername,headerentryentity.headervalue,headerentryentity.headerdes,bodyentryentity.id,bodyentryentity.pid,bodyentryentity.paramname,objpropname,is_unique_key,body_level,is_body_custom,paramtype,must,example,bodyparamdes,respentryentity.pid,respparamname,respobjpropname,respparamtype,respparammust,respexample,resp_level,is_resp_custom,respdes,version,errorcodeentity.errorcode,errorcodeentity.errorcodedesc,appid,classname,methodname,urlformat,bodyentryentity.is_req_mul_value,respentryentity.is_resp_mul_value";

    public OpenApiPdfBuilder() {
    }

    public OpenApiPdfBuilder(Long fid) {
        this.api = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"openapi_apilist", (String)this.queryaram);
        this.httpmethod = (String)this.api.get("httpmethod");
        this.headEntity = (DynamicObjectCollection)this.api.get("headerentryentity");
        if (this.httpmethod.equals("0")) {
            this.getEntity = (DynamicObjectCollection)this.api.get("bodyentryentity");
        } else {
            this.postEntity = (DynamicObjectCollection)this.api.get("bodyentryentity");
        }
        this.responseEntity = (DynamicObjectCollection)this.api.get("respentryentity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String build() {
        Document pdf = null;
        String fp = "." + File.separator + System.currentTimeMillis() + "_tmp";
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(fp);
            pdf = CreatePdfText.createPdf(fp, fileOutputStream);
            CreatePdfText.createFile(pdf, this.httpmethod, this.headEntity, this.getEntity, this.postEntity, this.responseEntity, this.api);
        }
        catch (Exception e) {
            logger.info("\u5bfc\u51fa\u5931\u8d25", (Object)e);
        }
        finally {
            try {
                if (pdf != null) {
                    pdf.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                logger.info("\u5bfc\u51fa\u5931\u8d25", (Object)e);
            }
        }
        return fp;
    }

    public String buildSingle() throws Exception {
        Document pdf = null;
        String fp = "." + File.separator + System.currentTimeMillis() + "_tmp";
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(fp);
            pdf = CreatePdfText.createPdf(fp, fileOutputStream);
            CreatePdfText.createFile(pdf, this.httpmethod, this.headEntity, this.getEntity, this.postEntity, this.responseEntity, this.api);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u8be5API%2$s", (String)"OpenApiPdfBuilder_0", (String)"bos-open-formplugin", (Object[])new Object[0]), this.api.getString("name"), e.getMessage()), new Object[0]);
        }
        finally {
            if (pdf != null) {
                pdf.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return fp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String batchBuild(Object[] ids) throws Exception {
        Document pdf = null;
        String fp = "." + File.separator + System.currentTimeMillis() + "_tmp";
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(fp);
            pdf = CreatePdfText.createPdf(fp, fileOutputStream);
            for (Object id : ids) {
                DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)id, (String)"openapi_apilist", (String)this.queryaram);
                String httpmethod = (String)api.get("httpmethod");
                DynamicObjectCollection headEntity = (DynamicObjectCollection)api.get("headerentryentity");
                DynamicObjectCollection getEntity = null;
                DynamicObjectCollection postEntity = null;
                if (httpmethod.equals("0")) {
                    getEntity = (DynamicObjectCollection)api.get("bodyentryentity");
                } else {
                    postEntity = (DynamicObjectCollection)api.get("bodyentryentity");
                }
                DynamicObjectCollection responseEntity = (DynamicObjectCollection)api.get("respentryentity");
                try {
                    CreatePdfText.createFile(pdf, httpmethod, headEntity, getEntity, postEntity, responseEntity, api);
                }
                catch (Exception e) {
                    throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u8be5API%2$s", (String)"OpenApiPdfBuilder_0", (String)"bos-open-formplugin", (Object[])new Object[0]), api.getString("name"), e.getMessage()), new Object[0]);
                }
            }
        }
        finally {
            if (pdf != null) {
                pdf.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return fp;
    }
}

