/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util.pdf;

import com.kingdee.bos.ctrl.print.io.KDFontMapper;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.lowagie.text.Chapter;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Font;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PdfFontUtils {
    private static final Log logger = LogFactory.getLog(PdfFontUtils.class);
    private static volatile BaseFont baseFont;

    public static BaseFont getBaseFont() {
        BaseFont font = baseFont;
        if (font != null) {
            return font;
        }
        return PdfFontUtils.createBaseFont();
    }

    private static synchronized BaseFont createBaseFont() {
        BaseFont font = baseFont;
        if (font != null) {
            return font;
        }
        Font kf = KDFont.loadFontFromJAR((String)ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"PdfFontUtils_0", (String)"bos-open-formplugin", (Object[])new Object[0]), (int)0, (int)12);
        baseFont = font = new KDFontMapper().awtToPdf(kf);
        return font;
    }

    public static Paragraph getFont(String text, Float size, Integer style, Integer alignment, Float spacingBefore, Float spacingAfter) {
        com.lowagie.text.Font font = new com.lowagie.text.Font(PdfFontUtils.getBaseFont());
        if (size != null) {
            font.setSize(size.floatValue());
        }
        if (style != null) {
            font.setStyle(style.intValue());
        }
        Paragraph paragraph = new Paragraph(text, font);
        if (alignment != null) {
            paragraph.setAlignment(alignment.intValue());
        }
        if (spacingBefore != null) {
            paragraph.setSpacingBefore(spacingBefore.floatValue());
        }
        if (spacingAfter != null) {
            paragraph.setSpacingAfter(spacingAfter.floatValue());
        }
        return paragraph;
    }

    public static Chapter setChapter(String text, Float size, Integer style, Integer alignment, Float spacingBefore, Float spacingAfter) {
        Paragraph paragraph = PdfFontUtils.getFont(text, size, style, alignment, spacingBefore, spacingAfter);
        Chapter chapter = new Chapter(paragraph, 1);
        chapter.setNumberDepth(0);
        return chapter;
    }

    public static Section setSectionChapter(Chapter chapter, String text, Float size, Integer style, Integer alignment, Float spacingBefore, Float spacingAfter) {
        Paragraph paragraph = PdfFontUtils.getFont(text, size, style, alignment, spacingBefore, spacingAfter);
        Section section = chapter.addSection(paragraph);
        section.setNumberDepth(0);
        return section;
    }
}

