/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util.swagger;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.openapi.base.dataservice.OpenApiDataUtil;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.openapi.form.util.OpenApiDataPreviewUtil;
import kd.bos.openapi.form.util.OpenApiDataToJsonFormatUtils;
import kd.bos.openapi.form.util.swagger.model.Info;
import kd.bos.openapi.form.util.swagger.model.MediaType;
import kd.bos.openapi.form.util.swagger.model.Operation;
import kd.bos.openapi.form.util.swagger.model.Parameter;
import kd.bos.openapi.form.util.swagger.model.Path;
import kd.bos.openapi.form.util.swagger.model.RequestBody;
import kd.bos.openapi.form.util.swagger.model.Response;
import kd.bos.openapi.form.util.swagger.model.Schema;
import kd.bos.openapi.form.util.swagger.model.Server;
import kd.bos.openapi.form.util.swagger.model.SwaggerModel;
import kd.bos.openapi.form.util.swagger.model.Tag;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.xdb.util.Pair;
import org.yaml.snakeyaml.Yaml;

public class SwaggerUtil {
    private static final String PARAMNAME = "paramname";
    private static final String BODYENTRYENTITY = "bodyentryentity";
    private static final String RESPENTRYENTITY = "respentryentity";
    public static final String RESPPARAMNAME = "respparamname";
    private static Set<String> arraySet = new HashSet<String>();

    public static String genSwaggerJson(List<Long> apiIds) {
        SwaggerModel swaggerModel = new SwaggerModel();
        swaggerModel.setOpenapi("3.0.3");
        Info info = new Info();
        info.setDescription("Kingdee Open Api");
        info.setTitle(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u5e73\u53f0-\u5f00\u653e\u5e73\u53f0-Api", (String)"SwaggerUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        info.setVersion(ApiPluginUtil.getCosmicVer());
        swaggerModel.setInfo(info);
        swaggerModel.setTags(new ArrayList<Tag>());
        ArrayList<Server> servers = new ArrayList<Server>();
        Server server = new Server();
        server.setUrl(UrlService.getDomainContextUrl());
        servers.add(server);
        swaggerModel.setServers(servers);
        swaggerModel.setTags(SwaggerUtil.genTags(apiIds));
        LinkedHashMap<String, Path> paths = new LinkedHashMap<String, Path>();
        swaggerModel.setPaths(paths);
        apiIds.forEach(apiId -> {
            Map<String, Object> map;
            DynamicObject api = BusinessDataServiceHelper.loadSingle((String)"openapi_apilist", (String)"id,urlformat,discription,cosmicver,appid.name", (QFilter[])new QFilter[]{new QFilter("id", "=", apiId)});
            ApiModel apiModel = OpenApiDataUtil.getApiModelFromCache((String)api.getString("urlformat"));
            if (apiModel == null) {
                throw new OpenApiException(ApiErrorCode.Data_NotFound, "apiModel info not found", new Object[0]);
            }
            api = BusinessDataServiceHelper.loadSingle((Object)apiId, (String)"openapi_apilist");
            DynamicObjectCollection headerentryentity = api.getDynamicObjectCollection("headerentryentity");
            DynamicObjectCollection bodyentryentity = api.getDynamicObjectCollection(BODYENTRYENTITY);
            DynamicObjectCollection respentryentity = api.getDynamicObjectCollection(RESPENTRYENTITY);
            Boolean isGet = api.getInt("httpmethod") == 0;
            Path path = new Path();
            paths.put("/kapi" + apiModel.getUrl(), path);
            path.setSummary(apiModel.getName());
            path.setDescription(api.getString("discription"));
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            RequestBody requestBody = new RequestBody();
            Response response = new Response();
            LinkedHashMap<String, Response> codeAndResMap = new LinkedHashMap<String, Response>();
            codeAndResMap.put("200", response);
            if (isGet.booleanValue()) {
                Operation get = new Operation();
                get.setSummary(apiModel.getName());
                get.setDescription("");
                get.setRequestBody(null);
                get.setResponses(codeAndResMap);
                get.setParameters(parameters);
                get.setTags(Collections.singletonList(api.getString("appid.name")));
                path.setGet(get);
            } else {
                Operation post = new Operation();
                post.setSummary(apiModel.getName());
                post.setDescription("");
                post.setRequestBody(requestBody);
                post.setResponses(codeAndResMap);
                post.setParameters(parameters);
                post.setTags(Collections.singletonList(api.getString("appid.name")));
                path.setPost(post);
            }
            headerentryentity.forEach(header -> {
                Parameter parameter = new Parameter();
                parameter.setName(header.getString("headername"));
                parameter.setIn("header");
                parameter.setRequired(Boolean.FALSE);
                parameter.setDescription(header.getString("headerdes"));
                parameter.setExample(header.getString("headervalue"));
                parameter.setSchema(new Schema("string"));
                parameters.add(parameter);
            });
            if (headerentryentity.size() <= 0) {
                SwaggerUtil.preSetHeader(parameters);
            }
            if (isGet.booleanValue()) {
                bodyentryentity.forEach(bodyEntity -> {
                    Parameter parameter = new Parameter();
                    parameter.setDescription(bodyEntity.getString("bodyparamdes"));
                    parameter.setIn("query");
                    parameter.setName(bodyEntity.getString(PARAMNAME));
                    parameter.setRequired(bodyEntity.getBoolean("must"));
                    parameter.setExample(bodyEntity.getString("example"));
                    boolean isReqMulValue = bodyEntity.getBoolean("is_req_mul_value");
                    if (isReqMulValue) {
                        parameter.setSchema(new Schema("array"));
                    } else {
                        parameter.setSchema(new Schema(SwaggerUtil.setSwaggerTypeFromParaType(bodyEntity.getString("paramtype").toLowerCase())));
                    }
                    parameters.add(parameter);
                });
                if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype") && ApiOperationType.QUERY.getOp().equalsIgnoreCase(api.getString("operation"))) {
                    Parameter pageSize = new Parameter();
                    pageSize.setDescription(ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\uff0c\u5206\u9875\u6570\u91cf", (String)"SwaggerUtil_4", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    pageSize.setIn("query");
                    pageSize.setName("pageSize");
                    pageSize.setRequired(true);
                    pageSize.setExample("10");
                    pageSize.setSchema(new Schema("integer"));
                    parameters.add(pageSize);
                    Parameter pageNo = new Parameter();
                    pageNo.setDescription(ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\uff0c\u67e5\u8be2\u9875\u7801", (String)"SwaggerUtil_5", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    pageNo.setIn("query");
                    pageNo.setName("pageNo");
                    pageNo.setRequired(false);
                    pageNo.setExample("1");
                    pageNo.setSchema(new Schema("integer"));
                    parameters.add(pageNo);
                }
            } else {
                HashMap<String, Object> newMap;
                Schema data;
                HashMap<String, Object> proNewMap;
                LinkedHashMap<String, MediaType> contentMap = new LinkedHashMap<String, MediaType>();
                MediaType mediaType = new MediaType();
                requestBody.setContent(contentMap);
                Schema requestSchema = new Schema();
                requestSchema.setType("object");
                Map<String, Object> propMap = SwaggerUtil.transferToSwaggerBody(bodyentryentity, BODYENTRYENTITY);
                requestSchema.setProperties(propMap);
                requestSchema.setRequired(SwaggerUtil.findRequiredFiled(bodyentryentity, 0L));
                map = OpenApiDataToJsonFormatUtils.transferToMap(bodyentryentity, BODYENTRYENTITY);
                requestSchema.setExample(map);
                mediaType.setSchema(requestSchema);
                contentMap.put("application/json", mediaType);
                if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype")) {
                    HashMap<String, Object> opMap = new HashMap<String, Object>();
                    opMap.put("data", map);
                    requestSchema.setExample(opMap);
                    proNewMap = new HashMap<String, Object>();
                    data = new Schema();
                    data.setType("object");
                    data.setProperties(propMap);
                    proNewMap.put("data", data);
                    requestSchema.setProperties(proNewMap);
                }
                if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype") && ApiOperationType.SAVE.getOp().equalsIgnoreCase(api.getString("operation"))) {
                    newMap = new HashMap<String, Object>();
                    newMap.put("data", Collections.singleton(map));
                    requestSchema.setExample(newMap);
                    proNewMap = new HashMap();
                    data = new Schema();
                    data.setType("array");
                    Schema item = new Schema();
                    item.setProperties(propMap);
                    item.setType("object");
                    data.setItems(item);
                    proNewMap.put("data", data);
                    requestSchema.setProperties(proNewMap);
                }
                if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype") && ApiOperationType.QUERY.getOp().equalsIgnoreCase(api.getString("operation"))) {
                    newMap = new HashMap();
                    newMap.put("data", map);
                    newMap.put("pageSize", 10);
                    newMap.put("pageNo", 1);
                    requestSchema.setExample(newMap);
                    proNewMap = new HashMap();
                    data = new Schema();
                    data.setType("object");
                    data.setProperties(propMap);
                    Schema pageSize = new Schema();
                    pageSize.setType("integer");
                    Schema pageNo = new Schema();
                    pageNo.setType("integer");
                    proNewMap.put("data", data);
                    proNewMap.put("pageSize", pageSize);
                    proNewMap.put("pageNo", pageNo);
                    requestSchema.setProperties(proNewMap);
                }
            }
            int apiType = apiModel.getApiServiceType().ordinal();
            response.setDescription("success");
            LinkedHashMap<String, MediaType> contentMap = new LinkedHashMap<String, MediaType>();
            MediaType mediaType = new MediaType();
            contentMap.put("application/json", mediaType);
            Schema responseSchema = new Schema();
            if (!isGet.booleanValue() && apiType == 0 && !api.getString("operation").equalsIgnoreCase(ApiOperationType.QUERY.getOp())) {
                DynamicObjectCollection opResCollections = SwaggerUtil.buildDcByOp(api);
                responseSchema.setProperties(SwaggerUtil.transferToSwaggerBody(opResCollections, RESPENTRYENTITY));
                responseSchema.setExample(OpenApiDataToJsonFormatUtils.transferToMap(opResCollections, RESPENTRYENTITY));
                responseSchema.setType("object");
            } else {
                responseSchema.setType("object");
                if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype") && ApiOperationType.QUERY.getOp().equalsIgnoreCase(api.getString("operation"))) {
                    DynamicObjectCollection respentry = ApiPluginUtil.buildQueryEntryData(ApiOperationType.QUERY.getOp(), respentryentity);
                    responseSchema.setProperties(SwaggerUtil.transferToSwaggerBody(respentry, RESPENTRYENTITY));
                    Pair<Map<String, Object>, Boolean> result = OpenApiDataPreviewUtil.getDataPair("", RESPENTRYENTITY, respentryentity, api.getString("operation"), api.getInt("httpmethod"));
                    responseSchema.setExample((Map)result.getKey());
                } else {
                    responseSchema.setProperties(SwaggerUtil.transferToSwaggerBody(respentryentity, RESPENTRYENTITY));
                    map = OpenApiDataToJsonFormatUtils.transferToMap(respentryentity, RESPENTRYENTITY);
                    responseSchema.setExample(map);
                    if (ApiServiceType.SCRIPT.ordinal() == api.getInt("apiservicetype")) {
                        HashMap<String, Object> scriptMap = new HashMap<String, Object>();
                        scriptMap.put("data", map);
                        scriptMap.put("status", true);
                        scriptMap.put("errorCode", "0");
                        scriptMap.put("message", "");
                        responseSchema.setExample(scriptMap);
                    }
                }
            }
            mediaType.setSchema(responseSchema);
            response.setContent(contentMap);
        });
        return JSON.toJSONString((Object)swaggerModel, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
    }

    private static List<Tag> genTags(List<Long> apiIds) {
        ArrayList tags = new ArrayList(apiIds.size());
        DynamicObject[] appNames = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)"appid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)apiIds.toArray())});
        ArrayList<String> appNameList = new ArrayList<String>(appNames.length);
        for (int i = 0; i < appNames.length; ++i) {
            appNameList.add(appNames[i].getString("appid.name"));
        }
        appNameList.stream().distinct().forEach(name -> {
            Tag tag = new Tag();
            tag.setName((String)name);
            tags.add(tag);
        });
        return tags.size() == 0 ? null : tags.stream().distinct().collect(Collectors.toList());
    }

    public static String genSwaggerYaml(List<Long> apiId) {
        String json = SwaggerUtil.genSwaggerJson(apiId);
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(json);
        String yamlStr = yaml.dump((Object)map);
        return yamlStr;
    }

    private static List<String> findRequiredFiled(DynamicObjectCollection dynamicObjects, Long pid) {
        ArrayList<String> result = new ArrayList<String>();
        dynamicObjects.forEach(it -> {
            if (it.getLong("pid") == pid.longValue() && ("true".equalsIgnoreCase(it.getString("must")) || "1".equals(it.getString("must")))) {
                result.add(it.getString(PARAMNAME));
            }
        });
        return result.size() == 0 ? null : result;
    }

    public static Map<String, Object> transferToSwaggerBody(DynamicObjectCollection collection, String entryType) {
        Map<String, Object> resultMap = new LinkedHashMap<String, Object>(16);
        DynamicObjectCollection temp = (DynamicObjectCollection)collection.clone();
        resultMap = SwaggerUtil.packageSwaggerRequestOrResponseBody(temp, "0", entryType, resultMap);
        return resultMap;
    }

    private static Map<String, Object> packageSwaggerRequestOrResponseBody(DynamicObjectCollection dynamicObjects, String Pid, String entryType, Map<String, Object> resultMap) {
        boolean isBodyColl = BODYENTRYENTITY.equals(entryType);
        Set<String> pidSet = SwaggerUtil.getPIdSet(dynamicObjects);
        for (DynamicObject top : dynamicObjects) {
            String swaggerType;
            String topId = top.getString("pid");
            if (!Pid.equals(topId)) continue;
            String name = isBodyColl ? top.getString(PARAMNAME) : top.getString(RESPPARAMNAME);
            String paramType = isBodyColl ? top.getString("paramtype") : top.getString("respparamtype");
            boolean isMulValue = top.getBoolean(isBodyColl ? "is_req_mul_value" : "is_resp_mul_value");
            String string = swaggerType = isMulValue ? "array" : SwaggerUtil.setSwaggerTypeFromParaType(paramType);
            if (pidSet.contains(top.getPkValue().toString())) {
                LinkedHashMap<String, Object> childMap = new LinkedHashMap<String, Object>();
                SwaggerUtil.packageSwaggerRequestOrResponseBody(dynamicObjects, top.getString("id"), entryType, childMap);
                Schema schema = new Schema();
                schema.setType(swaggerType);
                if (swaggerType.equals("array")) {
                    Schema schemaItems = new Schema("object");
                    schemaItems.setProperties(childMap);
                    schema.setItems(schemaItems);
                } else {
                    schema.setProperties(childMap);
                }
                if (isBodyColl) {
                    schema.setRequired(SwaggerUtil.findRequiredFiled(dynamicObjects, top.getLong("id")));
                }
                resultMap.put(name, schema);
                continue;
            }
            Schema schema = new Schema(swaggerType);
            if (swaggerType.equals("array")) {
                SwaggerUtil.addItems(paramType, schema);
            }
            resultMap.put(name, schema);
        }
        return resultMap;
    }

    private static Set<String> getPIdSet(DynamicObjectCollection dynamicObjects) {
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject dy : dynamicObjects) {
            set.add(dy.getString("pid"));
        }
        return set;
    }

    private static DynamicObjectCollection buildDcByOp(DynamicObject api) {
        String op = api.getString("operation");
        DynamicObjectCollection result = new DynamicObjectCollection();
        DynamicObjectType resType = api.getDynamicObjectCollection(RESPENTRYENTITY).getDynamicObjectType();
        DynamicObject errorCode = new DynamicObject(resType);
        DynamicObject message = new DynamicObject(resType);
        DynamicObject status = new DynamicObject(resType);
        DynamicObject data = new DynamicObject(resType);
        status.set(RESPPARAMNAME, (Object)"status");
        status.set("respparamtype", (Object)"Boolean");
        status.set("pid", (Object)0L);
        status.set("id", (Object)ID.genLongId());
        status.set("respexample", (Object)"\"true/false\"");
        errorCode.set(RESPPARAMNAME, (Object)"errorCode");
        errorCode.set("respparamtype", (Object)"String");
        errorCode.set("pid", (Object)0L);
        errorCode.set("id", (Object)ID.genLongId());
        errorCode.set("respexample", (Object)ResManager.loadKDString((String)"\"\u6210\u529f\u65f6\u4e3a0\uff0c\u5931\u8d25\u65f6\u4f1a\u8fd4\u56de\u9519\u8bef\u7801\u5982400\"", (String)"SwaggerUtil_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
        message.set(RESPPARAMNAME, (Object)"message");
        message.set("respparamtype", (Object)"String");
        message.set("pid", (Object)0L);
        message.set("id", (Object)ID.genLongId());
        message.set("respexample", (Object)ResManager.loadKDString((String)"\"\u6210\u529f\u65f6\u4e3a\u7a7a\uff0c\u5931\u8d25\u65f6\u4f1a\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u5982\u201c\u64cd\u4f5c\u5931\u8d25\u201d\"", (String)"SwaggerUtil_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
        data.set(RESPPARAMNAME, (Object)"data");
        data.set("respparamtype", (Object)"Object");
        data.set("respexample", (Object)new LocaleString("{}"));
        data.set("pid", (Object)0L);
        data.set("id", (Object)999L);
        result.add((Object)status);
        result.add((Object)errorCode);
        result.add((Object)message);
        result.add((Object)data);
        if ("query".equalsIgnoreCase(op)) {
            DynamicObject filter = new DynamicObject(resType);
            filter.set(RESPPARAMNAME, (Object)"filter");
            filter.set("respparamtype", (Object)"String");
            filter.set("pid", (Object)999L);
            filter.set("id", (Object)ID.genLongId());
            filter.set("respexample", (Object)ResManager.loadKDString((String)"\"\u67e5\u8be2\u6761\u4ef6\"", (String)"SwaggerUtil_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
            result.add((Object)filter);
            DynamicObject lastPage = new DynamicObject(resType);
            lastPage.set(RESPPARAMNAME, (Object)"lastPage");
            lastPage.set("respparamtype", (Object)"Boolean");
            lastPage.set("pid", (Object)999L);
            lastPage.set("id", (Object)ID.genLongId());
            lastPage.set("respexample", (Object)"\"1\"");
            result.add((Object)lastPage);
            DynamicObject pageNo = new DynamicObject(resType);
            pageNo.set(RESPPARAMNAME, (Object)"pageNo");
            pageNo.set("respparamtype", (Object)"Integer");
            pageNo.set("respexample", (Object)"\"1\"");
            pageNo.set("pid", (Object)999L);
            pageNo.set("id", (Object)ID.genLongId());
            result.add((Object)pageNo);
            DynamicObject pageSize = new DynamicObject(resType);
            pageSize.set(RESPPARAMNAME, (Object)"pageSize");
            pageSize.set("respparamtype", (Object)"Integer");
            pageSize.set("respexample", (Object)"\"10\"");
            pageSize.set("pid", (Object)999L);
            pageSize.set("id", (Object)ID.genLongId());
            result.add((Object)pageSize);
            DynamicObject totalCount = new DynamicObject(resType);
            totalCount.set(RESPPARAMNAME, (Object)"totalCount");
            totalCount.set("respparamtype", (Object)"Integer");
            totalCount.set("respexample", (Object)"\"100\"");
            totalCount.set("pid", (Object)999L);
            totalCount.set("id", (Object)ID.genLongId());
            result.add((Object)totalCount);
            DynamicObject row = new DynamicObject(resType);
            row.set(RESPPARAMNAME, (Object)"row");
            row.set("respparamtype", (Object)"List");
            row.set("id", (Object)9999L);
            row.set("pid", (Object)999L);
            result.add((Object)row);
            DynamicObjectCollection body = api.getDynamicObjectCollection(RESPENTRYENTITY);
            DynamicObjectCollection bodiesClone = new DynamicObjectCollection(body.getDynamicObjectType(), (Object)body);
            for (int i = 0; i < body.size(); ++i) {
                DynamicObject dy = new DynamicObject(resType);
                dy.set("id", ((DynamicObject)body.get(i)).get("id"));
                dy.set("pid", ((DynamicObject)body.get(i)).get("pid"));
                dy.set(RESPPARAMNAME, ((DynamicObject)body.get(i)).get(RESPPARAMNAME));
                dy.set("respparamtype", ((DynamicObject)body.get(i)).get("respparamtype"));
                dy.set("respexample", ((DynamicObject)body.get(i)).get("respexample"));
                bodiesClone.add((Object)dy);
            }
            bodiesClone.forEach(it -> {
                if ("0".equals(it.getString("pid"))) {
                    it.set("pid", (Object)9999L);
                }
            });
            result.addAll((Collection)body);
        } else {
            DynamicObject result_data = new DynamicObject(resType);
            result_data.set(RESPPARAMNAME, (Object)"result");
            result_data.set("respparamtype", (Object)"Array<Map>");
            result_data.set("respexample", (Object)"\"[]\"");
            result_data.set("pid", (Object)999L);
            result_data.set("id", (Object)ID.genLongId());
            result.add((Object)result_data);
            DynamicObject failCount = new DynamicObject(resType);
            failCount.set(RESPPARAMNAME, (Object)"failCount");
            failCount.set("respparamtype", (Object)"String");
            failCount.set("respexample", (Object)"\"0\"");
            failCount.set("pid", (Object)999L);
            failCount.set("id", (Object)ID.genLongId());
            result.add((Object)failCount);
            DynamicObject successCount = new DynamicObject(resType);
            successCount.set(RESPPARAMNAME, (Object)"successCount");
            successCount.set("respparamtype", (Object)"String");
            successCount.set("respexample", (Object)"\"0\"");
            successCount.set("pid", (Object)999L);
            successCount.set("id", (Object)ID.genLongId());
            result.add((Object)successCount);
            if (!"save".equalsIgnoreCase(op)) {
                DynamicObject filter = new DynamicObject(resType);
                filter.set(RESPPARAMNAME, (Object)"filter");
                filter.set("respparamtype", (Object)"String");
                filter.set("respexample", (Object)"\"\"");
                filter.set("pid", (Object)999L);
                filter.set("id", (Object)ID.genLongId());
                result.add((Object)filter);
                DynamicObject totalCount = new DynamicObject(resType);
                totalCount.set(RESPPARAMNAME, (Object)"totalCount");
                totalCount.set("respparamtype", (Object)"String");
                totalCount.set("respexample", (Object)"\"100\"");
                totalCount.set("pid", (Object)999L);
                totalCount.set("id", (Object)ID.genLongId());
                result.add((Object)totalCount);
            }
        }
        return result;
    }

    public static String setSwaggerTypeFromParaType(String typeStr) {
        switch (typeStr) {
            case "Integer": 
            case "int": 
            case "Long": 
            case "Decimal": {
                return "integer";
            }
            case "String": 
            case "Date": 
            case "DateTime": {
                return "string";
            }
            case "Boolean": 
            case "boolean": {
                return "boolean";
            }
            case "float": 
            case "double": 
            case "Double": 
            case "Float": {
                return "number";
            }
            case "Entries": {
                return "array";
            }
        }
        if (arraySet.contains(typeStr) || typeStr.endsWith("[]") || typeStr.startsWith("List")) {
            return "array";
        }
        return "object";
    }

    public static void addItems(String paramType, Schema schema) {
        if ((paramType = paramType.toLowerCase()).contains("string")) {
            schema.setItems(new Schema("string"));
        } else if (paramType.contains("integer")) {
            schema.setItems(new Schema("integer"));
        } else if (paramType.contains("boolean")) {
            schema.setItems(new Schema("boolean"));
        } else if (paramType.contains("double") || paramType.contains("float") || paramType.contains("decimal")) {
            schema.setItems(new Schema("number"));
        } else {
            schema.setItems(new Schema("object"));
        }
    }

    private static void preSetHeader(List<Parameter> parameters) {
        Parameter parameterContentType = new Parameter();
        parameterContentType.setName("Content-Type");
        parameterContentType.setIn("header");
        parameterContentType.setRequired(Boolean.FALSE);
        parameterContentType.setExample("application/json");
        parameterContentType.setDescription(ResManager.loadKDString((String)"\u5185\u5bb9\u683c\u5f0f", (String)"SwaggerUtil_10", (String)"bos-open-formplugin", (Object[])new Object[0]));
        parameterContentType.setSchema(new Schema("string"));
        parameters.add(parameterContentType);
        Parameter parameterAccesstoken = new Parameter();
        parameterAccesstoken.setName("accessToken");
        parameterAccesstoken.setIn("header");
        parameterAccesstoken.setRequired(Boolean.FALSE);
        parameterAccesstoken.setExample(ResManager.loadKDString((String)"\u83b7\u53d6\u7684accessToken\u503c", (String)"SwaggerUtil_6", (String)"bos-open-formplugin", (Object[])new Object[0]));
        parameterAccesstoken.setDescription(ResManager.loadKDString((String)"\u8bf7\u6c42\u4ee4\u724c", (String)"SwaggerUtil_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
        parameterAccesstoken.setSchema(new Schema("string"));
        parameters.add(parameterAccesstoken);
        Parameter parameterIdKey = new Parameter();
        parameterIdKey.setName("Idempotency-Key");
        parameterIdKey.setIn("header");
        parameterIdKey.setRequired(Boolean.FALSE);
        parameterIdKey.setExample(ResManager.loadKDString((String)"\u552f\u4e00\u7684requestId", (String)"SwaggerUtil_8", (String)"bos-open-formplugin", (Object[])new Object[0]));
        parameterIdKey.setDescription(ResManager.loadKDString((String)"\u975e\u5fc5\u4f20\u53c2\u6570\uff0c\u9632\u6b62\u63a5\u53e3\u88ab\u91cd\u590d\u8c03\u7528", (String)"SwaggerUtil_9", (String)"bos-open-formplugin", (Object[])new Object[0]));
        parameterIdKey.setSchema(new Schema("string"));
        parameters.add(parameterIdKey);
    }

    static {
        arraySet.add("Array<String>");
        arraySet.add("Array<Long>");
        arraySet.add("Array<Integer>");
        arraySet.add("Array<Date>");
        arraySet.add("List<String>");
        arraySet.add("List<Integer>");
        arraySet.add("List<Long>");
        arraySet.add("List<Boolean>");
        arraySet.add("List<Short>");
        arraySet.add("List<Byte>");
        arraySet.add("List<Float>");
        arraySet.add("List<Double>");
        arraySet.add("List<Character>");
    }
}

