/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.open.res.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.net.SocketTimeoutException;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.crypto.EncryptorFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.encrypt.impl.RSAEncrypterUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SignUtils;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.model.EncryptInfo;
import kd.bos.openapi.security.model.EncryptionEnum;
import kd.bos.openapi.security.model.RequestSecurityDto;
import kd.bos.openapi.security.model.ResponseSecurityDto;
import kd.bos.openapi.security.model.SignInfoDto;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;

public class OpenApiSecurityUtil {
    private static Log logger = LogFactory.getLog(OpenApiSecurityUtil.class);
    private static int DEFAULT_RANDOM_KEY_LENGTH = 16;
    private static int DEFAULT_ENCRYPT_LENGTH = 128;
    private static Map<String, String> algorithmMap = new HashMap<String, String>();
    public static final String URL_CREATE_RES_APPLY = "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/createOrUpdate";
    public static final String URL_CHECK_EMAIL_EXITS = "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/checkEmailExits";
    public static final String URL_FIND_APPLY_INFO = "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/findApplyInfo";
    public static final String URL_FIND_THIRD_CODE_EXITS = "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/findThirdCodeExits";
    private static int CONNECTION_TIMEOUT;
    private static int READ_TIMEOUT;

    public static EncryptInfo encrypt(String content, String algorithm, String publicKeyBase64) throws OpenApiException {
        String randomKey = RandomStringUtils.randomAlphabetic((int)DEFAULT_RANDOM_KEY_LENGTH);
        String result = OpenApiSecurityUtil.encryptOrDecrypt(true, content, algorithm, randomKey, DEFAULT_ENCRYPT_LENGTH);
        String dgtlEnvlp = "";
        if (StringUtils.isNotEmpty((CharSequence)publicKeyBase64)) {
            dgtlEnvlp = OpenApiSecurityUtil.signByPublicKey(randomKey, publicKeyBase64);
        }
        return EncryptInfo.valueOf((String)result, (String)dgtlEnvlp);
    }

    public static String decrypt(String content, String algorithm, String randomKey) throws Exception {
        return OpenApiSecurityUtil.encryptOrDecrypt(false, content, algorithm, randomKey, DEFAULT_ENCRYPT_LENGTH);
    }

    public static String encryptOrDecrypt(boolean isEncrypt, String content, String algorithm, String randomKey, int encryptLength) throws OpenApiException {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        if (!algorithmMap.containsKey(algorithm)) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "not support algorithm:" + algorithm, new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)randomKey)) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "not support randomKey, the randomKey is null", new Object[0]);
        }
        if (encryptLength < DEFAULT_ENCRYPT_LENGTH) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "not support encryptLength, the length should not be less 128, encryptLength:" + encryptLength, new Object[0]);
        }
        try {
            return isEncrypt ? EncryptorFactory.getEncryptor((String)algorithmMap.get(algorithm)).encrypt(content, randomKey, encryptLength) : EncryptorFactory.getEncryptor((String)algorithmMap.get(algorithm)).decrypt(content, randomKey, encryptLength);
        }
        catch (EncryptException e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "encrypt or decrypt error: " + e.getMessage(), new Object[0]);
        }
    }

    public static String signByPublicKey(String content, String publicKeyBase64) throws OpenApiException {
        String result = "";
        try {
            PublicKey publicKey = RSAEncrypterUtil.getPublicKey((String)publicKeyBase64);
            result = RSAEncrypterUtil.encrypt((String)content, (PublicKey)publicKey);
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "signByPublicKey error:" + e.getMessage(), new Object[]{e});
        }
        return result;
    }

    public static String unSignByPublicKey(String content, String publicKeyBase64) throws OpenApiException {
        String result = "";
        try {
            PublicKey publicKey = RSAEncrypterUtil.getPublicKey((String)publicKeyBase64);
            result = RSAEncrypterUtil.decrypt((String)content, (PublicKey)publicKey);
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "unSignByPublicKey error:" + e.getMessage(), new Object[]{e});
        }
        return result;
    }

    private static StringBuilder getSignatureString(String datetimeString, String signatureNonce, String body) {
        StringBuilder sb = new StringBuilder();
        sb.append(body);
        sb.append(datetimeString);
        sb.append(signatureNonce);
        return sb;
    }

    private static String signing(String appSecret, String content, String uuid, String timestamp) {
        String encyptString = "";
        try {
            StringBuilder sb = OpenApiSecurityUtil.getSignatureString(timestamp, uuid, content);
            encyptString = SignUtils.HMACSHA256StrByKey((String)sb.toString(), (String)appSecret);
        }
        catch (Exception e) {
            logger.error("signing error:" + e.getMessage(), (Throwable)e);
        }
        return encyptString;
    }

    private static String getOpenApiSign(String baseCode, String accountId) {
        if (StringUtil.isEmpty((String)accountId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the server accountId is invalid.", new Object[0]);
        }
        if (StringUtil.isEmpty((String)baseCode)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the clientToServer.openApiSign is invalid.", new Object[0]);
        }
        return EncryptUtil.genSignWithAccountId((String)baseCode, (String)accountId);
    }

    public static <T> CustomApiResult<T> doSignApiRequest(String jsonContent, String url, Class<T> clazz, String accountId, Map<String, String> params) throws OpenApiException {
        String appSecret = params.get("resourceClientToServer.appSecret");
        String bosPublickBase64Key = params.get("resourceClientToServer.bosPublickBase64Key");
        String openApiSign = params.get("resourceClientToServer.openApiSign");
        EncryptInfo encodeInfo = OpenApiSecurityUtil.encrypt(jsonContent, EncryptionEnum.getEncryption((Long)1L), bosPublickBase64Key);
        RequestSecurityDto requestSec = new RequestSecurityDto();
        requestSec.setEncryptData(encodeInfo.getEncryptInfo());
        requestSec.setDgtlEnvlp(encodeInfo.getDgtlEnvlp());
        String uuid = UUID.randomUUID().toString();
        String timestamp = DateUtil.convertToStr((String)SignUtils.SIGNATUR_TIME_FORMAT, (Date)new Date());
        requestSec.setSignatureNonce(uuid);
        requestSec.setTimestamp(timestamp);
        String signString = JSON.toJSONString((Object)requestSec);
        SignInfoDto signInfoDto = new SignInfoDto();
        signInfoDto.setContent(signString);
        signInfoDto.setSignatureNonce(uuid);
        signInfoDto.setDateTime(timestamp);
        String sign = OpenApiSecurityUtil.signing(appSecret, signString, uuid, timestamp);
        requestSec.setSignature(sign);
        String requestString = JSON.toJSONString((Object)requestSec);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("openApiAuth", "5");
        headerMap.put("Content-Type", "application/json");
        headerMap.put("openApiSign", OpenApiSecurityUtil.getOpenApiSign(openApiSign, accountId));
        String responseString = "";
        try {
            responseString = HttpClientUtils.postjson((String)url, headerMap, (String)requestString, (int)CONNECTION_TIMEOUT, (int)READ_TIMEOUT);
        }
        catch (SocketTimeoutException | ConnectTimeoutException e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"\u8d44\u6e90\u4e91\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"OpenApiSecurityUtil_1", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            logger.info("request.header:" + JSON.toJSONString(headerMap) + " request.body:" + requestString + " response-=" + responseString + " doSignApiRequest send post error:" + e.getMessage(), (Object)e);
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684\u4e91\u7aef\u5730\u5740\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e91\u7aef\u5730\u5740\u3002", (String)"ThirdAppApplyFormPlugin_23", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        String loginErrorCode = ApiErrorCode.LOGIN_BIZ_ERROR.getStatusCode();
        if (responseString.contains(loginErrorCode)) {
            JSONObject errorResponse = JSON.parseObject((String)responseString);
            logger.error("doSignApiRequest error:" + errorResponse.getString("errorMsg"));
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"\u4e91\u7aef\u5730\u5740\u548c\u4e91\u7aef\u8d26\u5957ID\u4e0d\u5339\u914d\uff0c\u5efa\u8bae\u68c0\u67e5\u4e91\u7aef\u8d26\u5957ID\u662f\u5426\u586b\u5199\u6b63\u786e\u3002", (String)"OpenApiSecurityUtil_0", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        if (responseString.contains("login.loginWrongAccountException")) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"\u4e91\u7aef\u8d26\u5957ID\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"ThirdAppApplyFormPlugin_27", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        if (responseString.contains("<TITLE>Error</TITLE>") && responseString.contains("Access denied")) {
            logger.error("invalid url:" + url + ", the responseString is:" + responseString);
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"\u4e91\u7aef\u5730\u5740\u662f\u975e\u6cd5\u5730\u5740\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ThirdAppApplyFormPlugin_24", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        ResponseSecurityDto result = null;
        try {
            result = (ResponseSecurityDto)JSON.parseObject((String)responseString, (TypeReference)new TypeReference<ResponseSecurityDto<CustomApiResult>>(){}, (Feature[])new Feature[0]);
            timestamp = result.getTimestamp();
            uuid = result.getSignatureNonce();
            signString = result.getSignature();
            result.setSignature(null);
            String signContent = JSON.toJSONString((Object)result);
            String signStr = OpenApiSecurityUtil.signing(appSecret, signContent, uuid, timestamp);
            boolean signCheckResult = signString.equalsIgnoreCase(signStr);
            if (!signCheckResult) {
                logger.error("the post of signString:" + signString + " the signing of string:" + signStr + ", it's not equal.");
                throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "doSignApiRequest the result check sign error.", new Object[0]);
            }
            String dgtlEnvlp = result.getDgtlEnvlp();
            String encryptData = result.getEncryptData();
            if (encryptData != null && dgtlEnvlp != null) {
                String dgtlEnvlpStr = OpenApiSecurityUtil.unSignByPublicKey(dgtlEnvlp, bosPublickBase64Key);
                String decryptData = OpenApiSecurityUtil.decrypt(encryptData, EncryptionEnum.getEncryption((Long)1L), dgtlEnvlpStr);
                if (result.getData() != null) {
                    CustomApiResult customApiResult = (CustomApiResult)result.getData();
                    if (clazz.getSimpleName().equalsIgnoreCase("String")) {
                        customApiResult.setData((Object)decryptData);
                    } else {
                        Object data = JSON.toJavaObject((JSON)JSON.parseObject((String)decryptData), clazz);
                        customApiResult.setData(data);
                    }
                } else if (clazz.getSimpleName().equalsIgnoreCase("String")) {
                    result.setData((Object)CustomApiResult.success((Object)decryptData));
                } else {
                    Object data = JSON.toJavaObject((JSON)JSON.parseObject((String)decryptData), clazz);
                    result.setData((Object)CustomApiResult.success((Object)data));
                }
                result.setEncryptData(null);
                result.setDgtlEnvlp(null);
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "doSignApiRequest receive post error:" + e.getMessage() + " responseString:" + responseString, new Object[]{e});
        }
        return (CustomApiResult)result.getData();
    }

    public static <T, E> CustomApiResult<E> sendSignApiRequest(T dto, String url, Class<E> clazz, String accountId) throws OpenApiException {
        Map<String, String> params = OpenApiSecurityUtil.getConnectParams(accountId);
        return OpenApiSecurityUtil.sendSignApiRequest(dto, url, clazz, accountId, params);
    }

    public static <T, E> CustomApiResult<E> sendSignApiRequest(T dto, String url, Class<E> clazz, String accountId, Map<String, String> params) throws OpenApiException {
        HashMap<String, T> paramsDto = new HashMap<String, T>();
        paramsDto.put(StringUtil.captureName((String)dto.getClass().getSimpleName()), dto);
        String content = JSON.toJSONString(paramsDto);
        return OpenApiSecurityUtil.doSignApiRequest(content, url, clazz, accountId, params);
    }

    private static Map<String, String> getConnectParams(String accountId) {
        String sql = "SELECT fcomkey, fcomvalue, fdesc FROM t_openapi_common where ftype=? and fenable='1' ";
        int type = 2;
        switch (accountId) {
            case "1335527015687654400": {
                type = 2;
                break;
            }
            case "1335512780043717632": {
                type = 3;
                break;
            }
            case "1315295202205190910": {
                type = 4;
                break;
            }
            case "143244152805884929": {
                type = 5;
                break;
            }
            default: {
                type = 2;
            }
        }
        Map result = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{new SqlParameter(":ftype", 4, (Object)type)}, rs -> {
            HashMap<String, String> params = new HashMap<String, String>(3);
            while (rs.next()) {
                String value = rs.getString("fcomvalue");
                if (EncrypterFactory.getEncrypter().isEncrypted(value)) {
                    value = EncrypterFactory.getEncrypter().decode(value);
                }
                params.put(rs.getString("fcomkey"), value);
            }
            return params;
        });
        if (result == null || result.isEmpty()) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "please check security config. ", new Object[0]);
        }
        return result;
    }

    static {
        algorithmMap.put("AES", "AES/GCM/NoPadding");
        algorithmMap.put("SM4", "SM4/GCM/NoPadding");
        CONNECTION_TIMEOUT = Integer.getInteger("httpclient.connectionTimeout", 5000);
        READ_TIMEOUT = Integer.getInteger("httpclient.readTimeout", 8000);
    }
}

