/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.open.res.util;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CacheUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;

public class ResourceClientUtil {
    private static Log logger = LogFactory.getLog(ResourceClientUtil.class);
    public static final String CLIENT_URL = "kapi/v2/open/pub/thirdapply/findThirdAppApply";
    public static final String CACHE_TYPE_RESOURCE_CLIENT = "ResourceClientInfo";

    public static ThirdAppApplyDto findResourceClientInfo() {
        String accountId = RequestContext.get().getAccountId();
        Object thirdApply = CacheUtil.getLocalMemoryCache((String)CACHE_TYPE_RESOURCE_CLIENT, (String)RequestContext.get().getAccountId()).get(accountId);
        if (thirdApply != null) {
            return (ThirdAppApplyDto)thirdApply;
        }
        ThirdAppApplyDto result = ResourceClientUtil.findThirdAppApply(accountId);
        if (result != null) {
            ResourceClientUtil.updateKey(result);
            CacheUtil.getLocalMemoryCache((String)CACHE_TYPE_RESOURCE_CLIENT, (String)RequestContext.get().getAccountId()).put(accountId, (Object)result);
        }
        return result;
    }

    public static Map<String, Object> findResourceClientInfoMap() {
        ThirdAppApplyDto thirdAppApplyDto = ResourceClientUtil.findResourceClientInfo();
        if (thirdAppApplyDto == null) {
            return null;
        }
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)thirdAppApplyDto), Map.class);
    }

    private static ThirdAppApplyDto findThirdAppApply(String accountId) {
        if (StringUtil.isEmpty((String)accountId)) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "the accountId is null.", new Object[0]);
        }
        return (ThirdAppApplyDto)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)"ThirdAppApplyClientService", (String)"findThirdAppApply", (Object[])new Object[]{accountId});
    }

    public static void removeCache(String accountId) {
        if (StringUtil.isNotEmpty((String)accountId)) {
            CacheUtil.getLocalMemoryCache((String)CACHE_TYPE_RESOURCE_CLIENT, (String)RequestContext.get().getAccountId()).remove(new String[]{accountId});
        }
    }

    public static void updateKey(ThirdAppApplyDto thirdAppApplyDto) {
        if (thirdAppApplyDto == null) {
            return;
        }
        if (StringUtil.isNotEmpty((String)thirdAppApplyDto.getPublickey())) {
            thirdAppApplyDto.setPublickey(EncryptUtil.decode((String)thirdAppApplyDto.getPublickey()));
        }
        if (StringUtil.isNotEmpty((String)thirdAppApplyDto.getAccesstoken())) {
            thirdAppApplyDto.setAccesstoken(EncryptUtil.decode((String)thirdAppApplyDto.getAccesstoken()));
        }
        if (StringUtil.isNotEmpty((String)thirdAppApplyDto.getSecretKey())) {
            thirdAppApplyDto.setSecretKey(EncryptUtil.decode((String)thirdAppApplyDto.getSecretKey()));
        }
    }
}

