/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.open.res.plugin.op;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.isc.util.dt.D;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.open.res.plugin.service.ServiceFacetory;
import kd.bos.open.res.util.OpenApiSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;

public class ThirdAppApplySubmitOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(ThirdAppApplySubmitOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("id", "targeturl", "targetaccountid", "thirdcode", "name", "phone", "email", "creator", "publickey", "accesstoken", "version", "instancenumber", "tenantid", "tenantname", "accountid", "accountname", "source", "appilerusername"));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.validate(e);
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] objects = e.getDataEntities();
        String operationKey = e.getOperationKey();
        try {
            if ("submit".equals(operationKey)) {
                Long id = objects[0].getLong("id");
                if (id == null || id == 0L) {
                    throw new KDBizException(new ErrorCode(ApiErrorCode.Data_Invalid.getStatusCode(), ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u540e\u518d\u63d0\u4ea4\u3002", (String)"ThirdAppApplySubmitOpPlugin_9", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0])), new Object[0]);
                }
                this.submit(objects[0]);
            }
        }
        catch (OpenApiException ex) {
            throw new KDBizException(ex.getErrorCode(), new Object[]{ex.getMessage(), ResSystemType.PUB_FORM_PLUGIN.getType()});
        }
    }

    private void submit(DynamicObject obj) {
        String url = this.getServerUrl(obj);
        ThirdAppApplyDto thirdAppApplyDto = new ThirdAppApplyDto();
        thirdAppApplyDto.setThirdcode(obj.getString("thirdcode"));
        thirdAppApplyDto.setId(Long.valueOf(obj.getLong("id")));
        thirdAppApplyDto.setTargeturl(obj.getString("targeturl"));
        thirdAppApplyDto.setTargetaccountid(obj.getString("targetaccountid"));
        thirdAppApplyDto.setName(obj.getString("name"));
        thirdAppApplyDto.setPhone(obj.getString("phone"));
        thirdAppApplyDto.setEmail(obj.getString("email"));
        thirdAppApplyDto.setPublickey(obj.getString("publickey"));
        thirdAppApplyDto.setAccesstoken(obj.getString("accesstoken"));
        thirdAppApplyDto.setVersion(Integer.valueOf(obj.getInt("version")));
        thirdAppApplyDto.setInstancenumber(obj.getString("instancenumber"));
        thirdAppApplyDto.setTenantid(obj.getString("tenantid"));
        thirdAppApplyDto.setTenantname(obj.getString("tenantname"));
        thirdAppApplyDto.setAccountid(obj.getString("accountid"));
        thirdAppApplyDto.setAccountname(obj.getString("accountname"));
        thirdAppApplyDto.setSource(obj.getString("source"));
        thirdAppApplyDto.setAppilerusername(obj.getString("appilerusername"));
        thirdAppApplyDto.setIsold(ServiceFacetory.getThirdAppApplyService().isThirdAppOldCode(thirdAppApplyDto) ? "1" : "0");
        CustomApiResult result = null;
        result = OpenApiSecurityUtil.sendSignApiRequest((Object)thirdAppApplyDto, (String)url, Map.class, (String)thirdAppApplyDto.getTargetaccountid());
        if (result != null && (ApiErrorCode.Data_Invalid.getStatusCode().equalsIgnoreCase(result.getErrorCode()) || ApiErrorCode.Data_UpdateFail.getStatusCode().equalsIgnoreCase(result.getErrorCode()))) {
            String message = result.getMessage();
            throw new KDBizException(new ErrorCode(result.getErrorCode(), message), new Object[]{result.getErrorCode(), message});
        }
        if (result != null && result.getData() != null && "true".equalsIgnoreCase((String)((Map)result.getData()).get("status"))) {
            return;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bbf\u95ee\u4e91\u7aef\u5730\u5740 %1$s \u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002\u539f\u56e0\uff1a%2$s", (String)"ThirdAppApplySubmitOpPlugin_0", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), url, JSON.toJSONString((Object)result)));
    }

    private String getServerUrl(DynamicObject obj) {
        String domainUrl = D.s((Object)obj.get("targeturl"));
        if (domainUrl == null) {
            domainUrl = System.getProperty("public.resource.server");
        }
        if (domainUrl == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u4e91\u7aef\u5730\u5740\u3002", (String)"ThirdAppApplySubmitOpPlugin_1", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        }
        domainUrl = domainUrl.endsWith("/") ? domainUrl : domainUrl + "/";
        domainUrl = domainUrl + "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/createOrUpdate";
        String serverAccountId = D.s((Object)obj.get("targetaccountid"));
        if (serverAccountId != null) {
            domainUrl = domainUrl + "?accountId=" + serverAccountId;
        }
        return domainUrl;
    }

    private void validate(BeforeOperationArgs e) {
        List dataEntities = e.getValidExtDataEntities();
        if (dataEntities != null && !dataEntities.isEmpty()) {
            if (dataEntities.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u591a\u884c\u3002", (String)"ThirdAppApplySubmitOpPlugin_2", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ThirdAppApplySubmitOpPlugin_3", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        }
    }
}

