/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.open.res.plugin.service.impl;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.isc.util.misc.Hash;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.open.res.model.ThirdAppApplyValidateResultDto;
import kd.bos.open.res.plugin.service.ThirdAppApplyService;
import kd.bos.open.res.util.OpenApiSecurityUtil;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.result.CustomApiResult;

public class ThirdAppApplyServiceImpl
implements ThirdAppApplyService {
    private static Log logger = LogFactory.getLog(ThirdAppApplyServiceImpl.class);

    private String getUrl(String serverUrl, String apiUrl) {
        serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        return serverUrl + apiUrl;
    }

    @Override
    public ThirdAppApplyValidateResultDto checkThirdCodeServerValid(ThirdAppApplyDto thirdAppApplyDto) {
        CustomApiResult result = null;
        String url = this.getUrl(thirdAppApplyDto.getTargeturl(), "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/findThirdCodeExits");
        result = OpenApiSecurityUtil.sendSignApiRequest((Object)thirdAppApplyDto, (String)url, ThirdAppApplyValidateResultDto.class, (String)thirdAppApplyDto.getTargetaccountid());
        if (result != null && result.getData() != null) {
            return (ThirdAppApplyValidateResultDto)result.getData();
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bbf\u95ee\u4e91\u7aef\u5730\u5740 %1$s \u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002\u539f\u56e0\uff1a%2$s", (String)"ThirdAppApplySubmitOpPlugin_0", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), url, JSON.toJSONString((Object)result)));
    }

    @Override
    public boolean checkEmailServerExits(ThirdAppApplyDto thirdAppApplyDto) {
        CustomApiResult result = null;
        String url = this.getUrl(thirdAppApplyDto.getTargeturl(), "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/checkEmailExits");
        result = OpenApiSecurityUtil.sendSignApiRequest((Object)thirdAppApplyDto, (String)url, ThirdAppApplyValidateResultDto.class, (String)thirdAppApplyDto.getTargetaccountid());
        if (result != null && result.getData() != null) {
            if (((ThirdAppApplyValidateResultDto)result.getData()).isEmailResult()) {
                return true;
            }
            throw new KDBizException(((ThirdAppApplyValidateResultDto)result.getData()).getEmailMessage());
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bbf\u95ee\u4e91\u7aef\u5730\u5740 %1$s \u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002\u539f\u56e0\uff1a%2$s", (String)"ThirdAppApplySubmitOpPlugin_0", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), url, JSON.toJSONString((Object)result)));
    }

    @Override
    public ThirdAppApplyDto findThirdApplyServerStatus(ThirdAppApplyDto thirdAppApplyDto) {
        String url = this.getUrl(thirdAppApplyDto.getTargeturl(), "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/findApplyInfo");
        CustomApiResult result = null;
        result = OpenApiSecurityUtil.sendSignApiRequest((Object)thirdAppApplyDto, (String)url, ThirdAppApplyDto.class, (String)thirdAppApplyDto.getTargetaccountid());
        if (result != null && result.isStatus() && result.getData() != null) {
            return (ThirdAppApplyDto)result.getData();
        }
        logger.info("result:" + JSON.toJSONString((Object)result));
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bbf\u95ee\u4e91\u7aef\u5730\u5740 %1$s \u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002\u539f\u56e0\uff1a%2$s", (String)"ThirdAppApplySubmitOpPlugin_0", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), url, JSON.toJSONString((Object)result)));
    }

    @Override
    public boolean isThirdAppOldCode(ThirdAppApplyDto thirdAppApplyDto) {
        String randString = Hash.mur2digital32((Object[])new Object[]{thirdAppApplyDto.getTenantid() + ',' + thirdAppApplyDto.getAccountid()});
        String thirdcode = "KDRS_" + randString;
        return thirdcode.equalsIgnoreCase(thirdAppApplyDto.getThirdcode());
    }
}

