/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.opp.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.util.ApiUriModelCacheUtil;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.base.util.LocalCacheUtils;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ApiModelClearCacheOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        AbstractValidator abstractValidator;
        String operateType;
        DynamicObject[] dataEntities = e.getDataEntities();
        List validators = e.getValidators();
        if (CollectionUtil.isNotEmpty((Collection)validators) && "delete".equals(operateType = (abstractValidator = (AbstractValidator)validators.get(0)).getOperateType()) && dataEntities != null) {
            for (DynamicObject dataEntity : dataEntities) {
                this.removeApiDependences(dataEntity.getString("id"));
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        if (CollectionUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            LocalCacheUtil.clear(OpenApiData.class);
            LocalCacheUtil.clear((String)"apiserviceId");
            ArrayList<Long> idList = new ArrayList<Long>(dataEntities.length);
            for (Object entity : dataEntities) {
                idList.add(entity.getLong("id"));
            }
            QFilter qFilter = new QFilter("id", "in", idList);
            DynamicObject[] apps = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)"urlformat", (QFilter[])qFilter.toArray());
            if (apps != null && apps.length > 0) {
                for (DynamicObject dy : apps) {
                    ApiUriModelCacheUtil.removeApiModelCache((String)dy.getString("urlformat"));
                    ApilAclManager.removeApiAclModel((String)dy.getString("urlformat"));
                }
            }
        } else if ("save".equals(operationKey)) {
            boolean isChangeAllowGuest = false;
            for (Object entity : dataEntities) {
                Iterable props = entity.getDataEntityState().getBizChangedProperties();
                for (IDataEntityProperty prop : props) {
                    if (!prop.getName().equals("allowguest")) continue;
                    isChangeAllowGuest = true;
                    break;
                }
                LocalCacheUtil.clear((String)("ApiObjectFieldName_" + entity.getLong("id")));
                long id = entity.getLong("id");
                DynamicObject api = QueryServiceHelper.queryOne((String)"openapi_apilist", (String)"urlformat", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
                if (api == null) continue;
                String dburl = api.getString("urlformat");
                if (entity.getString("urlformat").equals(dburl)) continue;
                ApiUriModelCacheUtil.removeApiModelCache((String)dburl);
                ApilAclManager.removeApiAclModel((String)dburl);
            }
            if (isChangeAllowGuest) {
                LocalCacheUtils.remove((String)RequestContext.get().getAccountId());
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block4: {
            String operationKey;
            Object[] dataEntities;
            block3: {
                super.endOperationTransaction(e);
                dataEntities = e.getDataEntities();
                if (CollectionUtil.isEmpty((Object[])dataEntities)) {
                    return;
                }
                operationKey = e.getOperationKey();
                if (!"save".equals(operationKey)) break block3;
                for (Object entity : dataEntities) {
                    ApiUriModelCacheUtil.removeApiModelCache((String)entity.getString("urlformat"));
                    ApilAclManager.removeApiAclModel((String)entity.getString("urlformat"));
                    ApiUriModelCacheUtil.removeAndSetApiUriModelCache((String)entity.getString("id"), (String)entity.getString("urlformat"));
                }
                break block4;
            }
            if (!"delete".equals(operationKey)) break block4;
            for (Object entity : dataEntities) {
                ApiUriModelCacheUtil.removeApiUriModelCache((String)entity.getString("id"));
            }
        }
    }

    private void removeApiDependences(String id) {
        long apiId = DataUtil.l((Object)id);
        if (apiId <= 0L) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                String sql = "DELETE from t_open_3rdappsapis where fapiserviceid=?";
                Object[] params = new SqlParameter[]{new SqlParameter(":Fapiserviceid", -5, (Object)apiId)};
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
                sql = "DELETE from t_open_3rdapps_encryptapi where fapiid=?";
                params[0] = new SqlParameter(":Fapiid", -5, (Object)apiId);
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
                sql = "Update t_openapi_statdata_sum set fapiid= ? where ftype<=2 and fapiid = ?";
                Object[] paramsForStatdata = new SqlParameter[]{new SqlParameter(":Fapiid", -5, (Object)(-apiId)), new SqlParameter(":Fapiid", -5, (Object)apiId)};
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])paramsForStatdata);
                sql = "DELETE from t_open_rule_config_detail where fapiid=?";
                params[0] = new SqlParameter(":Fapiid", -5, (Object)apiId);
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
                sql = "DELETE from t_openapi_callback where fapiid=?";
                params[0] = new SqlParameter(":Fapiid", -5, (Object)apiId);
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            }
            catch (Exception e) {
                handle.markRollback();
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{ApiConstant.OPERATIONFALSEMESSAGE.concat("\uff1a") + e.getMessage()});
            }
        }
    }
}

