/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.auth.AuthFilterManager;
import kd.bos.auth.filter.HandleResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.service.authorize.auth.ApiAuthorizeService;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthResult;

public class ApiAuthorizeServiceImpl
implements ApiAuthorizeService {
    private static final Log log = LogFactory.getLog(ApiAuthorizeServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiCommonResult<AuthResult> auth(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        log.info("ApiAuthorizeServiceImpl start.");
        try {
            OpenApiAuthContext context = OpenApiAuthContext.getInstance(request, response);
            HandleResult<ApiCommonResult> resultApiCommonResult = AuthFilterManager.executeAuthFilter(request, response, filterChain);
            log.info("ApiAuthorizeServiceImpl end.");
            ApiCommonResult apiCommonResult = resultApiCommonResult.getData();
            return apiCommonResult;
        }
        finally {
            OpenApiAuthContext.close();
        }
    }

    public boolean isEnhanceToken(String thirdAppNumber, String accountId) {
        if (StringUtil.isEmpty((String)thirdAppNumber)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "thirdAppNumber is null.", new Object[0]);
        }
        Open3rdappsDto open3rdappsDto = null;
        try {
            open3rdappsDto = OpenApiServiceManager.getOpenApiAuthService().getThirdAppDtoByNum(thirdAppNumber, accountId);
        }
        catch (OpenApiException e) {
            log.error("isEnhanceToken error:" + e.getMessage(), (Throwable)e);
            return false;
        }
        if (open3rdappsDto == null) {
            return false;
        }
        return open3rdappsDto.isEnhanceToken();
    }
}

