/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth;

import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.auth.filter.AuthFilter;
import kd.bos.auth.filter.HandleResult;
import kd.bos.auth.filter.impl.BasicAuthFilter;
import kd.bos.auth.filter.impl.DigestAuthFilter;
import kd.bos.auth.filter.impl.OAuth2Filter;
import kd.bos.auth.filter.impl.OpenAuthExtendFilter;
import kd.bos.auth.filter.impl.SignAuthFilter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.service.authorize.model.ApiCommonResult;

public class AuthFilterManager {
    private static final Log log = LogFactory.getLog(AuthFilterManager.class);
    private static ArrayList<AuthFilter> filterList = new ArrayList();

    public static void register(AuthFilter handleFilter) {
        if (handleFilter != null) {
            filterList.add(handleFilter);
        }
    }

    public static HandleResult<ApiCommonResult> executeAuthFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        HandleResult<ApiCommonResult> resultHandleResult = AuthFilterManager.executeSystemAuthFilter(request, response, filterChain);
        return resultHandleResult;
    }

    private static HandleResult<ApiCommonResult> executeSystemAuthFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        HandleResult<ApiCommonResult> result = HandleResult.getHandleResult(null);
        if (CollectionUtil.isEmpty(filterList)) {
            result.setHandled(false);
            return result;
        }
        boolean isHandled = false;
        ApiCommonResult handleApiCommonResult = null;
        for (AuthFilter authFilter : filterList) {
            HandleResult<ApiCommonResult> filterResult = authFilter.doFilter(request, response);
            handleApiCommonResult = filterResult.getData();
            if (!filterResult.isHandled()) continue;
            isHandled = true;
            break;
        }
        if (!isHandled) {
            handleApiCommonResult = ApiCommonResult.getFailResult((String)"905", (String)ResManager.loadKDString((String)"\u65e7\u8ba4\u8bc1\u3002", (String)"OAuth2Filter_1", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]));
        }
        result.setHandled(isHandled);
        result.setData(handleApiCommonResult);
        return result;
    }

    static {
        AuthFilterManager.register(new OAuth2Filter());
        AuthFilterManager.register(new DigestAuthFilter());
        AuthFilterManager.register(new SignAuthFilter());
        AuthFilterManager.register(new BasicAuthFilter());
        AuthFilterManager.register(new OpenAuthExtendFilter());
    }
}

