/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth.filter.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.auth.filter.AuthFilter;
import kd.bos.auth.filter.HandleResult;
import kd.bos.auth.filter.impl.AbstractCommonFilter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.krpc.common.URL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.result.ResultProcessUtil;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.kcf.utils.ApiAuthLogUtil;
import kd.bos.openapi.kcf.utils.OpenApiExceptionUtil;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.AuthTypeEnum;
import kd.bos.service.authorize.model.SignInfo;

public class DigestAuthFilter
extends AbstractCommonFilter
implements AuthFilter {
    private static final Log log = LogFactory.getLog(DigestAuthFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleResult<ApiCommonResult> doFilter(HttpServletRequest request, HttpServletResponse response) {
        long timeST = System.currentTimeMillis();
        String authUrl = ApiDataUtil.getApiUrl((HttpServletRequest)request);
        try {
            Object userType;
            String authType = OpenApiAuthContext.getContext().getAuthType();
            if (StringUtil.isNotEmpty((String)authType) && !"2".equalsIgnoreCase(authType)) {
                HandleResult<ApiCommonResult> result = HandleResult.getHandleResult(null);
                result.setHandled(false);
                HandleResult<ApiCommonResult> handleResult = result;
                return handleResult;
            }
            String requestMethod = request.getMethod();
            String requestURI = request.getRequestURI();
            String appId = OpenApiAuthContext.getContext().getHeaders().get("appid");
            String signature = OpenApiAuthContext.getContext().getHeaders().get("signature");
            String getSigature = OpenApiAuthContext.getContext().getQueryMap().get("signature");
            String datetimeString = OpenApiAuthContext.getContext().getHeaders().get("timestamp");
            String signatureNonce = OpenApiAuthContext.getContext().getHeaders().get("signaturenonce");
            boolean isDigestAuthValid = false;
            String content = "";
            String tenantId = OpenApiAuthContext.getContext().getCurrentCenter().getTenantId();
            AuthInfo authInfo = null;
            Account currentCenter = OpenApiAuthContext.getContext().getCurrentCenter();
            if ("2".equalsIgnoreCase(authType)) {
                String accessKey = this.getBasicAuthParamsByRequest(requestURI, "openapisign");
                if (!EncryptUtil.isBase64((String)accessKey)) {
                    throw new OpenApiException(ApiErrorCode.LOGIN_BIZ_ERROR, String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff1a%1$s", (String)"DigestFilter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), "accessKey is invalid"), new Object[0]);
                }
                Map<String, String> mapinfo = this.getAccountIdAndSignCode(accessKey);
                String signCode = mapinfo.get("signCode");
                String accountId = mapinfo.get("accountId");
                currentCenter = AccountUtils.getAccountById((String)accountId);
                if (currentCenter == null) {
                    throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u9519\u8bef\u3002", (String)"DigestFilter_1", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                }
                if (!EncryptUtil.isBase64((String)signCode)) {
                    throw new OpenApiException(ApiErrorCode.LOGIN_BIZ_ERROR, String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7\u3002%1$s", (String)"DigestFilter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), "signCode is invalid"), new Object[0]);
                }
                authInfo = AuthInfo.of((String)authType, (String)signCode, (String)currentCenter.getAccountId());
                authInfo.setUrl(requestURI.substring(request.getContextPath().length()));
                authInfo.setCommonAuth(true);
                if ("POST".equalsIgnoreCase(requestMethod)) {
                    if (!"application/json".equalsIgnoreCase(request.getContentType())) {
                        throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u8bf7\u6c42header\u7684ContentType\u9700\u8981\u8bbe\u7f6e\u4e3aapplication/json\u3002", (String)"DigestFilter_0", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                    }
                    content = OpenApiAuthContext.getContext().getBody().trim();
                    isDigestAuthValid = true;
                } else if ("GET".equalsIgnoreCase(requestMethod) && StringUtils.isNotEmpty((CharSequence)getSigature)) {
                    signature = getSigature;
                    datetimeString = URL.decode((String)OpenApiAuthContext.getContext().getQueryMap().get("timestamp"));
                    signatureNonce = OpenApiAuthContext.getContext().getQueryMap().get("signaturenonce");
                    String parameters = OpenApiAuthContext.getContext().getQueryMap().get("parameters");
                    signature = getSigature;
                    if (StringUtils.isEmpty((CharSequence)parameters)) {
                        throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u7f3a\u5c11parameters\u53c2\u6570\u3002", (String)"DigestFilter_3", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                    }
                    content = this.getRequestGetParams(parameters, request);
                    isDigestAuthValid = true;
                }
            } else {
                authInfo = AuthInfo.of((String)AuthTypeEnum.AUTH_DIGEST.getId(), (String)"", (String)currentCenter.getAccountId());
                authInfo.setCommonAuth(false);
                if ("POST".equalsIgnoreCase(requestMethod) && StringUtil.isNotEmpty((String)signature) && StringUtil.isNotEmpty((String)appId)) {
                    String language;
                    if (!"application/json".equalsIgnoreCase(request.getContentType())) {
                        throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u8bf7\u6c42header\u7684ContentType\u9700\u8981\u8bbe\u7f6e\u4e3aapplication/json\u3002", (String)"DigestFilter_0", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                    }
                    if (StringUtil.isEmpty((String)OpenApiAuthContext.getContext().getHeaders().get("user"))) {
                        throw new OpenApiException(ApiErrorCode.LOGIN_BIZ_ERROR, ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DigestFilter_8", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                    }
                    String userType2 = OpenApiAuthContext.getContext().getHeaders().get("usertype");
                    authInfo.setUser(OpenApiAuthContext.getContext().getHeaders().get("user"));
                    authInfo.setUserType(userType2);
                    content = OpenApiAuthContext.getContext().getBody();
                    String string = language = OpenApiAuthContext.getContext().getLang() != null ? OpenApiAuthContext.getContext().getLang().toString() : "";
                    if (StringUtil.isEmpty((String)language)) {
                        language = OpenApiAuthContext.getContext().getContextMap().get("language") != null ? (String)OpenApiAuthContext.getContext().getContextMap().get("language") : "";
                    }
                    authInfo.setLanguage(language);
                    isDigestAuthValid = true;
                } else if ("GET".equalsIgnoreCase(requestMethod) && StringUtils.isNotEmpty((CharSequence)getSigature)) {
                    String language;
                    appId = OpenApiAuthContext.getContext().getQueryMap().get("appid");
                    if (StringUtils.isEmpty((CharSequence)appId)) {
                        throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002", (String)"DigestFilter_11", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                    }
                    datetimeString = URL.decode((String)OpenApiAuthContext.getContext().getQueryMap().get("timestamp"));
                    signatureNonce = OpenApiAuthContext.getContext().getQueryMap().get("signaturenonce");
                    String parameters = OpenApiAuthContext.getContext().getQueryMap().get("parameters");
                    signature = getSigature;
                    if (StringUtils.isEmpty((CharSequence)parameters)) {
                        throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u6458\u8981\u8ba4\u8bc1\u7f3a\u5c11\u53c2\u6570:%1$s\u3002", (String)"DigestFilter_4", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[]{"parameters"});
                    }
                    if (StringUtil.isEmpty((String)OpenApiAuthContext.getContext().getQueryMap().get("user"))) {
                        throw new OpenApiException(ApiErrorCode.LOGIN_BIZ_ERROR, ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DigestFilter_8", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                    }
                    userType = OpenApiAuthContext.getContext().getQueryMap().get("usertype");
                    authInfo.setUser(OpenApiAuthContext.getContext().getQueryMap().get("user"));
                    authInfo.setUserType((String)userType);
                    String string = language = OpenApiAuthContext.getContext().getLang() != null ? OpenApiAuthContext.getContext().getLang().toString() : "";
                    if (StringUtil.isEmpty((String)language)) {
                        language = OpenApiAuthContext.getContext().getQueryMap().get("language");
                    }
                    authInfo.setLanguage(language);
                    isDigestAuthValid = true;
                    content = this.getRequestGetParams(parameters, request);
                }
            }
            if (!isDigestAuthValid) {
                HandleResult<ApiCommonResult> result = HandleResult.getHandleResult(null);
                result.setHandled(false);
                userType = result;
                return userType;
            }
            authInfo.setThirdAppNumber(appId);
            SignInfo signInfo = SignInfo.of((String)appId, (String)currentCenter.getAccountId(), (String)tenantId);
            signInfo.setDateTime(datetimeString);
            signInfo.setContent(content);
            signInfo.setSignatureNonce(signatureNonce);
            signInfo.setSignature(signature);
            signInfo.setAuthType(AuthTypeEnum.AUTH_DIGEST.getId());
            authInfo.setAuthType(AuthTypeEnum.AUTH_DIGEST.getId());
            authInfo.setSignInfo(signInfo);
            AuthResult authResult = OpenApiServiceManager.getOpenApiAuthService().auth(authInfo);
            boolean isPass = authResult.isStatus();
            if (!isPass) {
                if ("invalidAppId".equalsIgnoreCase(authResult.getMessage())) {
                    throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u4e0d\u6b63\u786e\u7684\u7b2c\u4e09\u65b9appId\u6216\u540e\u53f0key\u6ca1\u6709\u914d\u7f6e\u3002", (String)"DigestFilter_5", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                }
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7:%1$s", (String)"DigestFilter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), authResult.getMessage()), new Object[0]);
            }
            ApiCommonResult resultApiCommonResult = ApiCommonResult.getSuccessResult((String)"0", (String)ResManager.loadKDString((String)"\u6458\u8981\u8ba4\u8bc1\u901a\u8fc7\u3002", (String)"DigestFilter_7", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]));
            resultApiCommonResult.setData((Object)authResult);
            ((AuthResult)resultApiCommonResult.getData()).setAccountId(currentCenter.getAccountId());
            if (McConfigUtil.isSecurityLogOpen((String)RequestContext.get().getTenantId())) {
                log.info("DigestAuth pass.");
            }
            HandleResult<ApiCommonResult> handleResult = HandleResult.getHandleResult(resultApiCommonResult);
            return handleResult;
        }
        catch (Throwable e2) {
            OpenApiException e2;
            String msg = "----DigestAuth OpenApi Auth Failed. error:" + e2.getMessage();
            log.error(msg, e2);
            if (e2 instanceof OpenApiException) {
                OpenApiException openApiException = (OpenApiException)e2;
                if (ApiErrorCode.Data_Invalid.getStatusCode().equals(openApiException.getCode())) {
                    e2 = new OpenApiException(e2, ApiErrorCode.HTTP_BAD_REQUEST, e2.getMessage(), new Object[0]);
                }
            }
            ApiCommonResult result = ApiCommonResult.getFailResult((String)ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), (String)msg);
            OpenApiExceptionUtil.handleAuthException(e2, response, result);
            ResultProcessUtil.processAuthResult(request, response, result, true);
            HandleResult<ApiCommonResult> handleResult = HandleResult.getHandleResult(result);
            return handleResult;
        }
        finally {
            int timeCost = (int)(System.currentTimeMillis() - timeST);
            if (OpenApiAuthContext.getContext().isParamErrorCode()) {
                ApiAuthLogUtil.writeAuthApiLog(authUrl, timeCost);
            }
        }
    }

    private String getRequestGetParams(String parameters2, HttpServletRequest request) {
        String parameters = request.getParameter("parameters");
        if (StringUtil.isEmpty((String)parameters)) {
            parameters = "";
        }
        String[] parameterArray = parameters.split(",");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int j = 0;
        while (i < parameterArray.length) {
            String key = parameterArray[i];
            Object[] values = request.getParameterValues(key);
            if (CollectionUtil.isNotEmpty((Object[])values)) {
                for (Object value : values) {
                    value = StringUtil.getStringValue((Object)value);
                    if (j == 0) {
                        sb.append(parameterArray[i]).append("=").append((String)value);
                    } else {
                        sb.append("&").append(parameterArray[i]).append("=").append((String)value);
                    }
                    ++j;
                }
            }
            ++i;
            ++j;
        }
        return sb.toString();
    }
}

