/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth.filter.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.auth.filter.AuthFilter;
import kd.bos.auth.filter.HandleResult;
import kd.bos.auth.filter.impl.AbstractCommonFilter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.result.ResultProcessUtil;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.kcf.utils.ApiAuthLogUtil;
import kd.bos.openapi.kcf.utils.OpenApiExceptionUtil;
import kd.bos.service.authorize.http.KDSignHttpServletRequestWrapper;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.SignInfo;

public class SignAuthFilter
extends AbstractCommonFilter
implements AuthFilter {
    private static final Log log = LogFactory.getLog(SignAuthFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleResult<ApiCommonResult> doFilter(HttpServletRequest request, HttpServletResponse response) {
        long timeST = System.currentTimeMillis();
        String authUrl = ApiDataUtil.getApiUrl((HttpServletRequest)request);
        try {
            String authType = OpenApiAuthContext.getContext().getAuthType();
            String requestURI = request.getRequestURI();
            if (!"5".equalsIgnoreCase(authType)) {
                HandleResult<ApiCommonResult> result = HandleResult.getHandleResult(null);
                result.setHandled(false);
                HandleResult<ApiCommonResult> handleResult = result;
                return handleResult;
            }
            String accessKey = this.getBasicAuthParamsByRequest(requestURI, "openapisign");
            if (!EncryptUtil.isBase64((String)accessKey)) {
                throw new OpenApiException(ApiErrorCode.LOGIN_BIZ_ERROR, String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7\u3002%1$s", (String)"DigestFilter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), "accessKey is invalid"), new Object[0]);
            }
            Map<String, String> mapinfo = this.getAccountIdAndSignCode(accessKey);
            String signCode = mapinfo.get("signCode");
            if (!EncryptUtil.isBase64((String)signCode)) {
                throw new OpenApiException(ApiErrorCode.LOGIN_BIZ_ERROR, String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7\u3002%1$s", (String)"DigestFilter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), "signCode is invalid"), new Object[0]);
            }
            String accountId = mapinfo.get("accountId");
            Account currentCenter = AccountUtils.getAccountById((String)accountId);
            if (currentCenter == null) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u9519\u8bef\u3002", (String)"DigestFilter_1", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
            }
            AuthInfo authInfo = AuthInfo.of((String)authType, (String)signCode, (String)accountId);
            SignInfo signInfo = new SignInfo();
            signInfo.setContent(OpenApiAuthContext.getContext().getBody());
            authInfo.setSignInfo(signInfo);
            authInfo.setSense(this.getParamsFromHeaderAndQuery("sense"));
            authInfo.setAuthType("5");
            authInfo.setUrl(requestURI.substring(request.getContextPath().length()));
            authInfo.setCommonAuth(true);
            AuthResult authResult = OpenApiServiceManager.getOpenApiAuthService().auth(authInfo);
            if (!authResult.isStatus()) {
                throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7\u3002%1$s", (String)"DigestFilter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), authResult.getMessage()), new Object[0]);
            }
            KDSignHttpServletRequestWrapper requestWrapper = (KDSignHttpServletRequestWrapper)request;
            requestWrapper.setBody(authResult.getData().getBytes("UTF-8"));
            ApiCommonResult resultApiCommonResult = ApiCommonResult.getSuccessResult((String)"0", (String)ResManager.loadKDString((String)"\u7b7e\u540d\u8ba4\u8bc1\u901a\u8fc7\u3002", (String)"SignAuthFilter_0", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]));
            resultApiCommonResult.setData((Object)authResult);
            ((AuthResult)resultApiCommonResult.getData()).setAccountId(accountId);
            if (McConfigUtil.isSecurityLogOpen((String)RequestContext.get().getTenantId())) {
                log.info("SignAuth pass.");
            }
            HandleResult<ApiCommonResult> handleResult = HandleResult.getHandleResult(resultApiCommonResult);
            return handleResult;
        }
        catch (Throwable e) {
            String msg = "----SignAuth OpenApi Auth Failed. error:" + e.getMessage();
            log.error(msg, e);
            ApiCommonResult result = ApiCommonResult.getFailResult((String)ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), (String)msg);
            OpenApiExceptionUtil.handleAuthException(e, response, result);
            ResultProcessUtil.processAuthResult(request, response, result);
            HandleResult<ApiCommonResult> handleResult = HandleResult.getHandleResult(result);
            return handleResult;
        }
        finally {
            int timeCost = (int)(System.currentTimeMillis() - timeST);
            if (OpenApiAuthContext.getContext().isParamErrorCode()) {
                ApiAuthLogUtil.writeAuthApiLog(authUrl, timeCost);
            }
        }
    }
}

