/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf.message;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import kd.bos.kcf.KCFException;
import kd.bos.kcf.WebApiLog;
import kd.bos.kcf.message.FormatType;
import kd.bos.kcf.message.ResultMessage;
import kd.bos.kcf.serializor.Serializer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.resource.Resources;

public interface HttpWriter {
    public static final Log log = LogFactory.getLog(HttpWriter.class);

    public static HttpWriter build(ServletOutputStream outputStream, FormatType formatType, boolean isSerialized) {
        if (isSerialized) {
            if (formatType == FormatType.Json) {
                return new JsonStringHttpWriter(outputStream);
            }
            JsonStringHttpWriter writer = new JsonStringHttpWriter(outputStream);
            return writer;
        }
        return new InternalHttpWriter(outputStream, formatType);
    }

    public void output(ResultMessage var1);

    public void append(String var1);

    public void flush();

    public void close();

    public static class JsonStringHttpWriter
    implements HttpWriter {
        private OutputStreamWriter writer;

        public JsonStringHttpWriter(ServletOutputStream outputStream) {
            try {
                this.writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Throwable)e);
            }
        }

        @Override
        public void output(ResultMessage result) {
            this.writeString(result.toJsonString());
        }

        private void writeString(String content) {
            try {
                WebApiLog.respContentWriteLog(content);
                this.writer.write(content);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }

        @Override
        public void append(String text) {
            this.writeString(text);
        }

        @Override
        public void flush() {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }

        @Override
        public void close() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    public static class InternalHttpWriter
    implements HttpWriter {
        private Serializer ser;
        private ServletOutputStream outputStream;

        public InternalHttpWriter(ServletOutputStream outputStream, FormatType formatType) {
            this.outputStream = outputStream;
            this.ser = Serializer.create(formatType);
        }

        @Override
        public void output(ResultMessage result) {
            this.ser.Serialize((OutputStream)this.outputStream, result);
        }

        @Override
        public void append(String item) {
            throw KCFException.InternalFmtEx(Resources.getString((String)"\u4e0d\u652f\u6301append\u65b9\u5f0f", (String)"HttpWriter_1", (String)"bos-dispatcher", (Object[])new Object[0]), new Object[0]);
        }

        @Override
        public void flush() {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }

        @Override
        public void close() {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }
}

