/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf.message;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import kd.bos.exception.KDException;
import kd.bos.kcf.KCFException;
import kd.bos.kcf.WebApiLog;
import kd.bos.kcf.message.FormatType;
import kd.bos.kcf.message.HttpMethod;
import kd.bos.kcf.message.KMessage;
import kd.bos.kcf.message.KRequest;
import kd.bos.kcf.message.MessageWriter;
import kd.bos.kcf.message.ResultMessage;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.util.resource.Resources;

public class KResponse
extends KMessage {
    private Log log = LogFactory.getLog(KMessage.class);
    private boolean ended = false;
    private HttpServletResponse response;
    private MessageWriter writer = null;

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public KResponse(HttpServletResponse resp, KRequest kreq) {
        this.response = resp;
        this.response.setBufferSize(65536);
        this.setEncodeType(kreq.getEncodeType());
        if (HttpMethod.Get == kreq.getMethod()) {
            this.setFormatType(FormatType.Json);
        } else if (!kreq.getReader().read().isEmpty()) {
            this.setFormatType(FormatType.Json);
        } else {
            this.setFormatType(kreq.getFormatType());
        }
        resp.setCharacterEncoding("UTF-8");
        this.setResponseContentType();
        this.setEncryptType(kreq.getEncryptType());
        this.setCORS(kreq);
        WebApiLog.respHeadersWriteLog(resp);
    }

    private void setCORS(KRequest kreq) {
        List<String> api_allow_origins;
        String reqOrigin = kreq.getOriginalHeader("Origin");
        if (reqOrigin == null || reqOrigin.isEmpty()) {
            return;
        }
        String api_allow_cors = System.getProperty("api.allow.cors");
        if (api_allow_cors != null && "false".equals(api_allow_cors)) {
            return;
        }
        String Access_Control_Allow_Origin = "*";
        String api_allow_origin = System.getProperty("api.allow.origin");
        if (api_allow_origin != null && (api_allow_origins = Arrays.asList(api_allow_origin.split(","))).contains(reqOrigin)) {
            Access_Control_Allow_Origin = reqOrigin;
        }
        this.response.setHeader("Access-Control-Allow-Origin", StringUtil.replaceInvalidString((String)Access_Control_Allow_Origin));
    }

    private MessageWriter getWriter() {
        if (this.writer == null) {
            this.setSerialized(true);
        }
        return this.writer;
    }

    public void setSerialized(boolean isSerialized) {
        try {
            if (this.writer == null) {
                this.writer = new MessageWriter(this.response.getOutputStream(), this.getFormatType(), isSerialized);
            } else {
                this.fail(Resources.getString((String)"\u5728\u540c\u4e00\u6b21\u8bf7\u6c42\u5185\uff0c\u53ea\u80fd\u8bbe\u7f6e\u4e00\u6b21\u662f\u5426\u5e8f\u5217\u5316", (String)"KResponse_0", (String)"bos-dispatcher", (Object[])new Object[0]));
            }
        }
        catch (IOException e) {
            this.unhanldeError(e);
        }
    }

    private void setResponseContentType() {
        FormatType fmt = this.getFormatType();
        if (fmt == FormatType.Json) {
            this.response.setContentType(KMessage.getContentTypeJson());
        } else if (fmt == FormatType.XML) {
            this.response.setContentType("application/xml");
        } else {
            this.response.setContentType("text/plain");
        }
    }

    public void setStatusCode(int status) {
        this.response.setStatus(status);
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    void output(ResultMessage result) {
        this.getWriter().output(result);
    }

    public void append(String text) {
        this.getWriter().append(text);
    }

    public void success(Object data, boolean serialized) {
        ResultMessage result = ResultMessage.success(data, serialized, "success");
        this.output(result);
    }

    public void success(Object data) {
        this.success(data, "success");
    }

    public void success(Object data, String errorCode) {
        ResultMessage result = ResultMessage.success(data, errorCode);
        this.output(result);
    }

    public void fail(String message) {
        this.fail(message, "fail");
    }

    public void fail(String message, String errorCode) {
        this.response.resetBuffer();
        ResultMessage result = ResultMessage.fail(message, errorCode);
        this.output(result);
    }

    public void error(KDException ex) {
        this.error(KCFException.InternalEx(ex.getMessage(), (Throwable)ex));
    }

    public void error(KCFException ex) {
        this.error(ex, "fail");
    }

    public void error(KCFException ex, String errorCode) {
        this.response.resetBuffer();
        ResultMessage result = ResultMessage.ex(ex, errorCode);
        this.output(result);
    }

    public void unhanldeError(Throwable ex) {
        KCFException ex2 = KCFException.InternalEx(Resources.getString((String)"\u672a\u5904\u7406\u7684\u5f02\u5e38", (String)"KResponse_1", (String)"bos-dispatcher", (Object[])new Object[0]), ex);
        this.error(ex2, "fail");
    }

    public void report(int percent, String message) {
    }

    public void end() {
        if (!this.ended) {
            this.ended = true;
            if (this.writer != null) {
                this.writer.close();
            }
            try {
                this.response.flushBuffer();
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        }
    }
}

