/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.kcf.KCFException;
import kd.bos.kcf.ServiceContext;
import kd.bos.kcf.ServiceType;
import kd.bos.kcf.router.RouteRule;
import kd.bos.openapi.common.constant.ApiServiceType;

public class KCFRouter {
    private static List<RouteRule> route_paths = new ArrayList<RouteRule>();

    public static ServiceType routeTo(ServiceContext ctx) {
        String url = ctx.getRequest().getRelativeUrl();
        for (RouteRule router : route_paths) {
            if (!router.matchedUrl(url)) continue;
            Map<String, String> vars = router.extractVars(url);
            ctx.putEnvVars(vars);
            return router.getInstance(ctx.getConfig());
        }
        throw KCFException.InternalFmtEx(String.format("404 - Cannot found OpenAPI(or disabled), url:%s", url), new Object[0]);
    }

    public static Map<String, String> getParams(String url) {
        for (RouteRule router : route_paths) {
            if (!router.matchedUrl(url)) continue;
            Map<String, String> vars = router.extractVars(url);
            if (router.getServiceClass().getName().equalsIgnoreCase("kd.bos.web.api.ApiServiceType")) {
                vars.put("apiservicetype", ApiServiceType.OPERATION.name());
            } else if (router.getServiceClass().getName().equalsIgnoreCase("kd.bos.web.api.CustomApiServiceType")) {
                vars.put("apiservicetype", ApiServiceType.CUSTOM.name());
            } else if (router.getServiceClass().getName().equalsIgnoreCase("kd.bos.web.api.AIServiceType")) {
                vars.put("apiservicetype", ApiServiceType.AI.name());
            }
            vars.put("urlformat", url);
            return vars;
        }
        throw KCFException.InternalFmtEx(String.format("404 - Cannot found OpenAPI(or disabled), url:%s", url), new Object[0]);
    }

    public static void register(String route_exp, Class<?> clazz, boolean singleton) {
        RouteRule path = new RouteRule();
        path.setExpression(route_exp);
        path.setServiceClass(clazz);
        path.setSingleton(singleton);
        route_paths.add(path);
    }

    public static void register(String regex, Class<?> clazz) {
        KCFRouter.register(regex, clazz, true);
    }
}

