/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.context;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.ParamCaseInsensitiveUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.ParameterHelper;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.kcf.utils.ApiUtil;
import kd.bos.openapi.kcf.utils.OauthTokenUtil;
import kd.bos.openapi.security.model.ApiAuthCustomRequestDto;
import kd.bos.openapi.security.util.ParameterUtil;
import kd.bos.service.authorize.model.AuthTypeEnum;
import kd.bos.util.NetAddressUtils;

public class OpenApiAuthContext {
    private static Log log = LogFactory.getLog(OpenApiAuthContext.class);
    private static final ThreadLocal<OpenApiAuthContext> threadLocal = new ThreadLocal();
    private Map<String, Object> contextMap = new HashMap<String, Object>();
    private List<String> parametersList = new ArrayList<String>();
    private Map<String, String> headers = new HashMap<String, String>();
    @JsonIgnore
    @JSONField(serialize=false)
    private String body;
    private String queryString;
    @JsonIgnore
    @JSONField(serialize=false)
    private HttpServletRequest request;
    @JsonIgnore
    @JSONField(serialize=false)
    private HttpServletResponse response;
    private Lang lang;
    @JsonIgnore
    @JSONField(serialize=false)
    private Account currentCenter;
    private String ip;
    private String tenantId;
    private String authType;
    private Map<String, Object> paramExt = new HashMap<String, Object>();
    private Map<String, String> queryMap = new HashMap<String, String>();
    private Map<String, String> tokenInfo = new HashMap<String, String>();

    public static OpenApiAuthContext getInstance(HttpServletRequest request, HttpServletResponse response) {
        OpenApiAuthContext context = new OpenApiAuthContext(request, response);
        return context;
    }

    private OpenApiAuthContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.initParams();
        threadLocal.set(this);
    }

    private void initParams() {
        String headerLang = this.request.getHeader("Accept-Language");
        this.lang = StringUtil.isNotEmpty((String)headerLang) ? Lang.from((String)headerLang) : Lang.from((String)"zh_CN");
        if (ApiDataUtil.isPathVarUrl((HttpServletRequest)this.request)) {
            this.updatePathVarContent(this.request);
        }
        this.headers = ParameterHelper.getHttpHeadersCaseInsensitive(this.request);
        this.queryString = this.request.getQueryString();
        if (StringUtil.isNotEmpty((String)this.queryString)) {
            this.updateQueryMap(this.queryString);
        }
        this.authType = this.headers.get("openapiauth");
        if (StringUtil.isEmpty((String)this.authType)) {
            this.authType = this.queryMap.get("openapiauth");
        }
        if (StringUtil.isEmpty((String)this.authType)) {
            this.authType = this.contextMap.get("openapiauth") != null ? (String)this.contextMap.get("openapiauth") : null;
        }
        this.tokenInfo = OauthTokenUtil.getTokenInfo(this.headers);
        this.authType = StringUtil.isNotEmpty((String)this.tokenInfo.get("authType")) ? this.tokenInfo.get("authType") : this.authType;
        boolean isGetBody = false;
        String accountId = RequestContext.get().getAccountId();
        String preAccountId = null;
        String authUrl = ApiDataUtil.getApiUrl((HttpServletRequest)this.request);
        if (authUrl.startsWith("/oauth2/")) {
            Object bodyParam;
            isGetBody = true;
            this.updateBodyContent();
            preAccountId = this.getAccountId();
            if (StringUtil.isEmpty((String)preAccountId) && (bodyParam = this.contextMap.get("Request.Arg0")) instanceof Map) {
                Map requestMap = (Map)bodyParam;
                preAccountId = requestMap.get("accountId") != null ? (String)requestMap.get("accountId") : accountId;
            }
        } else {
            isGetBody = "2".equals(this.authType) || "5".equals(this.authType) || "6".equals(this.authType);
            String signature = this.headers.get("signature");
            String getSigature = this.queryMap.get("signature");
            if (StringUtil.isNotEmpty((String)signature) || StringUtil.isNotEmpty((String)getSigature)) {
                isGetBody = true;
            }
            if ("1".equals(this.tokenInfo.get("authType")) && "1".equals(this.tokenInfo.get("isNewTokenAuth"))) {
                preAccountId = OpenApiServiceManager.getOpenApiAuthService().getAccountIdByToken(this.tokenInfo.get("access_token"));
            } else if (AuthTypeEnum.isValid((String)this.authType)) {
                preAccountId = this.getAccountId();
            }
            if (isGetBody) {
                this.updateBodyContent();
            }
        }
        String string = accountId = StringUtil.isNotEmpty((String)preAccountId) ? preAccountId : accountId;
        if (ParameterHelper.isCommmonParameter(this.request)) {
            this.addParamToContextMap(this.request);
        }
        this.ip = NetAddressUtils.getRemoteHost((HttpServletRequest)this.request);
        try {
            this.currentCenter = AccountUtils.getAccountById((String)accountId);
        }
        catch (Exception e) {
            log.error(" getAccountOrDefault error:" + e.getMessage(), (Throwable)e);
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5f02\u5e38 error - %1$s", (String)"OpenApiAuthContext_0", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), e.getMessage()), new Object[]{e});
        }
        if (this.currentCenter == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5f02\u5e38 error - %1$s", (String)"OpenApiAuthContext_0", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), ""), new Object[0]);
        }
        this.tenantId = this.currentCenter.getTenantId();
    }

    public ApiAuthCustomRequestDto createCustomRequestDto() {
        ApiAuthCustomRequestDto dto = new ApiAuthCustomRequestDto(this.headers, this.body, this.queryMap, this.queryString, ApiDataUtil.getApiUrl((HttpServletRequest)this.request));
        dto.setAccountId(this.currentCenter.getAccountId());
        dto.setTenantId(this.tenantId);
        dto.setIp(this.ip);
        Object objRequestBody = this.contextMap.get("Request.Arg0");
        if (objRequestBody instanceof String && StringUtil.isEmpty((String)((String)objRequestBody))) {
            dto.setBodyMap(new HashMap(1));
        } else if (objRequestBody instanceof Map) {
            dto.setBodyMap((Map)this.contextMap.get("Request.Arg0"));
        } else {
            dto.setBodyMap(new HashMap(1));
        }
        return dto;
    }

    private void addParameter(String key, Object value) {
        this.parametersList.add(key);
        this.contextMap.put(key, value);
    }

    private void updatePathVarContent(HttpServletRequest request) {
        Map map;
        String pathStr = ApiDataUtil.getPathVarString((HttpServletRequest)request);
        if (!StringUtil.isEmpty((String)pathStr) && (map = ParameterUtil.getPathVarMap((String)pathStr)) != null) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (ParamCaseInsensitiveUtil.isCaseInsensitiveKey((String)key.toLowerCase(Locale.getDefault()))) {
                    key = key.toLowerCase(Locale.getDefault());
                }
                this.addParameter(key, entry.getValue());
            }
        }
    }

    private void addParamToContextMap(HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String fieldName = (String)paramNames.nextElement();
            Object[] fieldValues = request.getParameterValues(fieldName);
            if (CollectionUtil.isEmpty((Object[])fieldValues)) continue;
            if (fieldValues.length == 1) {
                Object fieldValue = fieldValues[0];
                this.addParameter(fieldName, fieldValue);
                continue;
            }
            this.addParameter(fieldName, fieldValues);
        }
        return;
    }

    private void updateBodyContent() {
        String paraValue;
        String data = this.getBody();
        String string = paraValue = StringUtil.isNotEmpty((String)data) ? this.getJsonData(data) : "";
        if (paraValue != null) {
            this.addParameter("Request.Arg0", paraValue);
        }
    }

    private Object getJsonData(String objValue) {
        Object result = null;
        try {
            String contentType;
            String string = contentType = this.request == null ? "" : this.request.getHeader("Content-Type");
            result = StringUtil.isEmpty((String)contentType) ? JacksonUtil.readValue((String)objValue, Object.class) : (ApiUtil.isContentType("application/json", contentType) ? JacksonUtil.readValue((String)objValue, Object.class) : objValue);
        }
        catch (Exception e) {
            log.error("---------OpenApiAuthContext.getJsonData error:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void updateQueryMap(String queryString) {
        String[] queryStrings;
        if (StringUtil.isNotEmpty((String)queryString) && (queryStrings = this.queryString.split("&")) != null && queryStrings.length > 0) {
            for (String queryStr : queryStrings) {
                if (!StringUtil.isNotEmpty((String)queryStr) || queryStr.length() <= 1 || queryStr.indexOf("=") <= 0) continue;
                String queryKey = queryStr.substring(0, queryStr.indexOf("="));
                String value = queryStr.substring(queryStr.indexOf("=") + 1);
                if (ParamCaseInsensitiveUtil.isCaseInsensitiveKey((String)queryKey.toLowerCase(Locale.ENGLISH))) {
                    queryKey = queryKey.toLowerCase(Locale.ENGLISH);
                }
                this.queryMap.put(queryKey, value);
            }
        }
    }

    private String getAccountId() {
        String accountId = this.headers.get("accountId");
        if (StringUtil.isEmpty((String)accountId)) {
            accountId = this.queryMap.get("accountId");
        }
        return accountId;
    }

    private String getRequestBody(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        StringBuilder bodyStr = new StringBuilder();
        try (BufferedInputStream bis = new BufferedInputStream((InputStream)request.getInputStream());){
            int n;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((n = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, n);
            }
            byte[] input = bos.toByteArray();
            bodyStr.append(new String(input, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("---------OpenApiAuthContext.getBodyContent error:" + e.getMessage(), (Throwable)e);
            bodyStr.append(e.getMessage());
        }
        return bodyStr.toString();
    }

    public String getBody() {
        if (StringUtil.isNotEmpty((String)this.body)) {
            return this.body;
        }
        this.body = this.getRequestBody(this.request);
        return this.body;
    }

    public void addParamExt(String key, Object value) {
        this.paramExt.put(key, value);
    }

    public Object getParamExt(String key) {
        return this.paramExt.get(key);
    }

    public boolean isParamErrorCode() {
        return !this.paramExt.isEmpty() && this.paramExt.get("errorCode") != null;
    }

    public static OpenApiAuthContext getContext() {
        return threadLocal.get();
    }

    public Map<String, String> getQueryMap() {
        return this.queryMap;
    }

    public Map<String, Object> getContextMap() {
        return this.contextMap;
    }

    public List<String> getParametersList() {
        return this.parametersList;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Lang getLang() {
        return this.lang;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Account getCurrentCenter() {
        return this.currentCenter;
    }

    public String getIp() {
        return this.ip;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Map<String, String> getTokenInfo() {
        return this.tokenInfo;
    }

    public String getAuthType() {
        return this.authType;
    }

    public static void close() {
        try {
            OpenApiAuthContext context = OpenApiAuthContext.getContext();
            if (context != null) {
                context.contextMap.clear();
                context.parametersList.clear();
                threadLocal.remove();
                context = null;
            }
        }
        catch (Exception ex) {
            log.error("An error occurred while releasing the OpenApiAuthContext:" + ex.getMessage(), (Throwable)ex);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }
}

