/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.kcf.context.ParameterHelper;
import kd.bos.openapi.kcf.result.StreamData;

public class OpenApiContext {
    private static Log LOGGER = LogFactory.getLog(OpenApiContext.class);
    private static final ThreadLocal<OpenApiContext> threadLocal = new ThreadLocal();
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map<String, Object> contextMap = new HashMap<String, Object>();
    private ArrayList<String> parametersList = new ArrayList();
    private OpenApiResult openApiResult;
    private String url;
    private Throwable exception;
    private int modelTimeCost;
    private OpenApiData openApiData;
    private String inputParameter;
    private String outputParameter;
    private long asyncReqId;
    private Map<String, String> requestHeaders = new HashMap<String, String>(1);

    public OpenApiContext(HttpServletRequest request, HttpServletResponse response, String url) {
        this.request = request;
        this.response = response;
        this.url = url;
        this.openApiResult = new OpenApiResult();
    }

    public static void addParameter(String key, Object value) {
        OpenApiContext context = OpenApiContext.getContext();
        if (context != null) {
            context.parametersList.add(key);
            context.put(key, value);
        }
    }

    public static ArrayList<String> getParameters() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.parametersList : null;
    }

    public static void set(OpenApiContext openApiContext) {
        threadLocal.set(openApiContext);
    }

    public static OpenApiContext getContext() {
        return threadLocal.get();
    }

    public static HttpServletRequest getRequest() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.request : null;
    }

    public static OpenApiResult getResult() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.openApiResult : new OpenApiResult();
    }

    public static HttpServletResponse getResponse() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.response : null;
    }

    public static OpenApiData getOpenApiData() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        OpenApiData openApiData = openApiContext != null ? openApiContext.openApiData : null;
        return openApiData;
    }

    public static void setOpenApiData(OpenApiData openApiData) {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        if (openApiContext != null) {
            openApiContext.openApiData = openApiData;
            OpenApiContext.setRequestHeaders();
        }
    }

    public static Map<String, String> getRequestHeaders() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.requestHeaders : new HashMap(1);
    }

    public static String getRequestHeader(String header) {
        return OpenApiContext.getRequestHeaders().get(header);
    }

    private static void setRequestHeaders() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        if (openApiContext != null) {
            openApiContext.requestHeaders = ParameterHelper.getHttpHeaders(openApiContext.request);
            OpenApiData openApiData = openApiContext.getOpenApiData();
            if (null == openApiData) {
                return;
            }
            Map openApiDefaultHeaders = openApiData.getDefaultHeaders();
            if (openApiDefaultHeaders != null) {
                for (Map.Entry item : openApiDefaultHeaders.entrySet()) {
                    openApiContext.requestHeaders.putIfAbsent((String)item.getKey(), (String)item.getValue());
                }
            }
        }
    }

    public static void setStreamData(StreamData streamData) {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        if (openApiContext != null) {
            openApiContext.put("OpenApi.StreamData", streamData);
        }
    }

    public static StreamData getStreamData() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return (StreamData)(openApiContext != null ? openApiContext.get("OpenApi.StreamData") : null);
    }

    public static Map<String, Object> contextMap() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.contextMap : null;
    }

    public static OpenApiContext setData(String key, Object value) {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        if (openApiContext != null) {
            openApiContext.put(key, value);
        }
        return openApiContext;
    }

    public static Object getData(String key) {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? OpenApiContext.getContext().get(key) : null;
    }

    public static void close() {
        try {
            OpenApiContext openApiContext = OpenApiContext.getContext();
            if (openApiContext != null) {
                openApiContext.contextMap.clear();
                openApiContext.parametersList.clear();
                OpenApiContext.remove();
                openApiContext = null;
            }
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred while releasing the OpenApiContext:" + ex.getMessage(), (Throwable)ex);
        }
    }

    public static String getInputParameter() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.inputParameter : "";
    }

    public static String getOutputParameter() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.outputParameter : "";
    }

    public static void setInputParameter(String inputParameter) {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        if (openApiContext != null) {
            openApiContext.inputParameter = inputParameter;
        }
    }

    public static void setOutputParameter(String outputParameter) {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        if (openApiContext != null) {
            openApiContext.outputParameter = outputParameter;
        }
    }

    public static long getAsyncReqId() {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        return openApiContext != null ? openApiContext.asyncReqId : 0L;
    }

    public static void setAsyncReqId(long asyncReqId) {
        OpenApiContext openApiContext = OpenApiContext.getContext();
        if (openApiContext != null) {
            openApiContext.asyncReqId = asyncReqId;
        }
    }

    private void put(String key, Object value) {
        this.contextMap.put(key, value);
    }

    private Object get(String key) {
        return this.contextMap.get(key);
    }

    public static void remove() {
        threadLocal.remove();
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getUrl() {
        return this.url;
    }

    public int getModelTimeCost() {
        return this.modelTimeCost;
    }

    public void setModelTimeCost(int modelTimeCost) {
        this.modelTimeCost = modelTimeCost;
    }
}

