/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.core;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.model.OpenApiAsyncStatusEnum;
import kd.bos.openapi.common.result.OpenApiAsyncResult;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.HttpParameterUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.context.ParameterHelper;
import kd.bos.openapi.kcf.controller.OpenApiController;
import kd.bos.openapi.kcf.core.OpenApiDispatcher;
import kd.bos.openapi.kcf.result.ResultProcessUtil;

public class AsynchronousDispatcher
implements OpenApiDispatcher {
    private static Log logger = LogFactory.getLog(AsynchronousDispatcher.class);
    private OpenApiController controller = null;
    private static final String QUERY_OPENAPI_TYPE = "queryOpenApiType";
    private static final String OPENAPI_REQID = "openApiReqId";
    private static final String TYPE_CHECK_STATUS = "checkStatus";
    private static final String TYPE_QUERY_RESULT = "queryResult";

    @Override
    public void processResult(ApiServiceData<Object> apiServiceData) {
        ResultProcessUtil.processResult(apiServiceData);
    }

    @Override
    public void setController(OpenApiController controller) {
        this.controller = controller;
    }

    @Override
    public ApiServiceData<Object> execute(HttpServletRequest req, HttpServletResponse resp) {
        long reqId = 0L;
        String queryOpenApiType = TYPE_CHECK_STATUS;
        Map queryStringMap = HttpParameterUtil.getQueryStringMap((String)OpenApiContext.getRequest().getQueryString());
        if (queryStringMap != null) {
            queryOpenApiType = (String)queryStringMap.get(QUERY_OPENAPI_TYPE);
            String reqIdStr = (String)queryStringMap.get(OPENAPI_REQID);
            try {
                reqId = DataUtil.l((Object)reqIdStr);
            }
            catch (Exception ignore) {
                reqId = 0L;
            }
        }
        if (reqId == 0L) {
            return this.putNewRequestToQueue(req, resp);
        }
        OpenApiContext.setAsyncReqId(reqId);
        if (TYPE_CHECK_STATUS.equalsIgnoreCase(queryOpenApiType)) {
            return this.getResultStatusFromQueue(req, resp, reqId, queryOpenApiType);
        }
        if (TYPE_QUERY_RESULT.equalsIgnoreCase(queryOpenApiType)) {
            return this.getResultFromDB(req, resp, reqId, queryOpenApiType);
        }
        String errMsg = "Bad Request - Unknown queryOpenApiType(" + queryOpenApiType + ")";
        OpenApiAsyncResult asyncResult = new OpenApiAsyncResult(reqId, OpenApiAsyncStatusEnum.NotFound.getStatus(), errMsg);
        OpenApiResponse response = new OpenApiResponse((Object)asyncResult, null);
        response.setHttpStatus(OpenApiAsyncStatusEnum.NotFound.getStatus());
        return ApiServiceData.ofFalse((String)OpenApiAsyncStatusEnum.NotFound.getStatusStr(), (String)errMsg, (OpenApiResponse)response, (long)0L);
    }

    private ApiServiceData<Object> putNewRequestToQueue(HttpServletRequest req, HttpServletResponse resp) {
        long reqId = ID.genLongId();
        OpenApiContext.setAsyncReqId(reqId);
        long apiId = OpenApiContext.getOpenApiData().getApiId();
        OpenApiRequest<Map<String, Object>> openApiRequest = ParameterHelper.getOpenApiRequest();
        ApiServiceType apiServiceType = OpenApiContext.getOpenApiData().getApiServiceType();
        OpenApiDataServiceFactory.getOpenApiAsyncDataService().saveNewRequest(apiServiceType, reqId, apiId, openApiRequest);
        ApiServiceData<Object> result = this.buildOpenApiAsyncStatus(reqId, OpenApiAsyncStatusEnum.Accepted);
        return result;
    }

    private ApiServiceData<Object> getResultStatusFromQueue(HttpServletRequest req, HttpServletResponse resp, long reqId, String queryOpenApiType) {
        ApiServiceData result = null;
        int asyncStatus = this.getResultStatusFromDB(reqId);
        String statusDesc = OpenApiAsyncStatusEnum.getOpenApiAsync((long)asyncStatus).getDesc();
        OpenApiAsyncResult asyncResult = new OpenApiAsyncResult(reqId, asyncStatus, statusDesc);
        OpenApiResponse response = new OpenApiResponse((Object)asyncResult, null);
        response.setHttpStatus(asyncStatus);
        result = ApiServiceData.ofTrue((OpenApiResponse)response, (long)0L);
        result.setErrorCode(String.valueOf(asyncStatus));
        result.setMessage(statusDesc);
        return result;
    }

    private ApiServiceData<Object> getResultFromDB(HttpServletRequest req, HttpServletResponse resp, long reqId, String queryOpenApiType) {
        ApiServiceData<Object> result = null;
        int asyncStatus = this.getResultStatusFromDB(reqId);
        result = asyncStatus == OpenApiAsyncStatusEnum.Accepted.getStatus() ? this.buildOpenApiAsyncStatus(reqId, OpenApiAsyncStatusEnum.Accepted) : (asyncStatus == OpenApiAsyncStatusEnum.Ready.getStatus() ? OpenApiDataServiceFactory.getOpenApiAsyncDataService().queryResult(reqId) : this.buildOpenApiAsyncStatus(reqId, OpenApiAsyncStatusEnum.NotFound));
        return result;
    }

    private int getResultStatusFromDB(long reqId) {
        return OpenApiDataServiceFactory.getOpenApiAsyncDataService().getResultStatus(reqId);
    }

    private ApiServiceData<Object> buildOpenApiAsyncStatus(long reqId, OpenApiAsyncStatusEnum asyncStatus) {
        OpenApiAsyncResult asyncResult = new OpenApiAsyncResult(reqId, asyncStatus.getStatus(), asyncStatus.getDesc());
        OpenApiResponse response = new OpenApiResponse((Object)asyncResult, null);
        response.setHttpStatus(asyncStatus.getStatus());
        ApiServiceData result = ApiServiceData.ofTrue((OpenApiResponse)response, (long)0L);
        result.setErrorCode(asyncStatus.getStatusStr());
        result.setMessage(asyncStatus.getDesc());
        return result;
    }
}

