/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.core;

import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.constant.HttpStatus;
import kd.bos.openapi.common.constant.PluginTypeEnum;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.controller.AIApiController;
import kd.bos.openapi.kcf.controller.CustomApiController;
import kd.bos.openapi.kcf.controller.CustomServletApiController;
import kd.bos.openapi.kcf.controller.MicroserviceController;
import kd.bos.openapi.kcf.controller.OpenApiController;
import kd.bos.openapi.kcf.controller.OperationApiController;
import kd.bos.openapi.kcf.controller.ScriptApiController;
import kd.bos.openapi.kcf.controller.WsdlApiController;
import kd.bos.openapi.kcf.mock.MockHttpServletRequest;
import kd.bos.openapi.kcf.utils.ApiStreamUtil;

public class OpenApiDeployment {
    private static Log logger = LogFactory.getLog(OpenApiDeployment.class);
    private static final String Key_API_PUBLISHTAG = "OpenApi.PublishTag";

    public static void initApiData() {
    }

    public static OpenApiController getOpenApiController(ApiServiceType apiType) {
        if (apiType == ApiServiceType.OPERATION) {
            return new OperationApiController();
        }
        if (apiType == ApiServiceType.AI) {
            return new AIApiController();
        }
        if (apiType == ApiServiceType.CUSTOM) {
            return new CustomApiController();
        }
        if (apiType == ApiServiceType.SCRIPT) {
            return new ScriptApiController();
        }
        if (apiType == ApiServiceType.CUSTSERVLET) {
            return new CustomServletApiController();
        }
        throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, "Unsupported Api Type", new Object[0]);
    }

    public static OpenApiController getOpenApiController(OpenApiData openApiData, String method, String url) {
        return OpenApiDeployment.getOpenApiController(openApiData, method, url, false);
    }

    public static OpenApiController getOpenApiController(OpenApiData openApiData, String method, String url, boolean isWsdl) {
        OpenApiDeployment.checkIP();
        if (!isWsdl) {
            OpenApiDeployment.checkACL(url);
        }
        if (openApiData == null) {
            ApiStreamUtil.sendStatus(HttpStatus.NOT_FOUND.getStatusCode());
            String msg = String.format("Cannot found OpenAPI(or disabled), url:%s", url);
            throw new OpenApiException(ApiErrorCode.HTTP_NOT_FOUND, msg, new Object[0]);
        }
        if (!isWsdl && openApiData.getHttpMethod() != HttpMethod.ALL && method.compareToIgnoreCase(openApiData.getHttpMethod().getName()) != 0) {
            ApiStreamUtil.sendStatus(HttpStatus.NOT_ALLOWED.getStatusCode());
            throw new OpenApiException(ApiErrorCode.HTTP_NOT_ALLOWED, "HttpMethod " + method + " is not allowed.", new Object[0]);
        }
        if (isWsdl) {
            return new WsdlApiController();
        }
        if (openApiData.getApiServiceType() == ApiServiceType.CUSTOM && PluginTypeEnum.MSERVICE.getValue().equals(openApiData.getPlugintype())) {
            return new MicroserviceController();
        }
        return OpenApiDeployment.getOpenApiController(openApiData.getApiServiceType());
    }

    public static void checkACL(String url) {
        HashMap<String, String> options = new HashMap<String, String>(1);
        if (OpenApiContext.getRequest() instanceof MockHttpServletRequest) {
            options.put("httpRequest", "MockHttpServletRequest");
        }
        OpenApiDataServiceFactory.getOpenApiDataService().checkThirdACL(url, options);
    }

    public static void checkIP() {
        OpenApiDataServiceFactory.getOpenApiDataService().checkClientIP();
    }
}

