/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.kcf.spi.OpenApiServletService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.model.OpenApiLogModel;
import kd.bos.openapi.common.model.OpenApiStatModel;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.context.ParameterHelper;
import kd.bos.openapi.kcf.controller.OpenApiController;
import kd.bos.openapi.kcf.core.AsynchronousDispatcher;
import kd.bos.openapi.kcf.core.OpenApiDeployment;
import kd.bos.openapi.kcf.core.OpenApiDispatcher;
import kd.bos.openapi.kcf.core.SynchronousDispatcher;
import kd.bos.openapi.kcf.result.ResultProcessUtil;
import kd.bos.openapi.kcf.utils.DesensitizeUtil;
import kd.bos.openapi.kcf.utils.IdempotencyUtil;
import kd.bos.openapi.kcf.utils.WsdlUtil;

public class OpenApiServlet
implements OpenApiServletService {
    private static Log log = LogFactory.getLog(OpenApiServlet.class);

    public static void init() {
        try {
            OpenApiDeployment.initApiData();
        }
        catch (Exception ex) {
            log.error("OpenApi-An error occurred while initializing the openApiData: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction(HttpServletRequest req, HttpServletResponse resp) {
        long timeST = System.currentTimeMillis();
        String openapiDataUrl = ApiDataUtil.getApiUrl((HttpServletRequest)req);
        OpenApiContext apiContext = new OpenApiContext(req, resp, openapiDataUrl);
        OpenApiContext.set(apiContext);
        OpenApiDataService openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService();
        OpenApiData openApiData = null;
        OpenApiDispatcher openApiDispatcher = null;
        try {
            if (openApiDataService == null) {
                throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the OpenApiDataService.", new Object[0]);
            }
            openApiData = openApiDataService.getOpenApiData(openapiDataUrl);
            OpenApiContext.setOpenApiData(openApiData);
            openApiData.setAcceptCharset(OpenApiContext.getRequestHeader("Content-Type"), OpenApiContext.getRequestHeader("Accept-Charset"));
            boolean isWsdl = WsdlUtil.isWsdl(req);
            openApiDispatcher = openApiData.isAsync() && !isWsdl ? new AsynchronousDispatcher() : new SynchronousDispatcher();
            String requestMethod = req.getMethod();
            OpenApiController controller = OpenApiDeployment.getOpenApiController(openApiData, requestMethod, openApiData.getUrl(), isWsdl);
            openApiDispatcher.setController(controller);
            if (controller != null) {
                if (controller.isDefaultProcessor()) {
                    ParameterHelper.processParameter();
                }
                OpenApiDispatcher finalOpenApiDispatcher = openApiDispatcher;
                IdempotencyUtil.doIdempotency(req, openApiData, () -> {
                    ApiServiceData<Object> apiServiceData = finalOpenApiDispatcher.execute(req, resp);
                    if (controller.isDefaultProcessor()) {
                        finalOpenApiDispatcher.processResult(apiServiceData);
                    }
                    return null;
                });
            }
        }
        catch (Throwable ex) {
            OpenApiContext.getContext().setException(ex);
            ResultProcessUtil.processException();
        }
        finally {
            int timeCost = (int)(System.currentTimeMillis() - timeST);
            this.writeApiLog(openapiDataUrl, openApiData, timeCost);
            OpenApiContext.close();
        }
    }

    private void writeApiLog(String reqUrl, OpenApiData openApiData, int timeCost) {
        try {
            this.writeApiStatLog(reqUrl, openApiData, timeCost);
        }
        catch (Throwable ex) {
            log.error("OpenApi-An error occurred while writing the ApiStatLog:" + ex.getMessage(), ex);
        }
        try {
            this.writeApiOperationLog(reqUrl, openApiData, timeCost);
        }
        catch (Throwable ex) {
            log.error("OpenApi-An error occurred while writing the ApiOperationLog:" + ex.getMessage(), ex);
        }
    }

    private void writeApiOperationLog(String reqUrl, OpenApiData openApiData, int timeCost) {
        String apiLogLevel = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_log_level", "summary");
        if ("none".equals(apiLogLevel)) {
            return;
        }
        OpenApiLogModel logModel = new OpenApiLogModel();
        logModel.setTimeCost(timeCost);
        logModel.setUrl(reqUrl);
        logModel.setHttpStatus(Integer.valueOf(OpenApiContext.getResponse().getStatus()));
        logModel.setErrorCode(OpenApiContext.getResult().getErrorCode());
        long asyncReqId = OpenApiContext.getAsyncReqId();
        logModel.setAsyncReqId(asyncReqId);
        if (openApiData != null) {
            logModel.setUrl(reqUrl);
            logModel.setApiId(openApiData.getApiId());
            logModel.setCloudId(openApiData.getCloudId());
            logModel.setAppId(openApiData.getAppId());
            logModel.setApiNumber(openApiData.getApiNumber());
            logModel.setBizObject(openApiData.getBizObject());
            logModel.setModelTimeCost(OpenApiContext.getContext().getModelTimeCost());
            logModel.setInDigestTemplate(openApiData.getInDigestTemplate());
            logModel.setOutDigestTemplate(openApiData.getOutDigestTemplate());
            logModel.setApiName(openApiData.getApiNameML().getLocaleValue());
        }
        OpenApiContext.getContext();
        logModel.setSignAuth("5".equals(OpenApiContext.getRequest().getHeader("openApiAuth")));
        OpenApiResult result = OpenApiContext.getResult();
        if (result != null) {
            logModel.setStatus(result.isStatus());
            String errMsg = result.getMessage() == null ? "" : result.getMessage();
            logModel.setErrMsg(errMsg);
            if ("detail".equals(apiLogLevel) || "full".equals(apiLogLevel)) {
                String response = OpenApiContext.getOutputParameter();
                String request = OpenApiContext.getInputParameter();
                if (StringUtil.isEmpty((String)request)) {
                    request = OpenJsonUtil.toJson(ParameterHelper.getRequestParameter());
                }
                String contextType = "[ContentType:" + (OpenApiContext.getRequest() == null ? "" : OpenApiContext.getRequestHeader("Content-Type")) + ", " + "Idempotency-Key" + ":" + (OpenApiContext.getRequest() == null ? "" : OpenApiContext.getRequestHeader("Idempotency-Key")) + "] " + "\n";
                String accept = "[Accept:" + (OpenApiContext.getRequest() == null ? "" : OpenApiContext.getRequestHeader("Accept") + ",Accept-Charset:" + OpenApiContext.getRequestHeader("Accept-Charset")) + "] " + "\n";
                logModel.setRequest(contextType + DesensitizeUtil.handleRequestDesensitize(request, openApiData));
                logModel.setResponse(accept + response);
            }
        }
        OpenApiDataServiceFactory.getOpenApiDataService().writeApiOperationLog(reqUrl, logModel);
    }

    private void writeApiStatLog(String reqUrl, OpenApiData openApiData, int timeCost) {
        if (openApiData != null) {
            OpenApiStatModel statModel = new OpenApiStatModel(openApiData.getApiId(), openApiData.getApiNumber(), OpenApiContext.getResult().isStatus(), timeCost);
            OpenApiDataServiceFactory.getOpenApiDataService().writeApiStatData(openApiData.getApiId(), statModel);
        }
    }

    static {
        OpenApiServlet.init();
    }
}

