/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.interceptor;

import java.util.ArrayList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.kcf.interceptor.OpenApiInterceptor;
import kd.bos.openapi.kcf.utils.ApiUtil;
import kd.bos.util.StringUtils;

public class InterceptorProxy {
    private static Log logger = LogFactory.getLog(InterceptorProxy.class);
    private static ArrayList<OpenApiInterceptor> preDefaultIntercepters = new ArrayList();
    private static ArrayList<OpenApiInterceptor> postDefaultIntercepters = new ArrayList();
    private ArrayList<OpenApiInterceptor> prePluginIntercepters;
    private ArrayList<OpenApiInterceptor> postPluginIntercepters;

    public InterceptorProxy(String prePluginInterceptors, String postPluginInterceptors) {
        this.initPluginInterceptor(prePluginInterceptors, postPluginInterceptors);
    }

    private void initPluginInterceptor(String prePluginInterceptors, String postPluginInterceptors) {
        this.prePluginIntercepters = InterceptorProxy.getInterceptorsFromClass(prePluginInterceptors);
        this.postPluginIntercepters = InterceptorProxy.getInterceptorsFromClass(postPluginInterceptors);
    }

    public void preInvoke() {
        this.execute(this.prePluginIntercepters);
        this.execute(preDefaultIntercepters);
    }

    public void postInvoke() {
        this.execute(postDefaultIntercepters);
        this.execute(this.postPluginIntercepters);
    }

    private static ArrayList<OpenApiInterceptor> getInterceptorsFromClass(String intercetors) {
        ArrayList<OpenApiInterceptor> result = new ArrayList<OpenApiInterceptor>();
        if (StringUtils.isNotEmpty((String)intercetors)) {
            String[] classes_interceptors;
            for (String cls : classes_interceptors = intercetors.split(",")) {
                OpenApiInterceptor interceptor = (OpenApiInterceptor)ApiUtil.newInstance(cls.trim());
                result.add(interceptor);
            }
        }
        return result;
    }

    private void execute(ArrayList<OpenApiInterceptor> intercepters) {
        if (intercepters == null) {
            return;
        }
        for (OpenApiInterceptor itc : intercepters) {
            itc.execute();
        }
    }
}

