/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.result;

import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import kd.bos.openapi.api.model.ApiSerializerModel;
import kd.bos.openapi.api.model.ApiSerializerVersion;
import kd.bos.openapi.api.plugin.SerializerResult;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.context.ParameterHelper;
import kd.bos.openapi.kcf.mock.MockHttpServletResponse;
import kd.bos.openapi.kcf.result.ResultHandler;
import kd.bos.openapi.kcf.utils.ApiPluginRpcHelper;
import kd.bos.openapi.kcf.utils.ApiStreamUtil;
import kd.bos.openapi.kcf.utils.OpenApiExceptionUtil;

public class ApiSerializerPluginResultHandler
implements ResultHandler {
    private final String accept;
    private final String contentType;
    private String serializerPlugin;

    public ApiSerializerPluginResultHandler(String accept, String contentType, String serializerPlugin) {
        this(accept, contentType);
        this.serializerPlugin = serializerPlugin;
    }

    @Deprecated
    public ApiSerializerPluginResultHandler(String accept, String contentType) {
        this.accept = accept;
        this.contentType = contentType;
    }

    @Override
    public void handleResult(Object resultData) {
        HttpServletResponse resp = OpenApiContext.getResponse();
        this.handleResult(resultData, resp);
    }

    @Override
    public void handleResult(Object resultData, HttpServletResponse resp) {
        SerializerResult serialize;
        block7: {
            OpenApiData openApiData = OpenApiContext.getOpenApiData();
            if (openApiData == null || this.serializerPlugin == null) {
                throw new NullPointerException(ApiSerializerPluginResultHandler.class.getSimpleName());
            }
            Map pluginOriginTypeMap = openApiData.getPluginOriginTypeMap();
            Integer pluginOriginType = (Integer)pluginOriginTypeMap.get(this.serializerPlugin);
            try {
                ApiSerializerVersion version = ApiPluginRpcHelper.getSerializeVersion(openApiData.getAppId(), this.serializerPlugin, pluginOriginType, new Object[0]);
                if (ApiSerializerVersion.DEFAULT == version) {
                    serialize = this.handleResultWithoutException(() -> (SerializerResult)ApiPluginRpcHelper.serialize(openApiData.getAppId(), this.serializerPlugin, pluginOriginType, resultData, this.accept, this.contentType));
                    break block7;
                }
                if (ApiSerializerVersion.MODEL == version) {
                    HashMap<String, Object> map = new HashMap<String, Object>(5);
                    map.put("response", resultData);
                    map.put("accept", this.accept);
                    map.put("contentType", this.contentType);
                    map.put("reqData", Collections.unmodifiableMap(ParameterHelper.getRequestParameter()));
                    ApiSerializerModel model = new ApiSerializerModel(Collections.unmodifiableMap(map));
                    serialize = this.handleResultWithoutException(() -> (SerializerResult)ApiPluginRpcHelper.serializeByModel(openApiData.getAppId(), this.serializerPlugin, pluginOriginType, model));
                    break block7;
                }
                throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, "Unsupported plugin version", new Object[0]);
            }
            catch (Exception e) {
                OpenApiResult result = new OpenApiResult(false, ApiErrorCode.PLUGIN_ERROR.getStatusCode(), OpenApiExceptionUtil.getExceptionMessage(e), null);
                serialize = new SerializerResult("application/json", OpenJsonUtil.toJson((Object)result));
            }
        }
        OpenApiContext.setOutputParameter(serialize.getResult());
        if (resp instanceof MockHttpServletResponse) {
            MockHttpServletResponse mockResp = (MockHttpServletResponse)resp;
            mockResp.setContentType(serialize.getContentType());
            mockResp.setData(serialize.getResult());
        } else {
            ApiStreamUtil.writeData(serialize.getResult(), resp, serialize.getContentType());
        }
    }

    private SerializerResult handleResultWithoutException(Supplier<SerializerResult> serializePlugin) {
        try {
            return serializePlugin.get();
        }
        catch (Throwable e) {
            OpenApiResult result = new OpenApiResult(false, ApiErrorCode.PLUGIN_ERROR.getStatusCode(), OpenApiExceptionUtil.getExceptionMessage(e), null);
            return new SerializerResult("application/json", JsonUtil.toJsonString((Object)result, (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

