/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.kcf.spi.CustomAction;
import kd.bos.openapi.kcf.spi.MicroserviceAction;
import kd.bos.openapi.kcf.spi.OperationAction;
import kd.bos.openapi.kcf.spi.ScriptAction;
import kd.bos.openapi.kcf.spi.WsdlAction;
import kd.bos.openapi.security.ApiGateService;
import kd.bos.openapi.security.ApiSecurityService;
import kd.bos.openapi.security.auth.OpenApiAuthService;
import kd.bos.openapi.security.oauth.token.TokenFacadeService;

public class OpenApiServiceManager {
    private static Log log = LogFactory.getLog(OpenApiServiceManager.class);
    private static OperationAction operationAction = (OperationAction)OpenApiServiceManager.loadService(OperationAction.class);
    private static CustomAction customAction = (CustomAction)OpenApiServiceManager.loadService(CustomAction.class);
    private static WsdlAction wsdlAction = (WsdlAction)OpenApiServiceManager.loadService(WsdlAction.class);
    private static ScriptAction scriptAction = (ScriptAction)OpenApiServiceManager.loadService(ScriptAction.class);
    private static MicroserviceAction microserviceAction;
    private static ApiSecurityService apiSecurityService;
    private static OpenApiAuthService openApiAuthService;
    private static ApiGateService apiGateService;
    private static TokenFacadeService tokenFacadeService;

    private static Object loadService(Class<?> clazz) {
        ServiceLoader<?> loadedService = ServiceLoader.load(clazz);
        Iterator<?> serviceIterator = loadedService.iterator();
        try {
            if (serviceIterator.hasNext()) {
                return serviceIterator.next();
            }
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "Cannot found ServiceImpl:" + clazz.getCanonicalName(), new Object[0]);
        }
        catch (Throwable e) {
            log.warn("An error occurred while creating the OpenApiServiceManager:", e);
            return null;
        }
    }

    public static OperationAction getOperationAction() {
        if (operationAction == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the OperationAction.", new Object[0]);
        }
        return operationAction;
    }

    public static CustomAction getCustomAction() {
        if (customAction == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the CustomAction.", new Object[0]);
        }
        return customAction;
    }

    public static ScriptAction getScriptAction() {
        if (scriptAction == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the ScriptAction.", new Object[0]);
        }
        return scriptAction;
    }

    public static MicroserviceAction getMicroserviceAction() {
        if (microserviceAction == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the MicroserviceAction.", new Object[0]);
        }
        return microserviceAction;
    }

    public static WsdlAction getWsdlAction() {
        if (wsdlAction == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the WsdlAction.", new Object[0]);
        }
        return wsdlAction;
    }

    public static ApiSecurityService getApiSecurityService() {
        if (apiSecurityService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the apiSecurityService.", new Object[0]);
        }
        return apiSecurityService;
    }

    public static OpenApiAuthService getOpenApiAuthService() {
        if (openApiAuthService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the openApiAuthService.", new Object[0]);
        }
        return openApiAuthService;
    }

    public static ApiGateService getApiGateService() {
        if (apiGateService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the apiGateService.", new Object[0]);
        }
        return apiGateService;
    }

    public static TokenFacadeService getTokenFacadeService() {
        if (tokenFacadeService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the tokenFacadeService.", new Object[0]);
        }
        return tokenFacadeService;
    }

    static {
        apiSecurityService = (ApiSecurityService)OpenApiServiceManager.loadService(ApiSecurityService.class);
        openApiAuthService = (OpenApiAuthService)OpenApiServiceManager.loadService(OpenApiAuthService.class);
        apiGateService = (ApiGateService)OpenApiServiceManager.loadService(ApiGateService.class);
        tokenFacadeService = (TokenFacadeService)OpenApiServiceManager.loadService(TokenFacadeService.class);
        microserviceAction = (MicroserviceAction)OpenApiServiceManager.loadService(MicroserviceAction.class);
    }
}

