/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiLogModel;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.security.model.TokenUrlEnum;

public class ApiAuthLogUtil {
    private static final Log log = LogFactory.getLog(ApiAuthLogUtil.class);
    private static final String DISP = "******";
    public static Set<String> sensitizeFieldSet = new HashSet<String>();

    public static void writeAuthApiLog(String reqUrl, int timeCost) {
        try {
            String apiLogLevel = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_log_level", "summary");
            if ("none".equals(apiLogLevel)) {
                return;
            }
            OpenApiLogModel logModel = new OpenApiLogModel();
            logModel.setTimeCost(timeCost);
            logModel.setUrl(reqUrl);
            logModel.setHttpStatus((Integer)OpenApiAuthContext.getContext().getParamExt("httpStatus"));
            logModel.setErrorCode((String)OpenApiAuthContext.getContext().getParamExt("errorCode"));
            logModel.setStatus(((Boolean)OpenApiAuthContext.getContext().getParamExt("status")).booleanValue());
            logModel.setErrMsg((String)OpenApiAuthContext.getContext().getParamExt("errMsgLog"));
            String appNumber = "401";
            if (TokenUrlEnum.getToken((String)reqUrl) != null) {
                appNumber = TokenUrlEnum.getToken((String)reqUrl).getType();
            } else if (reqUrl != null && reqUrl.length() > 120) {
                appNumber = reqUrl.substring(0, 120);
            }
            logModel.setApiNumber(appNumber);
            if ("detail".equals(apiLogLevel) || "full".equals(apiLogLevel)) {
                String response = (String)OpenApiAuthContext.getContext().getParamExt("response");
                String request = OpenApiAuthContext.getContext().getBody();
                if (StringUtil.isEmpty((String)request)) {
                    request = JacksonUtil.writeValueAsPrettyString(OpenApiAuthContext.getContext().getQueryMap());
                }
                request = ApiAuthLogUtil.desensitizeHandle(request);
                response = ApiAuthLogUtil.desensitizeHandle(response);
                String contextType = "[ContentType:" + (OpenApiAuthContext.getContext().getHeaders() == null ? "" : OpenApiAuthContext.getContext().getHeaders().get("Content-Type")) + "] " + "\n";
                String accept = "[Accept:" + (OpenApiAuthContext.getContext().getHeaders() == null ? "" : OpenApiAuthContext.getContext().getHeaders().get("Accept")) + "] " + "\n";
                logModel.setRequest(contextType + request);
                logModel.setResponse(accept + response);
            }
            OpenApiDataServiceFactory.getOpenApiDataService().writeApiOperationLog(reqUrl, logModel);
        }
        catch (Exception e) {
            log.info("error:" + e.getMessage(), (Object)e);
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "writeApiLog error\uff1a" + e.getMessage(), new Object[]{e});
        }
    }

    private static String desensitizeHandle(String jsonString) {
        if (StringUtil.isEmpty((String)jsonString)) {
            return jsonString;
        }
        Object jsonObject = JacksonUtil.readValue((String)jsonString, Object.class);
        if (jsonObject == null) {
            return jsonString;
        }
        ApiAuthLogUtil.updateDesensitizeValue(jsonObject, 0);
        return JacksonUtil.writeValueAsPrettyString((Object)jsonObject);
    }

    private static void updateDesensitizeValue(Object jsonObject, int level) {
        block8: {
            block7: {
                if (level > 6) {
                    return;
                }
                if (!(jsonObject instanceof List)) break block7;
                List list = (List)jsonObject;
                if (!CollectionUtil.isNotEmpty((Collection)list)) break block8;
                for (int i = 0; i < list.size(); ++i) {
                    Map itemMap;
                    Object e = list.get(i);
                    if (!(e instanceof Map) || (itemMap = (Map)e) == null || itemMap.size() <= 0) continue;
                    for (Map.Entry<String, Object> entry : itemMap.entrySet()) {
                        Object obj = entry.getValue();
                        if (obj == null) continue;
                        if (obj instanceof List || obj instanceof Map) {
                            ApiAuthLogUtil.updateDesensitizeValue(obj, ++level);
                            continue;
                        }
                        if (!(obj instanceof String)) continue;
                        ApiAuthLogUtil.replaceSensitizeField(entry);
                    }
                }
                break block8;
            }
            if (jsonObject instanceof Map) {
                Map map = (Map)jsonObject;
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    Object obj = entry.getValue();
                    if (obj == null) continue;
                    if (obj instanceof List || obj instanceof Map) {
                        ApiAuthLogUtil.updateDesensitizeValue(obj, ++level);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    ApiAuthLogUtil.replaceSensitizeField(entry);
                }
            }
        }
    }

    private static void replaceSensitizeField(Map.Entry<String, Object> entry) {
        String key = entry.getKey();
        if (!sensitizeFieldSet.contains(key.toLowerCase(Locale.ENGLISH))) {
            return;
        }
        String value = (String)entry.getValue();
        if (value.length() > 3) {
            entry.setValue(value.substring(0, 3) + DISP + value.substring(value.length() - 3));
        } else {
            entry.setValue(DISP);
        }
    }

    public static String replaceSensitizeField(String key, String value) {
        if (!sensitizeFieldSet.contains(key.toLowerCase(Locale.ENGLISH))) {
            return value;
        }
        String newValue = value;
        newValue = value.length() > 3 ? value.substring(0, 3) + DISP + value.substring(value.length() - 3) : DISP;
        return newValue;
    }

    static {
        sensitizeFieldSet.add("client_secret");
        sensitizeFieldSet.add("access_token");
        sensitizeFieldSet.add("accesstoken");
        sensitizeFieldSet.add("id_token");
        sensitizeFieldSet.add("refresh_token");
        sensitizeFieldSet.add("token");
        sensitizeFieldSet.add("password");
    }
}

