/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.OpenApiFile;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.IOUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.fileupload.FileItem;

@SdkInternal
public class ApiStreamUtil {
    private static final String KEY_OPENAPI_MAX_FILESIZE = "OpenApi.FileItem.MaxSize";
    private static final int FILESTREAM_MAXLENGTH = 0x3200000;

    public static void sendStatus(int statusCode, HttpServletResponse resp) {
        try {
            if (resp != null) {
                resp.setStatus(statusCode);
            }
        }
        catch (Exception ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_INTERNAL_ERROR, ex.getMessage(), new Object[0]);
        }
    }

    public static void writeData(String data, HttpServletResponse response, String contentType) {
        OutputStreamWriter writer = null;
        try {
            if (StringUtil.isEmpty((String)data)) {
                response.setContentLength(0);
            } else {
                response.setContentType(contentType);
                response.setCharacterEncoding(ApiStreamUtil.getAcceptCharset().displayName());
                writer = ApiStreamUtil.getWriter(response);
                String streamData = ApiStreamUtil.getValidData(data);
                writer.write(streamData);
                writer.flush();
            }
        }
        catch (IOException ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_INTERNAL_ERROR, ex.getMessage(), new Object[0]);
        }
        finally {
            IOUtil.closeQuietly(writer);
        }
    }

    private static String getValidData(String data) {
        if (data != null && data.length() > 0) {
            return data.substring(0);
        }
        return data;
    }

    private static OutputStreamWriter getWriter(HttpServletResponse response) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), ApiStreamUtil.getAcceptCharset());
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{e.getMessage()});
        }
        return writer;
    }

    public static Charset getAcceptCharset() {
        return OpenApiContext.getOpenApiData() != null ? OpenApiContext.getOpenApiData().getAcceptCharset() : StandardCharsets.UTF_8;
    }

    public static void openAttachment(OpenApiFile fileResult, HttpServletResponse response) throws IOException {
        String fileName = URLEncoder.encode(fileResult.getFileName(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
        String fileType = fileResult.getContentType();
        if (!StringUtil.isEmpty((String)fileType)) {
            response.setHeader("Content-Type", fileResult.getContentType());
        }
        ApiStreamUtil.writeStreamResponse(fileResult.getFileData(), response);
    }

    public static void downloadAttachment(OpenApiFile fileResult, HttpServletResponse response) throws IOException {
        response.setHeader("Pragma", "No-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/octet-stream;charset=UTF-8");
        String fileName = URLEncoder.encode(fileResult.getFileName(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
        ApiStreamUtil.writeStreamResponse(fileResult.getFileData(), response);
    }

    private static void writeStreamResponse(byte[] data, HttpServletResponse resp) throws IOException {
        ServletOutputStream out = null;
        try {
            out = resp.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            IOUtil.closeQuietly((Closeable)out);
        }
    }

    public static byte[] getBytesByFileItem(FileItem fileItem) throws IOException {
        String maxSizeStr = McConfigUtil.getPropertyByCurrTenant((String)KEY_OPENAPI_MAX_FILESIZE, (String)String.valueOf(0x3200000));
        long maxSize = DataUtil.l((Object)maxSizeStr);
        long size = fileItem.getSize();
        if (size >= maxSize) {
            String msg = String.format("The maximum allowed FileStream length is %s bytes, but the current file size is %s bytes.", maxSize, size);
            throw new OpenApiException(ApiErrorCode.HTTP_BODY_TOO_LARGE, msg, new Object[0]);
        }
        InputStream stream = fileItem.getInputStream();
        byte[] data = IOUtil.getByteArray((InputStream)stream);
        fileItem.delete();
        return data;
    }

    public static void sendStatus(int statusCode) {
        HttpServletResponse resp = OpenApiContext.getResponse();
        ApiStreamUtil.sendStatus(statusCode, resp);
    }

    public static int getStatus() {
        return OpenApiContext.getResponse() != null ? OpenApiContext.getResponse().getStatus() : 0;
    }
}

